/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.generator.bean.field;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.generator.annotation.spec.XmlAnyElementWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlAttributeWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlElementRefWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlElementRefsWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlElementWrapperWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlElementWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlElementsWriter;
import com.sun.tools.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CElement;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.model.CTypeRef;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldAccessor;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.reader.TypeUtil;
import com.sun.xml.bind.v2.TODO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.W3CDomHandler;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractField
implements FieldOutline {
    protected final ClassOutlineImpl outline;
    protected final CPropertyInfo prop;
    protected final JCodeModel codeModel;
    protected final JType implType;
    protected final JType exposedType;
    private XmlElementsWriter xesw = null;

    protected AbstractField(ClassOutlineImpl outline, CPropertyInfo prop) {
        this.outline = outline;
        this.prop = prop;
        this.codeModel = outline.parent().getCodeModel();
        this.implType = this.getType(Aspect.IMPLEMENTATION);
        this.exposedType = this.getType(Aspect.EXPOSED);
    }

    @Override
    public final ClassOutline parent() {
        return this.outline;
    }

    @Override
    public final CPropertyInfo getPropertyInfo() {
        return this.prop;
    }

    protected void annotate(JAnnotatable field) {
        assert (field != null);
        if (this.prop instanceof CAttributePropertyInfo) {
            this.annotateAttribute(field);
        } else if (this.prop instanceof CElementPropertyInfo) {
            this.annotateElement(field);
        } else if (this.prop instanceof CValuePropertyInfo) {
            field.annotate(XmlValue.class);
        } else if (this.prop instanceof CReferencePropertyInfo) {
            this.annotateReference(field);
        }
        this.outline.parent().generateAdapterIfNecessary(this.prop, field);
    }

    private void annotateReference(JAnnotatable field) {
        NClass dh;
        CReferencePropertyInfo rp = (CReferencePropertyInfo)this.prop;
        TODO.prototype();
        Set<CElement> elements = rp.getElements();
        if (elements.size() == 1) {
            XmlElementRefWriter refw = field.annotate2(XmlElementRefWriter.class);
            CElement e = (CElement)elements.iterator().next();
            refw.name(e.getElementName().getLocalPart()).namespace(e.getElementName().getNamespaceURI()).type(((NType)e.getType()).toType(this.outline.parent(), Aspect.IMPLEMENTATION));
        } else if (elements.size() > 1) {
            XmlElementRefsWriter refsw = field.annotate2(XmlElementRefsWriter.class);
            for (CElement e : elements) {
                XmlElementRefWriter refw = refsw.value();
                refw.name(e.getElementName().getLocalPart()).namespace(e.getElementName().getNamespaceURI()).type(((NType)e.getType()).toType(this.outline.parent(), Aspect.IMPLEMENTATION));
            }
        }
        if (rp.isMixed()) {
            field.annotate(XmlMixed.class);
        }
        if ((dh = rp.getDOMHandler()) != null) {
            XmlAnyElementWriter xaew = field.annotate2(XmlAnyElementWriter.class);
            xaew.lax(rp.getWildcard().allowTypedObject);
            JClass value = dh.toType(this.outline.parent(), Aspect.IMPLEMENTATION);
            if (!value.equals(this.codeModel.ref(W3CDomHandler.class))) {
                xaew.value(value);
            }
        }
    }

    private void annotateElement(JAnnotatable field) {
        CElementPropertyInfo ep = (CElementPropertyInfo)this.prop;
        List<CTypeRef> types = ep.getTypes();
        QName eName = ep.getXmlName();
        if (ep.isValueList()) {
            field.annotate(XmlList.class);
        }
        if (eName != null) {
            XmlElementWrapperWriter xcw = field.annotate2(XmlElementWrapperWriter.class);
            xcw.name(eName.getLocalPart()).namespace(eName.getNamespaceURI());
        }
        if (types.size() == 1) {
            CTypeRef t = types.get(0);
            this.writeXmlElementAnnotation(field, t, this.resolve(t, Aspect.IMPLEMENTATION), false);
        } else {
            for (CTypeRef t : types) {
                this.writeXmlElementAnnotation(field, t, this.resolve(t, Aspect.IMPLEMENTATION), true);
            }
            this.xesw = null;
        }
    }

    private void writeXmlElementAnnotation(JAnnotatable field, CTypeRef ctype, JType jtype, boolean checkWrapper) {
        String defaultValue;
        CElementPropertyInfo ep;
        XmlElementWriter xew = null;
        XmlNsForm formDefault = this.parent()._package().getElementFormDefault();
        String mostUsedURI = this.parent()._package().getMostUsedNamespaceURI();
        String propName = this.prop.getName(false);
        String generatedName = ctype.getTagName().getLocalPart();
        if (!generatedName.equals(propName)) {
            if (xew == null) {
                xew = this.getXew(checkWrapper, field);
            }
            xew.name(generatedName);
        }
        String generatedNS = ctype.getTagName().getNamespaceURI();
        if (formDefault == XmlNsForm.QUALIFIED && !generatedNS.equals(mostUsedURI) || formDefault == XmlNsForm.UNQUALIFIED && !generatedNS.equals("")) {
            if (xew == null) {
                xew = this.getXew(checkWrapper, field);
            }
            xew.namespace(generatedNS);
        }
        if ((ep = (CElementPropertyInfo)this.prop).isRequired() && this.exposedType.isReference()) {
            if (xew == null) {
                xew = this.getXew(checkWrapper, field);
            }
            xew.required(true);
        }
        if (ep.isRequired() && !this.prop.isCollection()) {
            jtype = jtype.unboxify();
        }
        if (!jtype.equals(this.exposedType) || this.parent().parent().getModel().options.runtime14 && this.prop.isCollection()) {
            if (xew == null) {
                xew = this.getXew(checkWrapper, field);
            }
            xew.type(jtype);
        }
        if ((defaultValue = ctype.getDefaultValue()) != null) {
            if (xew == null) {
                xew = this.getXew(checkWrapper, field);
            }
            xew.defaultValue(defaultValue);
        }
        if (ctype.isNillable()) {
            if (xew == null) {
                xew = this.getXew(checkWrapper, field);
            }
            xew.nillable(true);
        }
    }

    private XmlElementWriter getXew(boolean checkWrapper, JAnnotatable field) {
        XmlElementWriter xew;
        if (checkWrapper) {
            if (this.xesw == null) {
                this.xesw = field.annotate2(XmlElementsWriter.class);
            }
            xew = this.xesw.value();
        } else {
            xew = field.annotate2(XmlElementWriter.class);
        }
        return xew;
    }

    private void annotateAttribute(JAnnotatable field) {
        CAttributePropertyInfo ap = (CAttributePropertyInfo)this.prop;
        QName attName = ap.getXmlName();
        XmlAttributeWriter xaw = field.annotate2(XmlAttributeWriter.class);
        String generatedName = attName.getLocalPart();
        String generatedNS = attName.getNamespaceURI();
        if (!generatedName.equals(ap.getName(false))) {
            xaw.name(generatedName);
        }
        if (!generatedNS.equals("")) {
            xaw.namespace(generatedNS);
        }
        if (ap.isRequired()) {
            xaw.required(true);
        }
    }

    protected final JFieldVar generateField(JType type) {
        return this.outline.implClass.field(2, type, this.prop.getName(false));
    }

    protected final JExpression castToImplType(JExpression exp) {
        if (this.implType == this.exposedType) {
            return exp;
        }
        return JExpr.cast(this.implType, exp);
    }

    protected JType getType(final Aspect aspect) {
        if (this.prop.getAdapter() != null) {
            return ((NType)this.prop.getAdapter().customType).toType(this.outline.parent(), aspect);
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class TypeList
        extends ArrayList<JType> {
            TypeList() {
            }

            void add(CTypeInfo t) {
                this.add(((NType)t.getType()).toType(AbstractField.this.outline.parent(), aspect));
                if (t instanceof CElementInfo) {
                    this.add(((CElementInfo)t).getSubstitutionMembers());
                }
            }

            void add(Collection<? extends CTypeInfo> col) {
                for (CTypeInfo cTypeInfo : col) {
                    this.add(cTypeInfo);
                }
            }
        }
        TypeList r = new TypeList();
        r.add(this.prop.ref());
        JType t = this.prop.baseType != null ? this.prop.baseType : TypeUtil.getCommonBaseType(this.codeModel, r);
        if (this.prop.isUnboxable()) {
            t = t.unboxify();
        }
        return t;
    }

    protected final List<Object> listPossibleTypes(CPropertyInfo prop) {
        ArrayList<Object> r = new ArrayList<Object>();
        for (CTypeInfo cTypeInfo : prop.ref()) {
            JType t = ((NType)cTypeInfo.getType()).toType(this.outline.parent(), Aspect.EXPOSED);
            if (t.isPrimitive() || t.isArray()) {
                r.add(t.fullName());
                continue;
            }
            r.add(t);
            r.add("\n");
        }
        return r;
    }

    private JType resolve(CTypeRef typeRef, Aspect a) {
        return this.outline.parent().resolve(typeRef, a);
    }

    protected abstract class Accessor
    implements FieldAccessor {
        protected final JExpression $target;

        protected Accessor(JExpression $target) {
            this.$target = $target;
        }

        public final FieldOutline owner() {
            return AbstractField.this;
        }

        public final CPropertyInfo getPropertyInfo() {
            return AbstractField.this.prop;
        }
    }
}

