% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wm_synonyms.R
\name{wm_synonyms}
\alias{wm_synonyms}
\alias{wm_synonyms_}
\title{Get synonyms for an AphiaID}
\usage{
wm_synonyms(id, ...)

wm_synonyms_(id = NULL, name = NULL, ...)
}
\arguments{
\item{id}{(numeric/integer) an AphiaID. For \code{wm_synonyms} it's required
and must be \code{length(id) = 1}, for \code{wm_synonyms_} it's optional and
can be \code{length(id) >= 1}}

\item{...}{named curl options. see \code{\link[curl]{curl_options}}}

\item{name}{(character) one or more taxonomic names. optional}
}
\value{
A tibble/data.frame. when using underscore method, outputs from
each input are binded together, but can be split by \code{id} column
}
\description{
Get synonyms for an AphiaID
}
\section{Singular vs. plural}{

Of the two sister functions, the one without the underscore is the original
function that wraps the relavant WoRMS API method - and only accepts
one thing (i.e., name or AphiaID) per request.

The sister function with the underscore at the end is the plural version,
accepting more than one input. Internally this function loops over
the non-underscore method, and labels output (whether it's a list or
data.frame rows) with the input names or IDs so that you can easily
parse output by your inputs.
}

\examples{
\dontrun{
wm_synonyms(id = 105706)
wm_synonyms_(id = 105706)
wm_synonyms_(id = c(105706, 126436))
}
}
