# fuzzy set data for iris10 with 4 neighbors
# numbers have been compared with python fuzzy_simplicial_set

# Asymmetric fuzzy set data
V_asymm <- Matrix::sparseMatrix(
  i = c(
    5, 6, 8, 3, 9, 10, 2, 4, 7, 9, 10, 2, 3, 7, 9, 10, 1, 6, 8, 3, 5, 1,
    5, 6, 7, 4, 1, 2, 4, 8
  ),
  j = c(
    1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 7, 7, 8,
    8, 8, 8, 9, 10, 10, 10, 10
  ),
  x = c(
    1, 1, 1, 0.328, 0.4252, 1, 0.5386, 1, 1, 0.5748, 0.5, 0.4614, 1, 0.6463,
    1, 0.5, 1, 1, 0.6894, 0.672, 0.2807, 0.8381, 0.7193, 5.129e-10, 0.3538,
    0.5447, 0.1619, 1, 0.4553, 0.3106
  )
)

# Fuzzy Set Union
V_union <- Matrix::sparseMatrix(
  i = c(
    5, 6, 8, 10, 3, 4, 9, 10, 2, 4, 7, 9, 10, 2, 3, 7, 9, 10, 1, 6, 7, 8, 1, 5,
    8, 3, 4, 5, 8, 1, 5, 6, 7, 10, 2, 3, 4, 1, 2, 3, 4, 8
  ),
  j = c(
    1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6,
    7, 7, 7, 7, 8, 8, 8, 8, 8, 9, 9, 9, 10, 10, 10, 10, 10
  ),
  x = c(
    1, 1, 1, 0.1619, 0.6899, 0.4614, 0.4252, 1, 0.6899, 1, 1, 0.5748, 0.5,
    0.4614, 1, 0.6463, 1, 0.7277, 1, 1, 0.2807, 0.9128, 1, 1, 5.129e-10, 1,
    0.6463, 0.2807, 0.3538, 1, 0.9128, 5.129e-10, 0.3538, 0.3106, 0.4252,
    0.5748, 1, 0.1619, 1, 0.5, 0.7277, 0.3106
  )
)

# mix intersection with union
V_mix <- Matrix::sparseMatrix(
  i = c(
    5, 6, 8, 10, 3, 4, 9, 10, 2, 4, 7, 9, 10, 2, 3, 7, 9, 10, 1, 6, 7, 8, 1, 5,
    8, 3, 4, 5, 8, 1, 5, 6, 7, 10, 2, 3, 4, 1, 2, 3, 4, 8
  ),
  j = c(
    1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6,
    7, 7, 7, 7, 8, 8, 8, 8, 8, 9, 9, 9, 10, 10, 10, 10, 10
  ),
  x = c(
    1, 0.5, 0.919, 0.08095, 0.4333, 0.2307, 0.2126, 1, 0.4333, 1, 0.836,
    0.2874, 0.25, 0.2307, 1, 0.3231, 0.7723, 0.4777, 1, 0.5, 0.1404, 0.7043,
    0.5, 0.5, 2.564e-10, 0.836, 0.3231, 0.1404, 0.1769, 0.919, 0.7043,
    2.564e-10, 0.1769, 0.1553, 0.2126, 0.2874, 0.7723, 0.08095, 1, 0.25,
    0.4777, 0.1553
  )
)

# intersection
V_intersect <- Matrix::sparseMatrix(
  i = c(5, 8, 3, 10, 2, 4, 7, 3, 9, 10, 1, 8, 3, 1, 5, 4, 2, 4),
  j = c(1, 1, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 7, 8, 8, 9, 10, 10),
  x = c(
    1, 0.8381, 0.1766, 1, 0.1766, 1, 0.672, 1, 0.5447, 0.2277,
    1, 0.4959, 0.672, 0.8381, 0.4959, 0.5447, 1, 0.2277
  )
)

# asymm with local connectivity = 1.5
V_asymm_local <- Matrix::sparseMatrix(
  i = c(
    5, 6, 8, 3, 9, 10, 2, 4, 7, 9, 10, 2, 3, 7, 9, 10, 1, 6, 8, 3, 5, 1,
    5, 6, 7, 4, 1, 2, 4, 8
  ),
  j = c(
    1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 7, 7, 8, 8,
    8, 8, 9, 10, 10, 10, 10
  ),
  x = c(
    1, 1, 1, 0.2559, 0.3748, 1, 0.5698, 1, 1, 0.6252, 0.5, 0.4302, 1, 0.7157,
    1, 0.5, 1, 1, 0.7622, 0.7441, 0.2084, 0.8925, 0.7916, 5.129e-10, 0.2843,
    0.5797, 0.1075, 1, 0.4203, 0.2378
  )
)

V_union_local <- Matrix::sparseMatrix(
  i = c(
    5, 6, 8, 10, 3, 4, 9, 10, 2, 4, 7, 9, 10, 2, 3, 7, 9, 10, 1, 6, 7, 8, 1,
    5, 8, 3, 4, 5, 8, 1, 5, 6, 7, 10, 2, 3, 4, 1, 2, 3, 4, 8
  ),
  j = c(
    1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6,
    6, 7, 7, 7, 7, 8, 8, 8, 8, 8, 9, 9, 9, 10, 10, 10, 10, 10
  ),
  x = c(
    1, 1, 1, 0.1075, 0.6799, 0.4302, 0.3748, 1, 0.6799, 1, 1, 0.6252, 0.5,
    0.4302, 1, 0.7157, 1, 0.7102, 1, 1, 0.2084, 0.9504, 1, 1, 5.129e-10, 1,
    0.7157, 0.2084, 0.2843, 1, 0.9504, 5.129e-10, 0.2843, 0.2378, 0.3748,
    0.6252, 1, 0.1075, 1, 0.5, 0.7102, 0.2378
  )
)

# NB have to modify UMAP source code to allow bandwidth to be specified
# umap.umap_.fuzzy_simplicial_set(irisxy[0][5:15], 4, random_state=42, metric="euclidean", bandwidth=0.5, set_op_mix_ratio=1)[0]
V_union_bandwidth <- Matrix::sparseMatrix(
  i = c(
    2, 5, 9, 2, 3, 4, 6, 8, 0, 1, 4, 5, 6, 9, 1, 7, 8, 1, 2, 6, 7, 0, 2, 9, 1, 2, 4, 7, 3, 4, 6, 8, 1, 3, 7, 0, 2, 5
  ),
  j = c(
    0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9, 9, 9
  ),
  x = c(
    1.486e-10, 1, 5.145e-06, 
    1.237e-07, 4.152e-23, 1.04e-10, 1, 3.123e-08, 
    1.486e-10, 1.237e-07, 9.861e-07, 2.897e-09, 1, 2.381e-26,
    4.152e-23, 1.074e-07, 1, 
    1.04e-10, 9.861e-07, 2.353e-10, 1, 1, 2.897e-09, 1, 
    1, 1, 2.353e-10, 1.194e-08, 
    1.074e-07, 1, 1.194e-08, 2.639e-07, 
    3.123e-08, 1, 2.639e-07, 
    5.145e-06, 2.381e-26, 1
  ),
  index1 = FALSE
)

# umap.umap_.fuzzy_simplicial_set(irisxy[0][5:15], 4, random_state=42, metric="euclidean", local_connectivity=1.5, bandwidth=0.5, set_op_mix_ratio=0)[0]
V_intersect_local_bandwidth <- Matrix::sparseMatrix(
  i = c(
    5, 9, 2, 6, 1, 4, 6, 7, 8, 2, 6, 7, 0, 9, 1, 2, 4, 3, 4, 3, 0, 5
  ),
  j = c(
    0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 7, 7, 8, 9, 9
  ),
  x = c(
    1, 3.079e-15, 
    6.166e-24, 3.211e-09,
    6.166e-24, 1.53e-15, 1, 
    2.323e-16, 1, 
    1.53e-15, 5.479e-30, 1, 
    1, 1.673e-18, 
    3.211e-09, 1, 5.479e-30, 
    2.323e-16, 1, 
    1, 
    3.079e-15, 1.673e-18
  ),
  index1 = FALSE
)
