% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsurvplot_df.R
\name{ggsurvplot_df}
\alias{ggsurvplot_df}
\title{Plot Survival Curves from Survival Summary Data Frame}
\usage{
ggsurvplot_df(
  fit,
  fun = NULL,
  color = NULL,
  palette = NULL,
  linetype = 1,
  break.x.by = NULL,
  break.time.by = NULL,
  break.y.by = NULL,
  surv.scale = c("default", "percent"),
  surv.geom = geom_step,
  xscale = 1,
  conf.int = FALSE,
  conf.int.fill = "gray",
  conf.int.style = "ribbon",
  conf.int.alpha = 0.3,
  censor = TRUE,
  censor.shape = "+",
  censor.size = 4.5,
  title = NULL,
  xlab = "Time",
  ylab = "Survival probability",
  xlim = NULL,
  ylim = NULL,
  axes.offset = TRUE,
  legend = c("top", "bottom", "left", "right", "none"),
  legend.title = "Strata",
  legend.labs = NULL,
  ggtheme = theme_survminer(),
  ...
)
}
\arguments{
\item{fit}{a data frame as returned by surv_summary. Should contains at least
the following columns: \itemize{ \item time: survival time \item surv:
survival probability \item strata: grouping variables \item n.censor: number
of censors \item upper: upper end of confidence interval \item lower: lower
end of confidence interval }}

\item{fun}{an arbitrary function defining a transformation of the survival
curve.  Often used transformations can be specified with a character
argument: "event" plots cumulative events (f(y) = 1-y), "cumhaz" plots the
cumulative hazard function (f(y) = -log(y)), and "pct" for survival
probability in percentage.}

\item{color}{color to be used for the survival curves. \itemize{ \item If the
number of strata/group (n.strata) = 1, the expected value is the color name.
For example color = "blue". \item If n.strata > 1, the expected value is the
grouping variable name. By default, survival curves are colored by strata
using the argument color = "strata",  but you can also color survival curves
by any other grouping variables used to fit the survival curves. In this
case, it's possible to specify a custom color palette by using the argument
palette.}}

\item{palette}{the color palette to be used. Allowed values include "hue" for
the default hue color scale; "grey" for grey color palettes; brewer palettes
e.g. "RdBu", "Blues", ...; or custom color palette e.g. c("blue", "red"); and scientific journal palettes from ggsci R package, e.g.: "npg",
 "aaas", "lancet", "jco", "ucscgb", "uchicago", "simpsons" and
 "rickandmorty".
See details section for more information.  Can be also a numeric vector of
length(groups); in this case a basic color palette is created using the
function \link[grDevices]{palette}.}

\item{linetype}{line types. Allowed values includes i) "strata" for changing
linetypes by strata (i.e. groups); ii) a numeric vector (e.g., c(1, 2)) or a
character vector c("solid", "dashed").}

\item{break.x.by}{alias of break.time.by. Numeric value controlling x axis
breaks. Default value is NULL.}

\item{break.time.by}{numeric value controlling time axis breaks. Default value
is NULL.}

\item{break.y.by}{same as break.x.by but for y axis.}

\item{surv.scale}{scale transformation of survival curves. Allowed values are
"default" or "percent".}

\item{surv.geom}{survival curve style. Is the survival curve entered a step
function (\link[ggplot2]{geom_step}) or a smooth function (\link[ggplot2]{geom_line}).}

\item{xscale}{numeric or character value specifying x-axis scale. \itemize{
\item If numeric, the value is used to divide the labels on the x axis. For
example, a value of 365.25 will give labels in years instead of the original
days. \item If character, allowed options include one of c("d_m", "d_y",
"m_d", "m_y", "y_d", "y_m"), where d = days, m = months and y = years. For
example, xscale = "d_m" will transform labels from days to months; xscale =
"m_y", will transform labels from months to years.}}

\item{conf.int}{logical value. If TRUE, plots confidence interval.}

\item{conf.int.fill}{fill color to be used for confidence interval.}

\item{conf.int.style}{confidence interval style. Allowed values include
c("ribbon", "step").}

\item{conf.int.alpha}{numeric value specifying fill color transparency. Value
should be in [0, 1], where 0 is full transparency and 1 is no transparency.}

\item{censor}{logical value. If TRUE, censors will be drawn.}

\item{censor.shape}{character or numeric value specifying the point shape of
censors. Default value is "+" (3), a sensible choice is "|" (124).}

\item{censor.size}{numveric value specifying the point size of censors.
Default is 4.5.}

\item{title}{main title}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{xlim}{x axis limits e.g. \code{xlim = c(0, 1000)}.}

\item{ylim}{y axis limits e.g. \code{xlim = c(0, 1)}.}

\item{axes.offset}{logical value. Default is TRUE. If FALSE, set the plot axes
to start at the origin.}

\item{legend}{character specifying legend position. Allowed values are one of
c("top", "bottom", "left", "right", "none"). Default is "top" side position.
to remove the legend use legend = "none". Legend position can be also
specified using a numeric vector c(x, y); see details section.}

\item{legend.title}{legend title.}

\item{legend.labs}{character vector specifying legend labels. Used to replace
the names of the strata from the fit. Should be given in the same order as
those strata.}

\item{ggtheme}{function, ggplot2 theme name. Default value is
\link{theme_survminer}. Allowed values include ggplot2 official themes: see
\code{\link[ggplot2]{theme}}.}

\item{...}{other arguments to be passed i) to ggplot2 geom_*() functions such
as linetype, size, ii) or to the function \link[ggpubr]{ggpar}() for
customizing the plots. See details section.}
}
\description{
An extension to \link{ggsurvplot}() to plot survival curves from
 any data frame containing the summary of survival curves as returned the
 \link{surv_summary}() function.

 Might be useful for a user who wants
 to use \link{ggsurvplot} for visualizing survival curves computed by another
 method than the standard \link[survival]{survfit.formula} function. In this
 case, the user has just to provide the data frame containing the summary of
 the survival analysis.
}
\examples{
library(survival)

# Fit survival curves
#::::::::::::::::::::::::::::::::::::::::::::::::::::::::
fit1 <- survfit( Surv(time, status) ~ 1, data = colon)
fit2 <- survfit( Surv(time, status) ~ adhere, data = colon)

# Summary
#::::::::::::::::::::::::::::::::::::::::::::::::::::::::
head(surv_summary(fit1, colon))

head(surv_summary(fit2, colon))

# Visualize
#::::::::::::::::::::::::::::::::::::::::::::::::::::::::
ggsurvplot_df(surv_summary(fit1, colon))

ggsurvplot_df(surv_summary(fit2, colon), conf.int = TRUE,
             legend.title = "Adhere", legend.labs = c("0", "1"))

# Kaplan-Meier estimate
#::::::::::::::::::::::::::::::::::::::::::::::::::::::::
out_km <- survfit(Surv(time, status) ~ 1, data = lung)

# Weibull model
#::::::::::::::::::::::::::::::::::::::::::::::::::::::::
wb <- survreg(Surv(time, status) ~ 1, data = lung)
s <- seq(.01, .99, by = .01)
t <- predict(wb, type = "quantile", p = s, newdata = lung[1, ])
out_wb <- data.frame(time = t, surv = 1 - s, upper = NA, lower = NA, std.err = NA)

# plot both
#::::::::::::::::::::::::::::::::::::::::::::::::::::::::
p_km <- ggsurvplot(out_km, conf.int = FALSE)
p_wb <- ggsurvplot(out_wb, conf.int = FALSE, surv.geom = geom_line)

p_km
p_wb
p_km$plot + geom_line(data = out_wb, aes(x = time, y = surv))

}
