% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plm-package.R
\docType{data}
\name{Grunfeld}
\alias{Grunfeld}
\title{Grunfeld's Investment Data}
\format{A data frame containing :
\describe{
\item{firm}{observation}
\item{year}{date}
\item{inv}{gross Investment}
\item{value}{value of the firm}
\item{capital}{stock of plant and equipment} }}
\source{
Online complements to Baltagi (2001):

\url{http://www.wiley.com/legacy/wileychi/baltagi/}

\url{http://www.wiley.com/legacy/wileychi/baltagi/supp/Grunfeld.fil}

Online complements to Baltagi (2013):

\url{http://bcs.wiley.com/he-bcs/Books?action=resource&bcsId=4338&itemId=1118672321&resourceId=13452}
}
\description{
A balanced panel of 10 observational units (firms) from 1935 to 1954
}
\details{
\emph{total number of observations} : 200

\emph{observation} : production units

\emph{country} : United States
}
\note{
The Grunfeld data as provided in package \code{plm} is the
same data as used in Baltagi (2001), see \strong{Examples} below.

NB:\cr Various versions of the Grunfeld data circulate
online. Also, various text books (and also varying among editions)
and papers use different subsets of the original Grunfeld data,
some of which contain errors in a few data points compared to the
original data used by Grunfeld (1958) in his PhD thesis. See
Kleiber/Zeileis (2010) and its accompanying website for a
comparison of various Grunfeld data sets in use.
}
\examples{

\dontrun{
# Compare plm's Grunfeld data to Baltagi's (2001) Grunfeld data:
  data("Grunfeld", package="plm")
  Grunfeld_baltagi2001 <- read.csv("http://www.wiley.com/legacy/wileychi/
    baltagi/supp/Grunfeld.fil", sep="", header = FALSE)
  library(compare)
  compare::compare(Grunfeld, Grunfeld_baltagi2001, allowAll = T) # same data set
  }

}
\references{
\insertRef{BALT:01}{plm}

\insertRef{BALT:13}{plm}

\insertRef{GRUN:58}{plm}

\insertRef{KLEI:ZEIL:10}{plm}

website accompanying the paper with various variants of the
Grunfeld data:
\url{https://eeecon.uibk.ac.at/~zeileis/grunfeld/}.
}
\seealso{
For the complete Grunfeld data (11 firms), see
\link[AER:Grunfeld]{AER::Grunfeld}, in the \code{AER} package.
}
\keyword{datasets}
