\name{Habituationdata}
\alias{Habituationdata}
\docType{data}
\title{Infant habituation data}
\author{Hoben Thomas}
\description{
From Thomas et al (2011):

"Habituation is a standard method of studying infant behaviors. Indeed,
much of what is known about infant memory and perception rests on 
habituation methods. Six-month infants (n = 51) were habituated to a 
checker-board pattern on two occasions, 
one week apart. On each occasion, the
infant was presented with the checkerboard pattern and the length of time
the infant viewed the pattern before disengaging was recorded; this denoted
the end of a trial. After disengagement, another trial was presented. The
procedure was implemented for eleven trials. The conventional index of 
habituation performance is the summed observed fixation to the checkerboard
pattern over the eleven trials. Thus, an index of reliability focuses on how
these fixation times, in seconds, on the two assessment occasions correlate:
\eqn{r = .29}."}
\usage{data(Habituationdata)}
\format{A data frame with two variables, \code{m1} and \code{m2}, and
51 cases.  The two variables are the summed observations times
for the two occasions described above.}
\source{
Original source: 
Thomas et al. (2011).  See references section.
}
\references{
Thomas, H., Lohaus, A., and Domsch, H. (2011), Extensions of
Reliability Theory, in
Nonparametric Statistics and Mixture Models:  A Festschrift in
Honor of Thomas Hettmansperger (Singapore:  World Scientific),
pp. 309-316.
}
\keyword{datasets}



