% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_subsample.R
\name{update.psis_loo_ss}
\alias{update.psis_loo_ss}
\title{Update \code{psis_loo_ss} objects}
\usage{
\method{update}{psis_loo_ss}(
  object,
  ...,
  data = NULL,
  draws = NULL,
  observations = NULL,
  r_eff = 1,
  cores = getOption("mc.cores", 1),
  loo_approximation = NULL,
  loo_approximation_draws = NULL,
  llgrad = NULL,
  llhess = NULL
)
}
\arguments{
\item{object}{A \code{psis_loo_ss} object to update.}

\item{...}{Currently not used.}

\item{data, draws}{See \code{\link[=loo_subsample.function]{loo_subsample.function()}}.}

\item{observations}{The subsample observations to use. The argument can take
four (4) types of arguments:
\itemize{
\item \code{NULL} to use all observations. The algorithm then just uses
standard \code{loo()} or \code{loo_approximate_posterior()}.
\item A single integer to specify the number of observations to be subsampled.
\item A vector of integers to provide the indices used to subset the data.
\emph{These observations need to be subsampled with the same scheme as given by
the \code{estimator} argument}.
\item A \code{psis_loo_ss} object to use the same observations that were used in a
previous call to \code{loo_subsample()}.
}}

\item{r_eff}{Vector of relative effective sample size estimates for the
likelihood (\code{exp(log_lik)}) of each observation. This is related to
the relative efficiency of estimating the normalizing term in
self-normalized importance sampling when using posterior draws obtained
with MCMC. If MCMC draws are used and \code{r_eff} is not provided then
the reported PSIS effective sample sizes and Monte Carlo error estimates
can be over-optimistic. If the posterior draws are (near) independent then
\code{r_eff=1} can be used. \code{r_eff} has to be a scalar (same value is used
for all observations) or a vector with length equal to the number of
observations. The default value is 1. See the \code{\link[=relative_eff]{relative_eff()}} helper
functions for help computing \code{r_eff}.}

\item{cores}{The number of cores to use for parallelization. This defaults to
the option \code{mc.cores} which can be set for an entire R session by
\code{options(mc.cores = NUMBER)}. The old option \code{loo.cores} is now
deprecated but will be given precedence over \code{mc.cores} until
\code{loo.cores} is removed in a future release. \strong{As of version
2.0.0 the default is now 1 core if \code{mc.cores} is not set}, but we
recommend using as many (or close to as many) cores as possible.
\itemize{
\item Note for Windows 10 users: it is \strong{strongly}
\href{https://github.com/stan-dev/loo/issues/94}{recommended} to avoid using
the \code{.Rprofile} file to set \code{mc.cores} (using the \code{cores} argument or
setting \code{mc.cores} interactively or in a script is fine).
}}

\item{loo_approximation}{What type of approximation of the loo_i's should be used?
The default is \code{"plpd"} (the log predictive density using the posterior expectation).
There are six different methods implemented to approximate loo_i's
(see the references for more details):
\itemize{
\item \code{"plpd"}: uses the lpd based on point estimates (i.e., \eqn{p(y_i|\hat{\theta})}).
\item \code{"lpd"}: uses the lpds (i,e., \eqn{p(y_i|y)}).
\item \code{"tis"}: uses truncated importance sampling to approximate PSIS-LOO.
\item \code{"waic"}: uses waic (i.e., \eqn{p(y_i|y) - p_{waic}}).
\item \code{"waic_grad_marginal"}: uses waic approximation using first order delta
method and posterior marginal variances to approximate \eqn{p_{waic}} (ie.
\eqn{p(y_i|\hat{\theta})}-p_waic_grad_marginal). Requires gradient of
likelihood function.
\item \code{"waic_grad"}: uses waic approximation using first order delta method and
posterior covariance to approximate \eqn{p_{waic}} (ie.
\eqn{p(y_i|\hat{\theta})}-p_waic_grad). Requires gradient of likelihood
function.
\item \code{"waic_hess"}: uses waic approximation using second order delta method and
posterior covariance to approximate \eqn{p_{waic}} (ie.
\eqn{p(y_i|\hat{\theta})}-p_waic_grad). Requires gradient and Hessian of
likelihood function.
}

As point estimates of \eqn{\hat{\theta}}, the posterior expectations
of the parameters are used.}

\item{loo_approximation_draws}{The number of posterior draws used when
integrating over the posterior. This is used if \code{loo_approximation} is set
to \code{"lpd"}, \code{"waic"}, or \code{"tis"}.}

\item{llgrad}{The gradient of the log-likelihood. This
is only used when \code{loo_approximation} is \code{"waic_grad"},
\code{"waic_grad_marginal"}, or \code{"waic_hess"}. The default is \code{NULL}.}

\item{llhess}{The Hessian of the log-likelihood. This is only used
with \code{loo_approximation = "waic_hess"}. The default is \code{NULL}.}
}
\value{
A \code{psis_loo_ss} object.
}
\description{
Update \code{psis_loo_ss} objects
}
\details{
If \code{observations} is updated then if a vector of indices or a \code{psis_loo_ss}
object is supplied the updated object will have exactly the observations
indicated by the vector or \code{psis_loo_ss} object. If a single integer is
supplied, new observations will be sampled to reach the supplied sample size.
}
