% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_apply_linter.R
\name{matrix_apply_linter}
\alias{matrix_apply_linter}
\title{Require usage of \code{colSums(x)} or \code{rowSums(x)} over \code{apply(x, ., sum)}}
\usage{
matrix_apply_linter()
}
\description{
\code{\link[=colSums]{colSums()}} and \code{\link[=rowSums]{rowSums()}} are clearer and more performant alternatives to
\code{apply(x, 2, sum)} and \code{apply(x, 1, sum)} respectively in the case of 2D
arrays, or matrices
}
\examples{
# will produce lints
lint(
  text = "apply(x, 1, sum)",
  linters = matrix_apply_linter()
)

lint(
  text = "apply(x, 2, sum)",
  linters = matrix_apply_linter()
)

lint(
  text = "apply(x, 2, sum, na.rm = TRUE)",
  linters = matrix_apply_linter()
)

lint(
  text = "apply(x, 2:4, sum)",
  linters = matrix_apply_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}
}
