% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with.R
\name{linters_with_defaults}
\alias{linters_with_defaults}
\title{Create a linter configuration based on defaults}
\usage{
linters_with_defaults(..., defaults = default_linters)
}
\arguments{
\item{...}{Arguments of elements to change. If unnamed, the argument is automatically named.
If the named argument already exists in the list of linters, it is replaced by the new element.
If it does not exist, it is added. If the value is \code{NULL}, the linter is removed.}

\item{defaults}{Default list of linters to modify. Must be named.}
}
\description{
Make a new list based on \pkg{lintr}'s default linters.
The result of this function is meant to be passed to the \code{linters} argument of \code{lint()},
or to be put in your configuration file.
}
\examples{
# When using interactively you will usually pass the result onto `lint` or `lint_package()`
f <- tempfile()
writeLines("my_slightly_long_variable_name <- 2.3", f)
lint(f, linters = linters_with_defaults(line_length_linter = line_length_linter(120L)))
unlink(f)

# the default linter list with a different line length cutoff
my_linters <- linters_with_defaults(line_length_linter = line_length_linter(120L))

# omit the argument name if you are just using different arguments
my_linters <- linters_with_defaults(defaults = my_linters, object_name_linter("camelCase"))

# remove assignment checks (with NULL), add absolute path checks
my_linters <- linters_with_defaults(
  defaults = my_linters,
  assignment_linter = NULL,
  absolute_path_linter()
)

# checking the included linters
names(my_linters)

}
\seealso{
\itemize{
\item \link{linters_with_tags} for basing off tags attached to linters, possibly across multiple packages.
\item \link{all_linters} for basing off all available linters in lintr.
\item \link{available_linters} to get a data frame of available linters.
\item \link{linters} for a complete list of linters available in lintr.
}
}
