% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boolean_arithmetic_linter.R
\name{boolean_arithmetic_linter}
\alias{boolean_arithmetic_linter}
\title{Require usage of boolean operators over equivalent arithmetic}
\usage{
boolean_arithmetic_linter()
}
\description{
\code{length(which(x == y)) == 0} is the same as \code{!any(x == y)}, but the latter
is more readable and more efficient.
}
\examples{
# will produce lints
lint(
  text = "length(which(x == y)) == 0L",
  linters = boolean_arithmetic_linter()
)

lint(
  text = "sum(grepl(pattern, x)) == 0",
  linters = boolean_arithmetic_linter()
)

# okay
lint(
  text = "!any(x == y)",
  linters = boolean_arithmetic_linter()
)

lint(
  text = "!any(grepl(pattern, x))",
  linters = boolean_arithmetic_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}
}
