% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotData.R
\name{plotDataOverview}
\alias{plotDataOverview}
\title{Plot overview of the input data}
\usage{
plotDataOverview(object, colors = NULL)
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{colors}{a character vector specifying the colors per view.
NULL (default) uses an internal palette.}
}
\value{
a tile plot of the training data
}
\description{
Function to do a tile plot showing the dimensionality and 
the missing value structure of the multi-omics data.
}
\details{
This function is helpful to get an overview of the dimensionality and
 the missing value structure of the training data. \cr 
It shows the number of samples, the number of views, the number of features,
 and the structure of missing values. \cr
It is particularly useful to visualise incomplete data sets,
 where some samples are missing subsets of assays.
}
\examples{
# Example on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)
plotDataOverview(MOFA_CLL)

# Example on the scMT data
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFA_scMT <- loadModel(filepath)
# using customized colors
plotDataOverview(MOFA_scMT, colors= c("red", "red", "red", "blue"))
}
