---
layout: default
built_from_commit: 70303b65ae864066c583e1436011ff135847f6ad
title: 'Man Page: puppet catalog'
canonical: "/puppet/latest/man/catalog.html"
---

# Man Page: puppet catalog

> **NOTE:** This page was generated from the Puppet source code on 2024-08-29 17:41:46 -0700

## NAME
**puppet-catalog** - Compile, save, view, and convert catalogs.

## SYNOPSIS
puppet catalog *action* \[\--terminus \_TERMINUS\]

## DESCRIPTION
This subcommand deals with catalogs, which are compiled per-node
artifacts generated from a set of Puppet manifests. By default, it
interacts with the compiling subsystem and compiles a catalog using the
default manifest and **certname**, but you can change the source of the
catalog with the **\--terminus** option. You can also choose to print
any catalog in \'dot\' format (for easy graph viewing with OmniGraffle
or Graphviz) with \'\--render-as dot\'.

## OPTIONS
Note that any setting that\'s valid in the configuration file is also a
valid long argument, although it may or may not be relevant to the
present action. For example, **server** and **run_mode** are valid
settings, so you can specify **\--server \<servername\>**, or
**\--run_mode \<runmode\>** as an argument.

See the configuration file documentation at
*https://puppet.com/docs/puppet/latest/configuration.html* for the full
list of acceptable parameters. A commented list of all configuration
options can also be generated by running puppet with **\--genconfig**.

\--render-as FORMAT

:   The format in which to render output. The most common formats are
    **json**, **s** (string), **yaml**, and **console**, but other
    options such as **dot** are sometimes available.

\--verbose

:   Whether to log verbosely.

\--debug

:   Whether to log debug information.

\--terminus \_TERMINUS

:   Indirector faces expose indirected subsystems of Puppet. These
    subsystems are each able to retrieve and alter a specific type of
    data (with the familiar actions of **find**, **search**, **save**,
    and **destroy**) from an arbitrary number of pluggable backends. In
    Puppet parlance, these backends are called terminuses.

    Almost all indirected subsystems have a **rest** terminus that
    interacts with the puppet master\'s data. Most of them have
    additional terminuses for various local data models, which are in
    turn used by the indirected subsystem on the puppet master whenever
    it receives a remote request.

    The terminus for an action is often determined by context, but
    occasionally needs to be set explicitly. See the \"Notes\" section
    of this face\'s manpage for more details.

## ACTIONS
**apply** - Find and apply a catalog.

:   **SYNOPSIS**

    puppet catalog apply \[\--terminus \_TERMINUS\]

    **DESCRIPTION**

    Finds and applies a catalog. This action takes no arguments, but the
    source of the catalog can be managed with the **\--terminus**
    option.

    **RETURNS**

    Nothing. When used from the Ruby API, returns a
    Puppet::Transaction::Report object.

**compile** - Compile a catalog.

:   **SYNOPSIS**

    puppet catalog compile \[\--terminus \_TERMINUS\]

    **DESCRIPTION**

    Compiles a catalog locally for a node, requiring access to modules,
    node classifier, etc.

    **RETURNS**

    A serialized catalog.

**download** - Download this node\'s catalog from the puppet master server.

:   **SYNOPSIS**

    puppet catalog download \[\--terminus \_TERMINUS\]

    **DESCRIPTION**

    Retrieves a catalog from the puppet master and saves it to the local
    yaml cache. This action always contacts the puppet master and will
    ignore alternate termini.

    The saved catalog can be used in any subsequent catalog action by
    specifying \'\--terminus yaml\' for that action.

    **RETURNS**

    Nothing.

    **NOTES**

    When used from the Ruby API, this action has a side effect of
    leaving Puppet::Resource::Catalog.indirection.terminus_class set to
    yaml. The terminus must be explicitly re-set for subsequent catalog
    actions.

**find** - Retrieve the catalog for the node from which the command is run.

:   **SYNOPSIS**

    puppet catalog find \[\--terminus \_TERMINUS\]
    \[\--facts_for_catalog\] *certname*, *facts*

    **DESCRIPTION**

    Retrieve the catalog for the node from which the command is run.

    **OPTIONS** *\--facts_for_catalog* - Not implemented for the CLI;
    facts are collected internally.

    **RETURNS**

    A serialized catalog. When used from the Ruby API, returns a
    Puppet::Resource::Catalog object.

**info** - Print the default terminus class for this face.

:   **SYNOPSIS**

    puppet catalog info \[\--terminus \_TERMINUS\]

    **DESCRIPTION**

    Prints the default terminus class for this subcommand. Note that
    different run modes may have different default termini; when in
    doubt, specify the run mode with the \'\--run_mode\' option.

**save** - API only: create or overwrite an object.

:   **SYNOPSIS**

    puppet catalog save \[\--terminus \_TERMINUS\] *key*

    **DESCRIPTION**

    API only: create or overwrite an object. As the Faces framework does
    not currently accept data from STDIN, save actions cannot currently
    be invoked from the command line.

**select** - Retrieve a catalog and filter it for resources of a given type.

:   **SYNOPSIS**

    puppet catalog select \[\--terminus \_TERMINUS\] *host*
    *resource_type*

    **DESCRIPTION**

    Retrieves a catalog for the specified host, then searches it for all
    resources of the requested type.

    **RETURNS**

    A list of resource references (\"Type\[title\]\"). When used from
    the API, returns an array of Puppet::Resource objects excised from a
    catalog.

    **NOTES**

    By default, this action will retrieve a catalog from Puppet\'s
    compiler subsystem; you must call the action with **\--terminus
    rest** if you wish to retrieve a catalog from the puppet master.

    FORMATTING ISSUES: This action cannot currently render useful yaml;
    instead, it returns an entire catalog. Use json instead.

## EXAMPLES
**apply**

Apply the locally cached catalog:

\$ puppet catalog apply \--terminus yaml

Retrieve a catalog from the master and apply it, in one step:

\$ puppet catalog apply \--terminus rest

API example:



    ## ...    Puppet::Face[:catalog, '0.0.1'].download
    ## (Termini are singletons; catalog.download has a side effect of    ## setting the catalog terminus to yaml)    report  = Puppet::Face[:catalog, '0.0.1'].apply
    ## ...
**compile**

Compile catalog for node \'mynode\':

\$ puppet catalog compile mynode \--codedir \...

**download**

Retrieve and store a catalog:

\$ puppet catalog download

API example:



    Puppet::Face[:plugin, '0.0.1'].download
    Puppet::Face[:facts, '0.0.1'].upload
    Puppet::Face[:catalog, '0.0.1'].download
    ## ...
**select**

Ask the puppet master for a list of managed file resources for a node:

\$ puppet catalog select \--terminus rest somenode.magpie.lan file

## NOTES
This subcommand is an indirector face, which exposes **find**,
**search**, **save**, and **destroy** actions for an indirected
subsystem of Puppet. Valid termini for this face include:

-   **compiler**

-   **json**

-   **msgpack**

-   **rest**

-   **store_configs**

-   **yaml**

## COPYRIGHT AND LICENSE
Copyright 2011 by Puppet Inc. Apache 2 license; see COPYING
