<?php
/**
*
* This file is part of the Norwegian (bokmål) Language Pack
* for the phpBB Forum Software.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @copyright (c) Lars Christian Schreiner
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> '<a href="https://www.phpbb.com/customise/db/translation/norwegian_bokmål/">Norwegian (bokmål) Language Pack</a> &copy; Lars Christian Schreiner',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|j. F Y|',	// January 1st, 2007 (with Relative days enabled)
	'DATETIME_FORMAT'	=> '|j. F Y, H.i|',	// January 1st, 2007, 1:37 pm (with Relative days enabled)
	'USER_LANG'			=> 'nb-no',

	// You can define different rules for the determination of plural forms here.
	// See http://wiki.phpbb.com/Plural_Rules for more information
	// or ask the translation manager for help.
	'PLURAL_RULE'		=> 1,

	'1_DAY'			=> '1 dag',
	'1_MONTH'		=> '1 måned',
	'1_YEAR'		=> '1 år',
	'2_WEEKS'		=> '2 uker',
	'3_MONTHS'		=> '3 måneder',
	'6_MONTHS'		=> '6 måneder',
	'7_DAYS'		=> '7 dager',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Kontoen er allerede aktivert.',
	'ACCOUNT_DEACTIVATED'			=> 'Kontoen er deaktivert manuelt og kan bare reaktiveres av en administrator.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Kontoen er ikke aktivert ennå.',
	'ACP'							=> 'Administrasjonskontrollpanel',
	'ACP_SHORT'						=> 'ACP',
	'ACTIVE'						=> 'aktiv',
	'ACTIVE_ERROR'					=> 'Det angitte brukernavnet er for øyeblikket inaktivt. Hvis du har problemer med å aktivere kontoen, kan du kontakte en systemadministrator.',
	'ADMINISTRATOR'					=> 'Administrator',
	'ADMINISTRATORS'				=> 'Administratorer',
	'AGE'							=> 'Alder',
	'AIM'							=> 'AIM',
	'AJAX_ERROR_TITLE'				=> 'AJAX-feil',
	'AJAX_ERROR_TEXT'				=> 'Noe gikk galt ved behandling av forespørselen.',
	'AJAX_ERROR_TEXT_ABORT'			=> 'Brukeravbrutt forespørsel.',
	'AJAX_ERROR_TEXT_TIMEOUT'		=> 'Forespørselen ble tidsavbrutt. Prøv igjen.',
	'AJAX_ERROR_TEXT_PARSERERROR'	=> 'Noe gikk galg med forespørselen, og serveren returnerte et ugyldig svar.',
	'ALLOWED'						=> 'Tillatt',
	'ALL_FILES'						=> 'Alle filer',
	'ALL_FORUMS'					=> 'Alle fora',
	'ALL_MESSAGES'					=> 'Alle meldinger',
	'ALL_POSTS'						=> 'Alle innlegg',
	'ALL_TIMES'						=> 'Alle klokkeslett er <abbr title="%2$s">%1$s</abbr>',
	'ALL_TOPICS'					=> 'Alle emner',
	'AND'							=> 'Og',
	'ARE_WATCHING_FORUM'			=> 'Du har abonnert på varslinger om nye innlegg i dette forumet.',
	'ARE_WATCHING_TOPIC'			=> 'Du har abonnert på varslinger om nye innlegg i dette emnet.',
	'ASCENDING'						=> 'Stigende',
	'ATTACHMENTS'					=> 'Vedlegg',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Bildefilen du prøvde å legge ved, er ugyldig.',
	'AUTHOR'						=> 'Forfatter',
	'AUTH_NO_PROFILE_CREATED'		=> 'Opprettingen av en brukerprofil mislyktes.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'				=> 'Ugyldig databaseoppføring.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'		=> 'Ugyldig tjenestetype ble angitt til OAuth-tjenestehåndtereren.',
	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'			=> 'OAuth-tjeneste ikke opprettet',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'						=> 'Bitly',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'					=> 'Facebook',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'					=> 'Google',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'			=> 'OAuth-token ikke lagret.',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED'	=> 'OAuth-token lagret på feil måte.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Opplastingen ble avvist fordi den opplastede filen ble identifisert som en mulig angrepsvektor.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Denne filen kan ikke vises, fordi filetternavnet <strong>%s</strong> ikke tillates.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Den angitte avataren kan ikke lastes opp fordi de eksterne dataene ser ut til å være ugyldige eller skadet.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Den opplastede avatarfilen er tom.',
	'AVATAR_INVALID_FILENAME'		=> '%s er et ugyldig filnavn.',
	'AVATAR_NOT_UPLOADED'			=> 'Kan ikke laste opp avatar.',
	'AVATAR_NO_SIZE'				=> 'Bredden eller høyden på den lenkede avataren kan ikke fastslås. Skriv dem inn manuelt.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Den angitte filen ble bare delvis lastet opp.',
	'AVATAR_PHP_SIZE_NA'			=> 'Avatarens filstørrelse er for stor.<br />Den maksimale filstørrelsen som er angitt i php.ini, kan ikke fastslås.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Avatarens filstørrelse er for stor. Den maksimalt tillatte opplastingsstørrelsen er %1$d %2$s.<br />Merk at dette er angitt i php.ini, og kan ikke overstyres.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'	=> 'Den angitte avataren kan ikke lastes opp fordi forespørselen ble tidsavbrutt.',
	'AVATAR_URL_INVALID'			=> 'URL-en du angav, er ugyldig.',
	'AVATAR_URL_NOT_FOUND'			=> 'Finner ikke den angitte filen.',
	'AVATAR_WRONG_FILESIZE'			=> 'Avatarens filstørrelse må være mellom 0 og %1$d %2$s.',
	'AVATAR_WRONG_SIZE'				=> 'Den innsendte avataren er %5$s bred og %6$s høy. Avatarer må være minst %1$s bred og %2$s høy, men ikke større enn %3$s bred og %4$s høy.',

	'BACK_TO_TOP'			=> 'Toppen',
	'BACK_TO_PREV'			=> 'Tilbake til forrige side',
	'BAN_TRIGGERED_BY_EMAIL'=> 'E-postadressen din har blitt utestengt.',
	'BAN_TRIGGERED_BY_IP'	=> 'IP-adressen din har blitt utestengt.',
	'BAN_TRIGGERED_BY_USER'	=> 'Brukernavnet ditt har blitt utestengt.',
	'BBCODE_GUIDE'			=> 'BBCode-veiledning',
	'BCC'					=> 'Blindkopi',
	'BIRTHDAYS'				=> 'Fødselsdager',
	'BOARD_BAN_PERM'		=> 'Du er <strong>permanent</strong> utestengt fra dette systemet.<br /><br />Kontakt %2$ssystemadministratoren%3$s for mer informasjon.',
	'BOARD_BAN_REASON'		=> 'Begrunnelse for utestengelsen: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Du er utestengt fra dette systemet frem til <strong>%1$s</strong>.<br /><br />Kontakt %2$ssystemadministratoren%3$s for mer informasjon.',
	'BOARD_DISABLE'			=> 'Beklager, men dette systemet er for øyeblikket utilgjengelig.',
	'BOARD_DISABLED'		=> 'Dette systemet er for øyeblikket deaktivert.',
	'BOARD_UNAVAILABLE'		=> 'Beklager, men systemet er midlertidig utilgjengelig. Prøv igjen om noen minutter.',
	'BROWSING_FORUM'		=> 'Brukere i dette forumet: %1$s',
	'BROWSING_FORUM_GUESTS'	=> array(
		1	=> 'Brukere i dette forumet: %2$s og %1$d gjest',
		2	=> 'Brukere i dette forumet: %2$s og %1$d gjester',
	),
	'BUTTON_EDIT'			=> 'Rediger',
	'BUTTON_FORUM_LOCKED'	=> 'Låst',
	'BUTTON_NEW_TOPIC'		=> 'Nytt emne',
	'BUTTON_PM'				=> 'PM',
	'BUTTON_PM_FORWARD'		=> 'Videresend',
	'BUTTON_PM_NEW'			=> 'Ny PM',
	'BUTTON_PM_REPLY'		=> 'Send svar',
	'BUTTON_PM_REPLY_ALL'	=> 'Svar alle',
	'BUTTON_POST_REPLY'		=> 'Svar',
	'BUTTON_QUOTE'			=> 'Siter',
	'BUTTON_TOPIC_LOCKED'	=> 'Låst',
	'BYTES'					=> 'byte',
	'BYTES_SHORT'			=> 'B',

	'CANCEL'				=> 'Avbryt',
	'CHANGE'				=> 'Endre',
	'CHANGE_FONT_SIZE'		=> 'Endre skriftstørrelse',
	'CHANGING_PREFERENCES'	=> 'Endrer systempreferanser',
	'CHANGING_PROFILE'		=> 'Endrer profilinnstillinger',
	'CHARACTERS'			=> array(
		1	=> '%d tegn',
		2	=> '%d tegn',
	),
	'COLLAPSE_VIEW'			=> 'Trekk sammen visning',
	'CLOSE_WINDOW'			=> 'Lukk vindu',
	'COLOUR_SWATCH'			=> 'Fargevelger',
	'COLON'					=> ':',
	'COMMA_SEPARATOR'		=> ', ',	// Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Bekreft',
	'CONFIRM_CODE'			=> 'Bekreftelseskode',
	'CONFIRM_CODE_EXPLAIN'	=> 'Angi koden nøyaktig slik den vises. Det skilles på store og små bokstaver.',
	'CONFIRM_CODE_WRONG'	=> 'Den angitte bekreftelseskoden var feil.',
	'CONFIRM_OPERATION'		=> 'Er du sikker på at du vil fortsette med denne operasjonen?',
	'CONFIRM_AVATAR_DELETE' => 'Er du sikker på at du vil slette denne avataren?',
	'CONGRATULATIONS'		=> 'Gratulerer til',
	'CONNECTION_FAILED'		=> 'Tilkobling mislyktes.',
	'CONNECTION_SUCCESS'	=> 'Tilkoblingen lyktes!',
	'CONTACT'				=> 'Kontakt',
	'CONTACT_USER'			=> 'Kontakt %s',
	'CONTACT_US'			=> 'Kontakt oss',
	'COOKIES_DELETED'		=> 'Alle systemets informasjonskapsler ble slettet.',
	'CURRENT_TIME'			=> 'Det er nå %s',

	'DAY'					=> 'Dag',
	'DAYS'					=> 'Dager',
	'DELETE'				=> 'Slett',
	'DELETE_ALL'			=> 'Slett alt',
	'DELETE_COOKIES'		=> 'Slett alle systemets informasjonskapsler',
	'DELETE_MARKED'			=> 'Slett merkede',
	'DELETE_POST'			=> 'Slett innlegg',
	'DELIMITER'				=> 'Skilletegn',
	'DESCENDING'			=> 'Synkende',
	'DISABLED'				=> 'Deaktivert',
	'DISPLAY'				=> 'Vis',
	'DISPLAY_GUESTS'		=> 'Vis gjester',
	'DISPLAY_MESSAGES'		=> 'Vis meldinger fra forrige',
	'DISPLAY_POSTS'			=> 'Vis innlegg fra forrige',
	'DISPLAY_TOPICS'		=> 'Vis emner fra forrige',
	'DOWNLOADED'			=> 'Nedlastet',
	'DOWNLOADING_FILE'		=> 'Laster ned fil',
	'DOWNLOAD_COUNTS'		=> array(
		0	=> 'Ikke lastet ned ennå',
		1	=> 'Lastet ned %d gang',
		2	=> 'Lastet ned %d ganger',
	),

	'EDIT_POST'							=> 'Rediger innlegg',
	'ELLIPSIS'							=> '…',
	'EMAIL'								=> 'E-post', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'E-postadresse',
	'EMAIL_INVALID_EMAIL'				=> 'E-postadressen du angav, er ugyldig.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Feil ved sending av e-post på <strong>linje %1$s</strong>. Svar: %2$s.',
	'EMPTY_SUBJECT'						=> 'Du må angi en tittel når du starter et nytt emne.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Du må angi en tittel når du lager en ny melding.',
	'ENABLED'							=> 'Aktivert',
	'ENCLOSURE'							=> 'Innpakking',
	'ENTER_USERNAME'					=> 'Angi brukernavn',
	'ERR_CHANGING_DIRECTORY'			=> 'Kan ikke endre mappe.',
	'ERR_CONNECTING_SERVER'				=> 'Feil ved tilkobling til serveren.',
	'ERR_JAB_AUTH'						=> 'Kan ikke godkjenne på Jabber-serveren.',
	'ERR_JAB_CONNECT'					=> 'Kan ikke koble til Jabber-serveren.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Det angitte brukernavnet eller passordet er feil.',
	'ERR_UNWATCHING'					=> 'Det oppstod en feil ved forsøk på å stoppe abonnement.',
	'ERR_WATCHING'						=> 'Det oppstod en feil ved forsøk på å abonnere.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Den angitte phpBB-banen ser ut til å være ugyldig.',
	'ERROR'								=> 'Feil',
	'EXPAND_VIEW'						=> 'Åpne visning',
	'EXTENSION'							=> 'Utvidelse',
	'EXTENSION_DISABLED'				=> 'Utvidelsen <strong>%s</strong> er ikke aktivert.',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'Utvidelsen <strong>%s</strong> er deaktivert, og kan ikke lenger vises.',
	'EXTENSION_DOES_NOT_EXIST'			=> 'Utvidelsen <strong>%s</strong> finnes ikke.',

	'FACEBOOK'				=> 'Facebook',
	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Ofte stilte spørsmål',
	'FILENAME'				=> 'Filnavn',
	'FILESIZE'				=> 'Filstørrelse',
	'FILEDATE'				=> 'Fildato',
	'FILE_COMMENT'			=> 'Filkommentar',
	'FILE_CONTENT_ERR'		=> 'Kan ikke lese innholdet i filen: %s',
	'FILE_JSON_DECODE_ERR'	=> 'Feil ved dekoding av json-fil: %s',
	'FILE_NOT_FOUND'		=> 'Finner ikke den forespurte filen: %s',
	'FIND_USERNAME'			=> 'Finn en forumbruker',
	'FOLDER'				=> 'Mappe',
	'FORGOT_PASS'			=> 'Jeg har glemt passordet',
	'FORM_INVALID'			=> 'Det innsendte skjemaet var ugyldig. Prøv å sende inn på nytt.',
	'FORUM'					=> 'Forum',
	'FORUMS'				=> 'Fora',
	'FORUMS_MARKED'			=> 'Foraene er merket som lest.',
	'FORUM_CAT'				=> 'Forumkategori',
	'FORUM_INDEX'			=> 'Forumindeks',
	'FORUM_LINK'			=> 'Forumlenke',
	'FORUM_LOCATION'		=> 'Forumposisjon',
	'FORUM_LOCKED'			=> 'Forum låst',
	'FORUM_RULES'			=> 'Forumregler',
	'FORUM_RULES_LINK'		=> 'Klikk her for å vise forumreglene',
	'FROM'					=> 'fra',
	'FSOCK_DISABLED'		=> 'Operasjonen kan ikke fullføres fordi funksjonen <var>fsockopen</var> er deaktivert eller så nås ikke serveren det spørres mot.',
	'FSOCK_TIMEOUT'			=> 'Det oppstod et tidsavbrudd ved lesing fra nettverksstrømmen.',

	'FTP_FSOCK_HOST'				=> 'FTP-vert',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'FTP-server som brukes til å koble til systemet ditt.',
	'FTP_FSOCK_PASSWORD'			=> 'FTP-passord',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Passordet til FTP-brukernavnet.',
	'FTP_FSOCK_PORT'				=> 'FTP-port',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Porten som brukes til å koble til serveren.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Bane til phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Banen fra roten til phpBB-systemet.',
	'FTP_FSOCK_TIMEOUT'				=> 'FTP-tidsavbrudd',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Antall sekunder systemet skal vente på svar fra serveren.',
	'FTP_FSOCK_USERNAME'			=> 'FTP-brukernavn',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Brukernavnet som brukes til å koble til serveren.',

	'FTP_HOST'					=> 'FTP-vert',
	'FTP_HOST_EXPLAIN'			=> 'FTP-server som brukes til å koble til systemet ditt.',
	'FTP_PASSWORD'				=> 'FTP-passord',
	'FTP_PASSWORD_EXPLAIN'		=> 'Passordet til FTP-brukernavnet.',
	'FTP_PORT'					=> 'FTP-port',
	'FTP_PORT_EXPLAIN'			=> 'Porten som brukes til å koble til serveren.',
	'FTP_ROOT_PATH'				=> 'Bane til phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Banen fra roten til phpBB-systemet.',
	'FTP_TIMEOUT'				=> 'FTP-tidsavbrudd',
	'FTP_TIMEOUT_EXPLAIN'		=> 'Antall sekunder systemet skal vente på svar fra serveren.',
	'FTP_USERNAME'				=> 'FTP-brukernavn',
	'FTP_USERNAME_EXPLAIN'		=> 'Brukernavnet som brukes til å koble til serveren.',

	'GENERAL_ERROR'				=> 'Generell feil',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Gå',
	'GOOGLEPLUS'				=> 'Google+',
	'GOTO_FIRST_POST'			=> 'Gå til første innlegg',
	'GOTO_LAST_POST'			=> 'Gå til siste innlegg',
	'GOTO_PAGE'					=> 'Gå til side',
	'GROUP'						=> 'Gruppe',
	'GROUPS'					=> 'Grupper',
	'GROUP_ERR_TYPE'			=> 'Feil gruppetype angitt.',
	'GROUP_ERR_USERNAME'		=> 'Intet gruppenavn er angitt.',
	'GROUP_ERR_USER_LONG'		=> 'Gruppenavn kan ikke overskride 60 tegn. Det angitte gruppenavnet er for langt.',
	'GUEST'						=> 'Gjest',
	'GUEST_USERS_ONLINE'		=> array(
		1	=> 'Det er %d gjestebruker online',
		2	=> 'Det er %d gjestebrukere online',
	),
	'GUEST_USERS_TOTAL'			=> array(
		1	=> '%d gjest',
		2	=> '%d gjester',
	),
	'G_ADMINISTRATORS'			=> 'Administratorer',
	'G_BOTS'					=> 'Boter',
	'G_GUESTS'					=> 'Gjester',
	'G_REGISTERED'				=> 'Registrerte brukere',
	'G_REGISTERED_COPPA'		=> 'Registrerte COPPA-brukere',
	'G_GLOBAL_MODERATORS'		=> 'Globale moderatorer',
	'G_NEWLY_REGISTERED'		=> 'Nylig registrerte brukere',

	'HIDDEN_USERS_ONLINE'		=> array(
		1	=> '%d skjult bruker',
		2	=> '%d skjulte brukere',
	),
	'HIDDEN_USERS_TOTAL'		=> array(
		1	=> '%d skjult',
		2	=> '%d skjulte',
	),
	'HIDE_GUESTS'					=> 'Skjul gjester',
	'HIDE_ME'						=> 'Skjul online-statusen min i denne økten',
	'HOURS'							=> 'Timer',
	'HOME'							=> 'Hjem',

	'ICQ'						=> 'ICQ',
	'IF'						=> 'Hvis',
	'IMAGE'						=> 'Bilde',
	'IMAGE_FILETYPE_INVALID'	=> 'Bildefiltype %d for MIME-type %s støttes ikke.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Feil bildefiltype: Forventet filetternavn %1$s, men filetternavnet %2$s ble funnet.',
	'IN'						=> 'i',
	'INDEX'						=> 'Indeksside',
	'INFORMATION'				=> 'Informasjon',
	'INSECURE_REDIRECT'			=> 'Prøvde å omadressere til potensielt usikker URL.',
	'INTERESTS'					=> 'Interesser',
	'INVALID_DIGEST_CHALLENGE'	=> 'Ugyldig digest-utfordring.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> er kanskje en ugyldig e-postadresse?',
	'INVALID_PLURAL_RULE'		=> 'Den valgte flertallsregelen er ugyldig. Verdiene som tillates, er heltall mellom 0 og 15.',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'IP-adresse %1$s er blokkert fordi den er svartelistet. Se <a href="%2$s">%2$s</a> for flere detaljer.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Registrert',
	'JUMP_PAGE'				=> 'Angi sidenummeret du vil gå til',
	'JUMP_TO'				=> 'Gå til',
	'JUMP_TO_PAGE'			=> 'Gå til side',
	'JUMP_TO_PAGE_CLICK'	=> 'Klikk for å gå til side…',

	'KB'					=> 'kB',
	'KIB'					=> 'kiB',

	'LAST_POST'							=> 'Siste innlegg',
	'LAST_UPDATED'						=> 'Sist oppdatert',
	'LAST_VISIT'						=> 'Forrige besøk',
	'LDAP_NO_LDAP_EXTENSION'			=> 'LDAP-utvidelse er ikke tilgjengelig.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Kan ikke koble til LDAP-server.',
	'LDAP_SEARCH_FAILED'				=> 'Det oppstod en feil ved søk i LDAP-katalogen.',
	'LEGEND'							=> 'Forklaring',
	'LIVE_SEARCHES_NOT_ALLOWED'			=> 'Live-søk tillates ikke.',
	'LOADING'							=> 'Laster inn',
	'LOCATION'							=> 'Sted',
	'LOCK_POST'							=> 'Lås innlegg',
	'LOCK_POST_EXPLAIN'					=> 'Hindre redigering',
	'LOCK_TOPIC'						=> 'Lås emne',
	'LOGIN'								=> 'Logg inn',
	'LOGIN_CHECK_PM'					=> 'Logg inn for å se private meldinger.',
	'LOGIN_CONFIRMATION'				=> 'Inloggingsbekreftelse',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'For å hindre maskinell passordknekking, krever systemet at du angir en bekreftelseskode etter et maksimumsantall med mislykkede innlogginger. Koden vises i et bilde som skal synes nedenfor. Hvis du er synshemmet eller av andre årsaker ikke kan lese denne koden, kontakter du %ssystemadministratoren%s.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Du har overskredet det maksimale antallet innloggingsforsøk. I tillegg til brukernavn og passord, må du nå også løse CAPTCHA-en nedenfor.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Du er ikke autentisert av Apache.',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST'	=> 'En ikke-eksisterende OAuth-tjeneste er forespurt.',
	'LOGIN_ERROR_PASSWORD'				=> 'Du har angitt feil passord. Kontroller passordet og prøv igjen. Hvis problemene vedvarer, kontakter du %ssystemadministratoren%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Det var ikke mulig å konvertere passordet når systemets programvare ble oppdatert. %sBe om et nytt passord%s. Hvis problemene vedvarer, kontatker du %ssystemadministratoren%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Du har angitt feil brukernavn. Kontroller brukernavnet og prøv igjen. Hvis problemene vedvarer, kontakter du %ssystemadministratoren%s.',
	'LOGIN_FORUM'						=> 'Du må angi passord for å lese eller skrive i dette forumet.',
	'LOGIN_INFO'						=> 'Du må være registrert for å kunne logge inn. Registreringen tar bare noen få øyeblikk, men gir deg større muligheter. Systemadministratoren kan også gi flere tillatelser til registrerte brukere. Før du registrerer deg, bør du gjøre deg kjent med våre vilkår for bruk og andre retningslinjer. Sørg også for at du leser alle forumregler etter hvert som du navigerer deg rundt på systemet.',
	'LOGIN_VIEWFORUM'					=> 'Systemet krever at du er registrert og innlogget for å vise dette forumet.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Du må være registrert og innlogget for å kunne redigere innlegg i dette forumet.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Du må være registrert og innlogget for å kunne vise listen over hvem som er online.',
	'LOGIN_REQUIRED'					=> 'Du må logge inn for å gjøre dette.',
	'LOGOUT'							=> 'Logg ut',
	'LOGOUT_USER'						=> 'Logg ut [ %s ]',
	'LOG_ME_IN'							=> 'Husk meg',

	'MAIN'					=> 'Hoved',
	'MARK'					=> 'Merk',
	'MARK_ALL'				=> 'Merk alle',
	'MARK_ALL_READ'			=> 'Merk alle som lest',
	'MARK_FORUMS_READ'		=> 'Merk fora som lest',
	'MARK_READ'				=> 'Merk som lest',
	'MARK_SUBFORUMS_READ'	=> 'Merk underfora som lest',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Moderatorkontrollpanel',
	'MCP_SHORT'				=> 'MCP',
	'MEMBERLIST'			=> 'Forumbrukere',
	'MEMBERLIST_EXPLAIN'	=> 'Vis fullstendig liste over forumbrukere',
	'MERGE'					=> 'Slå sammen',
	'MERGE_POSTS'			=> 'Flytt innlegg',
	'MERGE_TOPIC'			=> 'Slå sammen emne',
	'MESSAGE'				=> 'Melding',
	'MESSAGES'				=> 'Meldinger',
	'MESSAGES_COUNT'		=> array(
		1	=> '%d melding',
		2	=> '%d meldinger',
	),
	'MESSAGE_BODY'			=> 'Meldingstekst',
	'MINUTES'				=> 'Minutter',
	'MODERATE'				=> 'Moderer',
	'MODERATOR'				=> 'Moderator',
	'MODERATORS'			=> 'Moderatorer',
	'MODULE_NOT_ACCESS'		=> 'Modulen er ikke tilgjengelig',
	'MODULE_NOT_FIND'		=> 'Finner ikke modulen %s',
	'MODULE_FILE_INCORRECT_CLASS'	=> 'Modulfil %s inneholder ikke riktig klasse [%s]',
	'MONTH'					=> 'Måned',
	'MOVE'					=> 'Flytt',

	'NA'						=> 'I/T',
	'NEWEST_USER'				=> 'Vår nyeste forumbruker: <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Ny melding',
	'NEW_MESSAGES'				=> 'Nye meldinger',
	'NEW_POST'					=> 'Nytt innlegg',	// Not used anymore
	'NEW_POSTS'					=> 'Nye innlegg',	// Not used anymore
	'NEXT'						=> 'Neste',		// Used in pagination
	'NEXT_STEP'					=> 'Neste',
	'NEVER'						=> 'Aldri',
	'NO'						=> 'Nei',
	'NO_NOTIFICATIONS'			=> 'Du har ingen varsler',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Du har ikke tillatelse til å administrere denne gruppen.',
	'NOT_AUTHORISED'			=> 'Du har ikke tilgang til dette området.',
	'NOT_WATCHING_FORUM'		=> 'Du abonnerer ikke lenger på oppdateringer på dette forumet.',
	'NOT_WATCHING_TOPIC'		=> 'Du abonnerer ikke lenger på dette emnet.',
	'NOTIFICATIONS'				=> 'Varsler',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and 2 others replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK'				=> array(
		1	=> '<strong>Svar</strong> fra %1$s i bokmerket emne:',
	),
	'NOTIFICATION_FORUM'				=> '<em>Forum:</em> %1$s',
	'NOTIFICATION_GROUP_REQUEST'		=> '<strong>Gruppeforespørsel</strong> from %1$s om å bli med i gruppen %2$s.',
	'NOTIFICATION_GROUP_REQUEST_APPROVED'	=> '<strong>Gruppeforespørsel godkjent</strong> for å bli med i gruppen %1$s.',
	'NOTIFICATION_PM'					=> '<strong>Privat melding</strong> fra %1$s:',
	'NOTIFICATION_POST'					=> array(
		1	=> '<strong>Reply</strong> from %1$s in topic:',
	),
	'NOTIFICATION_POST_APPROVED'		=> '<strong>Innlegg godkjent</strong>:',
	'NOTIFICATION_POST_DISAPPROVED'		=> '<strong>Innlegg avslått</strong>:',
	'NOTIFICATION_POST_IN_QUEUE'		=> '<strong>Innleggsgodkjenning</strong> forespurt av %1$s:',
	'NOTIFICATION_QUOTE'				=> array(
		1	=> '<strong>Sitert</strong> av %1$s i:',
	),
	'NOTIFICATION_REFERENCE'			=> '«%1$s»',
	'NOTIFICATION_REASON'				=> '<em>Begrunnelse:</em> %1$s.',
	'NOTIFICATION_REPORT_PM'			=> '<strong>Privat melding rapportert</strong> av %1$s:',
	'NOTIFICATION_REPORT_POST'			=> '<strong>Innlegg rapportert</strong> av %1$s:',
	'NOTIFICATION_REPORT_CLOSED'		=> '<strong>Rapport lukket</strong> av %1$s for:',
	'NOTIFICATION_TOPIC'				=> '<strong>Nytt emne</strong> av %1$s:',
	'NOTIFICATION_TOPIC_APPROVED'		=> '<strong>Emne godkjent</strong>:',
	'NOTIFICATION_TOPIC_DISAPPROVED'	=> '<strong>Emne avslått</strong>:',
	'NOTIFICATION_TOPIC_IN_QUEUE'		=> '<strong>Emnegodkjenning</strong> forespurt av %1$s:',
	'NOTIFICATION_TYPE_NOT_EXIST'		=> 'Varslingstypen "%s" mangler på filsystemet.',
	'NOTIFICATION_ADMIN_ACTIVATE_USER'	=> '<strong>Aktivering kreves</strong> for nylig registrert bruker: «%1$s»',
	// Used in conjuction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS'			=> 'andre',
	'NOTIFICATION_X_OTHERS'				=> array(
		2	=> '%d andre',
	),
	'NOTIFY_ADMIN'				=> 'Varsle systemadministratoren eller webmaster.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Varsle systemadministratoren eller webmaster: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Du har ikke tilgang til denne filen.',
	'NO_ACTION'					=> 'Ingen handling er angitt.',
	'NO_ADMINISTRATORS'			=> 'Det finnes ingen administratorer.',
	'NO_AUTH_ADMIN'				=> 'Du har ikke tilgang til administrasjonskontrollpanelet ettersom du ikke har administrasjonstillatelser.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Du kan ikke autentiseres på nytt som en annen bruker.',
	'NO_AUTH_OPERATION'			=> 'Du har ikke de nødvendige tillatelser til å gjøre dette.',
	'NO_AVATARS'				=> 'Ingen avatarer er tilgjengelige for øyeblikket',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Kan ikke koble til SMTP-vert: %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Ingen fødselsdager i dag',
	'NO_EMAIL_MESSAGE'			=> 'E-postmeldingen var tom.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Kan ikke hente e-postserverens svarkoder.',
	'NO_EMAIL_SUBJECT'			=> 'Intet e-postemne er angitt.',
	'NO_FORUM'					=> 'Forumet du valgte, finnes ikke.',
	'NO_FORUMS'					=> 'Dette systemet har ingen fora.',
	'NO_GROUP'					=> 'Den forespurte brukergruppen finnes ikke.',
	'NO_GROUP_MEMBERS'			=> 'Denne gruppen har for øyeblikket ingen medlemmer.',
	'NO_IPS_DEFINED'			=> 'Ingen IP-adresser eller vertsnavn er definert',
	'NO_MEMBERS'				=> 'Finner ingen forumbrukere med dette søkekriteriet.',
	'NO_MESSAGES'				=> 'Ingen meldinger',
	'NO_MODE'					=> 'Modus er ikke angitt.',
	'NO_MODERATORS'				=> 'Det finnes ingen moderatorer.',
	'NO_NEW_MESSAGES'			=> 'Ingen nye meldinger',
	'NO_NEW_POSTS'				=> 'Ingen nye innlegg',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'Ingen registrerte brukere',
	'NO_POSTS'					=> 'Ingen innlegg',
	'NO_POSTS_TIME_FRAME'		=> 'Det finnes ingen innlegg i dette emnet for valgte tidsrom.',
	'NO_FEED_ENABLED'			=> 'Feeder er ikke tilgjengelige på dette systemet.',
	'NO_FEED'					=> 'Den forespurte feeden er ikke tilgjengelig.',
	'NO_STYLE_DATA'				=> 'Kan ikke hente stildata',
	'NO_SUBJECT'				=> 'Intet emne er angitt',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'Den angitte søkemotoren finnes ikke.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Ingen autentiseringsmetoder som støttes.',
	'NO_TOPIC'					=> 'Det forespurte emnet finnes ikke.',
	'NO_TOPIC_FORUM'			=> 'Emnet eller forumet finnes ikke lenger.',
	'NO_TOPICS'					=> 'Det er ingen emner eller innlegg i dette forumet.',
	'NO_TOPICS_TIME_FRAME'		=> 'Det finnes ingen emner i dette forumet for valgte tidsrom.',
	'NO_UNREAD_POSTS'			=> 'Ingen uleste innlegg',
	'NO_UPLOAD_FORM_FOUND'		=> 'Opplasting startet, men fant intet gyldig filopplastingsskjema.',
	'NO_USER'					=> 'Den forespurte brukeren finnes ikke.',
	'NO_USERS'					=> 'De forespurte brukerne finnes ikke.',
	'NO_USER_SPECIFIED'			=> 'Intet brukernavn er angitt.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS'		=> array(
		1	=> '%d vedlegg',
		2	=> '%d vedlegg',
	),
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Ingen innlegg i køen',		// 0
		1			=> 'Ett innlegg i køen',		// 1
		2			=> '%d innlegg i køen',   		// 2+
	),

	'OCCUPATION'				=> 'Yrke',
	'OFFLINE'					=> 'Offline',
	'ONLINE'					=> 'Online',
	'ONLINE_BUDDIES'			=> 'Venner online',
	// "... :: x registered and y hidden"
	'ONLINE_USERS_TOTAL'		=> array(
		1	=> 'Totalt er det <strong>%1$d</strong> bruker online: %2$s og %3$s',
		2	=> 'Totalt er det <strong>%1$d</strong> brukere online: %2$s og %3$s',
	),
	// "... :: x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS'	=> array(
		1	=> 'Totalt er det <strong>%1$d</strong> bruker online: %2$s, %3$s og %4$s',
		2	=> 'Totalt er det <strong>%1$d</strong> brukere online: %2$s, %3$s og %4$s',
	),
	'OPTIONS'					=> 'Alternativer',

	'PAGE_OF'				=> 'Side <strong>%1$d</strong> av <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER'		=> 'Side %s',
	'PASSWORD'				=> 'Passord',
	'PIXEL'					=> 'px',
	'PIXELS'				=> array(
		1	=> '%d piksel',
		2	=> '%d piksler',
	),
	'PLAY_QUICKTIME_FILE'	=> 'Spill av Quicktime-fil',
	'PLEASE_WAIT'			=> 'Vent litt.',
	'PM'					=> 'PM',
	'PM_REPORTED'			=> 'Klikk for å vise rapport',
	'POSTING_MESSAGE'		=> 'Legger inn melding i %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Skriver privat melding',
	'POST'					=> 'Legg inn',
	'POST_ANNOUNCEMENT'		=> 'Kunngjør',
	'POST_STICKY'			=> 'Fest',
	'POSTED'				=> 'Lagt inn',
	'POSTED_IN_FORUM'		=> 'i',
	'POSTED_ON_DATE'		=> 'den',
	'POSTS'					=> 'Innlegg',
	'POSTS_UNAPPROVED'		=> 'Minst ett innlegg i dette emnet er ikke godkjent.',
	'POSTS_UNAPPROVED_FORUM'=> 'Minst ett innlegg i dette forumet er ikke godkjent.',
	'POST_BY_AUTHOR'		=> 'av',
	'POST_BY_FOE'			=> '<strong>%1$s</strong>, som for øyeblikket er på ignoreringslisten din, skrev dette innlegget.',
	'POST_DISPLAY'			=> '%1$sVis dette innlegget%2$s.',
	'POST_DAY'				=> '%.2f innlegg per dag',
	'POST_DELETED_ACTION'	=> 'Slettet innlegg:',
	'POST_DELETED'			=> 'Dette innlegget er slettet.',
	'POST_DELETED_BY'		=> '<strong>%2$s</strong> slettet innlegget av <strong>%1$s</strong> den %3$s.',
	'POST_DELETED_BY_REASON'=> '<strong>%2$s</strong> slettet innlegget av <strong>%1$s</strong> den %3$s med følgende begrunnelse: %4$s',
	'POST_DETAILS'			=> 'Innleggsdetaljer',
	'POST_NEW_TOPIC'		=> 'Legg inn nytt emne',
	'POST_PCT'				=> '%.2f %% av alle innlegg',
	'POST_PCT_ACTIVE'		=> '%.2f %% av brukerens innlegg',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f %% av dine innlegg',
	'POST_REPLY'			=> 'Legg inn et svar',
	'POST_REPORTED'			=> 'Klikk for å vise rapport',
	'POST_SUBJECT'			=> 'Innleggsemne',
	'POST_TIME'				=> 'Innleggsklokkeslett',
	'POST_TOPIC'			=> 'Legg inn et nytt emne',
	'POST_UNAPPROVED_ACTION'	=> 'Inlegg som avventer godkjenning:',
	'POST_UNAPPROVED'		=> 'Dette innlegget er ikke godkjent.',
	'POWERED_BY'			=> 'Kjører på %s',
	'PREVIEW'				=> 'Forhåndsvis',
	'PREVIOUS'				=> 'Forrige',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Forrige',
	'PRIVACY'				=> 'Personvernpolicy',
	'PRIVATE_MESSAGE'		=> 'Privat melding',
	'PRIVATE_MESSAGES'		=> 'Private meldinger',
	'PRIVATE_MESSAGING'		=> 'Privatmeldinger',
	'PROFILE'				=> 'Brukerkontrollpanel',

	'QUICK_LINKS'			=> 'Hurtiglenker',

	'RANK'						=> 'Grad',
	'READING_FORUM'				=> 'Viser emner i %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Leser global kunngjøring',
	'READING_LINK'				=> 'Følger forumlenke %s',
	'READING_TOPIC'				=> 'Leser emne i %s',
	'READ_PROFILE'				=> 'Profil',
	'REASON'					=> 'Begrunnelse',
	'RECORD_ONLINE_USERS'		=> 'Rekord for antall brukere online: <strong>%1$s</strong> den %2$s',
	'REDIRECT'					=> 'Omadresser',
	'REDIRECTS'					=> 'Omadresseringer totalt',
	'REGISTER'					=> 'Registrer',
	'REGISTERED_USERS'			=> 'Registrerte brukere:',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE'			=> array(
		1	=> 'Det er %1$d registrert bruker og %2$s online',
		2	=> 'Det er %1$d registrerte brukere og %2$s online',
	),
	'REG_USERS_TOTAL'			=> array(
		1	=> '%d registrert',
		2	=> '%d registrerte',
	),
	'REMOVE'					=> 'Fjern',
	'REMOVE_INSTALL'			=> 'Slett, flytt eller endre navn på installasjonsmappen før du bruker systemet. Hvis dette mappen finnes, vil bare administrasjonskontrollpanelet (ACP) være tilgjengelig.',
	'REPLIES'					=> 'Svar',
	'REPLY_WITH_QUOTE'			=> 'Svar med sitat',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Svarer på global kunngjøring',
	'REPLYING_MESSAGE'			=> 'Svarer på melding i %s',
	'REPORT_BY'					=> 'Rapport av',
	'REPORT_POST'				=> 'Rapporter dette innlegget',
	'REPORTING_POST'			=> 'Rapporterer innlegg',
	'RESEND_ACTIVATION'			=> 'Send aktiverings-e-post på nytt',
	'RESET'						=> 'Tilbakestill',
	'RESTORE_PERMISSIONS'		=> 'Gjenopprett tillatelser',
	'RETURN_INDEX'				=> '%sGå tilbake til indekssiden%s',
	'RETURN_FORUM'				=> '%sGå tilbake til det sist besøkte forumet%s',
	'RETURN_PAGE'				=> '%sGå tilbake til forrige side%s',
	'RETURN_TOPIC'				=> '%sGå tilbake til det sist besøkte emnet%s',
	'RETURN_TO'					=> 'Gå tilbake til «%s»',
	'RETURN_TO_INDEX'			=> 'Gå tilbake til forumindeksen',
	'FEED'						=> 'Feed',
	'FEED_NEWS'					=> 'Nyheter',
	'FEED_TOPICS_ACTIVE'		=> 'Aktive emner',
	'FEED_TOPICS_NEW'			=> 'Nye emner',
	'RULES_ATTACH_CAN'			=> 'Du <strong>kan</strong> laste opp vedlegg i dette forumet',
	'RULES_ATTACH_CANNOT'		=> 'Du <strong>kan ikke</strong> laste opp vedlegg i dette forumet',
	'RULES_DELETE_CAN'			=> 'Du <strong>kan</strong> slette egne innlegg i dette forumet',
	'RULES_DELETE_CANNOT'		=> 'Du <strong>kan ikke</strong> slette egne innlegg i dette forumet',
	'RULES_DOWNLOAD_CAN'		=> 'Du <strong>kan</strong> laste ned vedlegg i dette forumet',
	'RULES_DOWNLOAD_CANNOT'		=> 'Du <strong>kan ikke</strong> laste ned vedlegg i dette forumet',
	'RULES_EDIT_CAN'			=> 'Du <strong>kan</strong> redigere egne innlegg i dette forumet',
	'RULES_EDIT_CANNOT'			=> 'Du <strong>kan ikke</strong> redigere egne innlegg i dette forumet',
	'RULES_LOCK_CAN'			=> 'Du <strong>kan</strong> låse egne emner i dette forumet',
	'RULES_LOCK_CANNOT'			=> 'Du <strong>kan ikke</strong> låse egne emner i dette forumet',
	'RULES_POST_CAN'			=> 'Du <strong>kan</strong> opprette nye emner i dette forumet',
	'RULES_POST_CANNOT'			=> 'Du <strong>kan ikke</strong> opprette nye emner i dette forumet',
	'RULES_REPLY_CAN'			=> 'Du <strong>kan</strong> svare på emner i dette forumet',
	'RULES_REPLY_CANNOT'		=> 'Du <strong>kan ikke</strong> svare på emner i dette forumet',
	'RULES_VOTE_CAN'			=> 'Du <strong>kan</strong> delta i avstemminger i dette forumet',
	'RULES_VOTE_CANNOT'			=> 'Du <strong>kan ikke</strong> delta i avstemminger i dette forumet',

	'SEARCH'					=> 'Søk',
	'SEARCH_MINI'				=> 'Søk…',
	'SEARCH_ADV'				=> 'Avansert søk',
	'SEARCH_ADV_EXPLAIN'		=> 'Vis avanserte søkealternativer',
	'SEARCH_KEYWORDS'			=> 'Søk etter nøkkelord',
	'SEARCHING_FORUMS'			=> 'Søke i fora',
	'SEARCH_ACTIVE_TOPICS'		=> 'Aktive emner',
	'SEARCH_FOR'				=> 'Søk etter',
	'SEARCH_FORUM'				=> 'Søk i dette forumet…',
	'SEARCH_NEW'				=> 'Nye innlegg',
	'SEARCH_POSTS_BY'			=> 'Søk i innlegg av',
	'SEARCH_SELF'				=> 'Dine innlegg',
	'SEARCH_TOPIC'				=> 'Søk i dette emnet…',
	'SEARCH_UNANSWERED'			=> 'Ubesvarte innlegg',
	'SEARCH_UNREAD'				=> 'Uleste innlegg',
	'SEARCH_USER_POSTS'			=> 'Søk i brukers innlegg',
	'SECONDS'					=> 'Sekunder',
	'SEE_ALL'					=> 'Se alt',
	'SELECT'					=> 'Velg',
	'SELECT_ALL_CODE'			=> 'Velg alt',
	'SELECT_DESTINATION_FORUM'	=> 'Velg et målforum',
	'SELECT_FORUM'				=> 'Velg et forum',
	'SEND_EMAIL'				=> 'Send e-post',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Send e-post til %s',
	'SEND_PRIVATE_MESSAGE'		=> 'Send privat melding',
	'SETTINGS'					=> 'Innstillinger',
	'SIGNATURE'					=> 'Signatur',
	'SKIP'						=> 'Hopp til innhold',
	'SKYPE'						=> 'Skype',
	'SMTP_NO_AUTH_SUPPORT'		=> 'SMTP-serveren støtter ikke autentisering.',
	'SORRY_AUTH_READ'			=> 'Du er ikke godkjent for lesing av dette forumet.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Du er ikke godkjent for nedlasting av dette vedlegget.',
	'SORT_BY'					=> 'Sorter etter',
	'SORT_JOINED'				=> 'Registreringsdato',
	'SORT_LOCATION'				=> 'Sted',
	'SORT_RANK'					=> 'Grad',
	'SORT_POSTS'				=> 'Innlegg',
	'SORT_TOPIC_TITLE'			=> 'Emnetittel',
	'SORT_USERNAME'				=> 'Brukernavn',
	'SPLIT_TOPIC'				=> 'Splitt emne',
	'SQL_ERROR_OCCURRED'		=> 'Det oppstod en SQL-feil under henting av denne siden. Kontakt %ssystemadministratoren%s hvis dette problemet vedvarer.',
	'STATISTICS'				=> 'Statistikk',
	'START_WATCHING_FORUM'		=> 'Abonner på forum',
	'START_WATCHING_TOPIC'		=> 'Abonner på emne',
	'STOP_WATCHING_FORUM'		=> 'Stopp abonnement på forum',
	'STOP_WATCHING_TOPIC'		=> 'Stopp abonnement på emne',
	'STRING_LIST_MULTI'			=> '%1$s og %2$s',
	'STRING_LIST_SIMPLE'		=> '%1$s og %2$s',
	'SUBFORUM'					=> 'Underforum',
	'SUBFORUMS'					=> 'Underfora',
	'SUBJECT'					=> 'Emne',
	'SUBMIT'					=> 'Send',

	'TB'				=> 'TB',
	'TERMS_USE'			=> 'Vilkår for bruk',
	'TEST_CONNECTION'	=> 'Test tilkobling',
	'THE_TEAM'			=> 'Teamet',
	'TIB'				=> 'TiB',
	'TIME'				=> 'Klokkeslett',
	'TIMEOUT_PROCESSING_REQ'			=> 'Forespørselen ble tidsavbrutt.',

	'TOO_LARGE'						=> 'Den angitte verdien er for stor.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'Den angitte verdien for <strong>Maksimalt antall tillatte mottakere per private melding</strong> er for stor.',

	'TOO_LONG'						=> 'Den angitte verdien er for lang.',

	'TOO_LONG_CONFIRM_CODE'			=> 'Bekreftelseskoden du angav, er for lang.',
	'TOO_LONG_DATEFORMAT'			=> 'Datoformatet du angav, er for langt.',
	'TOO_LONG_JABBER'				=> 'Jabber-kontonavnet du angav, er for langt.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Passordet du angav, er for langt.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Passordbekreftelsen du angav, er for lang.',
	'TOO_LONG_USER_PASSWORD'		=> 'Passordet du angav, er for langt.',
	'TOO_LONG_USERNAME'				=> 'Brukernavnet du angav, er for langt.',
	'TOO_LONG_EMAIL'				=> 'E-postadressen du angav, er for langt.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Du har prøvd å stemme på for mange alternativer.',

	'TOO_SHORT'						=> 'Den angitte verdien er for kort.',

	'TOO_SHORT_CONFIRM_CODE'		=> 'Bekreftelseskoden du angav, er for kort.',
	'TOO_SHORT_DATEFORMAT'			=> 'Datoformatet du angav, er for kort.',
	'TOO_SHORT_JABBER'				=> 'Jabber-kontonavnet du angav, er for kort.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Passordet du angav, er for kort.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Passordbekreftelsen du angav, er for lang.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Passordet du angav, er for kort.',
	'TOO_SHORT_USERNAME'			=> 'Brukernavnet du angav, er for kort.',
	'TOO_SHORT_EMAIL'				=> 'E-postadressen du angav, er for kort.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'E-postadressebekreftelsen du angav, er for kort.',
	'TOO_SMALL'						=> 'Verdien du angav, er for liten.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'Den angitte verdien for <strong>Maksimalt antall tillatte mottakere per private melding</strong> er for liten.',

	'TOPIC'				=> 'Emne',
	'TOPICS'			=> 'Emner',
	'TOPICS_UNAPPROVED'	=> 'Minst ett emne i dette forumet er ikke godkjent.',
	'TOPIC_ICON'		=> 'Emneikon',
	'TOPIC_LOCKED'		=> 'Dette emnet er låst – du kan ikke lenger redigere innlegg eller svare.',
	'TOPIC_LOCKED_SHORT'=> 'Emne låst',
	'TOPIC_MOVED'		=> 'Flyttet emne',
	'TOPIC_REVIEW'		=> 'Emnekontroll',
	'TOPIC_TITLE'		=> 'Emnetittel',
	'TOPIC_UNAPPROVED'	=> 'Dette emnet er ikke godkjent.',
	'TOPIC_DELETED'		=> 'Dette emnet er slettet.',
	'TOTAL_ATTACHMENTS'	=> 'Vedlegg',
	'TOTAL_LOGS'		=> array(
		1	=> '%d logg',
		2	=> '%d logger',
	),
	'TOTAL_PMS'		=> array(
		1	=> '%d privat melding totalt',
		2	=> '%d private meldinger totalt',
	),
	'TOPIC_POLL'		=> 'Dette emnet har en avstemming.',
	'TOTAL_POSTS'		=> 'Innlegg totalt',
	'TOTAL_POSTS_COUNT'	=> array(
		2	=> 'Innlegg totalt: <strong>%d</strong>',
	),
	'TOPIC_REPORTED'	=> 'Dette emnet er rapportert',
	'TOTAL_TOPICS'		=> array(
		2	=> 'Emner totalt: <strong>%d</strong>',
	),
	'TOTAL_USERS'		=> array(
		2	=> 'Medlemmer totalt: <strong>%d</strong>',
	),
	'TRACKED_PHP_ERROR'	=> 'Sporede PHP-feil: %s',
	'TWITTER'			=> 'Twitter',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Kan ikke fastslå bildestørrelsen. Kontroller at angitt URL er korrekt.',
	'UNABLE_TO_DELIVER_FILE'=> 'Kan ikke levere filen.',
	'UNKNOWN_BROWSER'		=> 'Ukjent nettleser',
	'UNMARK_ALL'			=> 'Fjern all merking',
	'UNREAD_MESSAGES'		=> 'Uleste meldinger',
	'UNREAD_POST'			=> 'Ulest innlegg',
	'UNREAD_POSTS'			=> 'Uleste innlegg',
	'UNWATCH_FORUM_CONFIRM'		=> 'Er du sikker på at du vil stoppe abonnementet på dette forumet?',
	'UNWATCH_FORUM_DETAILED'	=> 'Er du sikker på at du vil stoppe abonnementet på forumet «%s»?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Er du sikker på at du vil stoppe abonnementet på dette emnet?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Er du sikker på at du vil stoppe abonnementet på emnet «%s»?',
	'UNWATCHED_FORUMS'			=> 'Du abonnerer ikke lenger på de valgte foraene.',
	'UNWATCHED_TOPICS'			=> 'Du abonnerer ikke lenger på valgte emnene.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Du abonnerer ikke lenger på de valgte oppføringene.',
	'UPDATE'				=> 'Oppdater',
	'UPLOAD_IN_PROGRESS'	=> 'Opplastingen pågår nå.',
	'URL_REDIRECT'			=> 'Hvis nettleseren din ikke støtter meta-videresending, %sklikker du HER for å bli videresendt%s.',
	'USERGROUPS'			=> 'Grupper',
	'USERNAME'				=> 'Brukernavn',
	'USERNAMES'				=> 'Brukernavn',
	'USER_AVATAR'			=> 'Brukeravatar',
	'USER_CANNOT_READ'		=> 'Du kan ikke lese innlegg i dette forumet.',
	'USER_POSTS'			=> array(
		1	=> '%d innlegg',
		2	=> '%d innlegg',
	),
	'USERS'					=> 'Brukere',
	'USE_PERMISSIONS'		=> 'Test brukerens tillatelser',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Vi beklager, men du har ikke tilgang til å bruke denne funksjonen. Du har kanskje nylig registrert deg her, og må kanskje delta mer for å kunne bruke denne funksjonen.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Vist',
	'VIEWED_COUNTS'		=> array(
		0	=> 'Ikke vist ennå',
		1	=> 'Vist %d gang',
		2	=> 'Vist %d ganger',
	),
	'VIEWING_CONTACT_ADMIN'		=> 'Viser kontaktsiden',
	'VIEWING_FAQ'				=> 'Viser OSS',
	'VIEWING_MEMBERS'			=> 'Viser medlemsdetaljer',
	'VIEWING_ONLINE'			=> 'Viser hvem som er online',
	'VIEWING_MCP'				=> 'Viser moderatorkontrollpanelet',
	'VIEWING_MEMBER_PROFILE'	=> 'Viser medlemsprofil',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Viser private meldinger',
	'VIEWING_REGISTER'			=> 'Registrerer konto',
	'VIEWING_UCP'				=> 'Viser brukerkontrollpanelet',
	'VIEWS'						=> 'Visninger',
	'VIEW_BOOKMARKS'			=> 'Vis bokmerker',
	'VIEW_FORUM_LOGS'			=> 'Vis logger',
	'VIEW_LATEST_POST'			=> 'Vis siste innlegg',
	'VIEW_NEWEST_POST'			=> 'Vis første uleste innlegg',
	'VIEW_NOTES'				=> 'Vis brukernotater',
	'VIEW_ONLINE_TIMES'			=> array(
		1	=> 'basert på brukere som har vært aktive det siste minuttet',
		2	=> 'basert på brukere som har vært aktive de siste %d minuttene',
	),
	'VIEW_TOPIC'				=> 'Vis emne',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Kunngjøring: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Global kunngjøring: ',
	'VIEW_TOPIC_LOCKED'			=> 'Låst: ',
	'VIEW_TOPIC_LOGS'			=> 'Vis logger',
	'VIEW_TOPIC_MOVED'			=> 'Flyttet: ',
	'VIEW_TOPIC_POLL'			=> 'Avstemming: ',
	'VIEW_TOPIC_STICKY'			=> 'Festet: ',
	'VISIT_WEBSITE'				=> 'Besøk nettsted',

	'WARNINGS'			=> 'Advarsler',
	'WARN_USER'			=> 'Advar bruker',
	'WATCH_FORUM_CONFIRM'	=> 'Er du sikker på at du vil abonnere på dette forumet?',
	'WATCH_FORUM_DETAILED'	=> 'Er du sikker på at du vil abonnere på forumet «%s»?',
	'WATCH_TOPIC_CONFIRM'	=> 'Er du sikker på at du vil abonnere på dette emnet?',
	'WATCH_TOPIC_DETAILED'	=> 'Er du sikker på at du vil abonnere på emnet «%s»?',
	'WELCOME_SUBJECT'	=> 'Velkommen til %s-foraene',
	'WEBSITE'			=> 'Nettsted',
	'WHOIS'				=> 'Whois',
	'WHO_IS_ONLINE'		=> 'Hvem er online',
	'WLM'				=> 'WLM',
	'WRONG_PASSWORD'	=> 'Du angav feil passord.',

	'WRONG_DATA_COLOUR'			=> 'Fargeverdien du angav, er ugyldig.',
	'WRONG_DATA_JABBER'			=> 'Navnet du angav, er ikke et gyldig Jabber-kontonavn.',
	'WRONG_DATA_LANG'			=> 'Språket du angav, er ikke gyldig.',
	'WRONG_DATA_POST_SD'		=> 'Sorteringsretningen du angav for innlegg, er ikke gyldig.',
	'WRONG_DATA_POST_SK'		=> 'Sorteringsalternativet du angav for innlegg, er ikke gyldig.',
	'WRONG_DATA_TOPIC_SD'		=> 'Sorteringsretningen du angav for emne, er ikke gyldig.',
	'WRONG_DATA_TOPIC_SK'		=> 'Sorteringsalternativet du angav for emne, er ikke gyldig.',
	'WROTE'						=> 'skrev',

	'YAHOO'				=> 'Yahoo Messenger',
	'YOUTUBE'			=> 'YouTube',
	'YEAR'				=> 'Year',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-DD)',
	'YES'				=> 'Ja',
	'YOU_LAST_VISIT'	=> 'Forrige besøk var: %s',

	'datetime'			=> array(
		'TODAY'		=> 'I dag',
		'TOMORROW'	=> 'I morgen',
		'YESTERDAY'	=> 'I går',
		'AGO'		=> array(
			0		=> 'mindre enn ett minutt siden',
			1		=> '%d minutt siden',
			2		=> '%d minutter siden',
		),

		'Sunday'	=> 'søndag',
		'Monday'	=> 'mandag',
		'Tuesday'	=> 'tirsdag',
		'Wednesday'	=> 'onsdag',
		'Thursday'	=> 'torsdag',
		'Friday'	=> 'fredag',
		'Saturday'	=> 'lørdag',

		'Sun'		=> 'søn',
		'Mon'		=> 'man',
		'Tue'		=> 'tir',
		'Wed'		=> 'ons',
		'Thu'		=> 'tor',
		'Fri'		=> 'fre',
		'Sat'		=> 'lør',

		'January'	=> 'januar',
		'February'	=> 'februar',
		'March'		=> 'mars',
		'April'		=> 'april',
		'May'		=> 'mai',
		'June'		=> 'juni',
		'July'		=> 'juli',
		'August'	=> 'august',
		'September' => 'september',
		'October'	=> 'oktober',
		'November'	=> 'november',
		'December'	=> 'desember',

		'Jan'		=> 'jan',
		'Feb'		=> 'feb',
		'Mar'		=> 'mar',
		'Apr'		=> 'apr',
		'May_short'	=> 'mai',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'jun',
		'Jul'		=> 'jul',
		'Aug'		=> 'aug',
		'Sep'		=> 'sep',
		'Oct'		=> 'okt',
		'Nov'		=> 'nov',
		'Dec'		=> 'des',
	),

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones'				=> array(
		'UTC'					=> 'UTC',
		'UTC_OFFSET'			=> 'UTC%1$s',
		'UTC_OFFSET_CURRENT'	=> 'UTC%1$s - %2$s',

		'Etc/GMT-12'	=> 'UTC+12',
		'Etc/GMT-11'	=> 'UTC+11',
		'Etc/GMT-10'	=> 'UTC+10',
		'Etc/GMT-9'		=> 'UTC+9',
		'Etc/GMT-8'		=> 'UTC+8',
		'Etc/GMT-7'		=> 'UTC+7',
		'Etc/GMT-6'		=> 'UTC+6',
		'Etc/GMT-5'		=> 'UTC+5',
		'Etc/GMT-4'		=> 'UTC+4',
		'Etc/GMT-3'		=> 'UTC+3',
		'Etc/GMT-2'		=> 'UTC+2',
		'Etc/GMT-1'		=> 'UTC+1',
		'Etc/GMT+1'		=> 'UTC-1',
		'Etc/GMT+2'		=> 'UTC-2',
		'Etc/GMT+3'		=> 'UTC-3',
		'Etc/GMT+4'		=> 'UTC-4',
		'Etc/GMT+5'		=> 'UTC-5',
		'Etc/GMT+6'		=> 'UTC-6',
		'Etc/GMT+7'		=> 'UTC-7',
		'Etc/GMT+8'		=> 'UTC-8',
		'Etc/GMT+9'		=> 'UTC-9',
		'Etc/GMT+10'	=> 'UTC-10',
		'Etc/GMT+11'	=> 'UTC-11',
		'Etc/GMT+12'	=> 'UTC-12',

		'Africa/Abidjan'	=> 'Afrika/Abidjan',
		'Africa/Accra'		=> 'Afrika/Accra',
		'Africa/Addis_Ababa'	=> 'Afrika/Addis Ababa',
		'Africa/Algiers'	=> 'Afrika/Algiers',
		'Africa/Asmara'		=> 'Afrika/Asmara',
		'Africa/Bamako'		=> 'Afrika/Bamako',
		'Africa/Bangui'		=> 'Afrika/Bangui',
		'Africa/Banjul'		=> 'Afrika/Banjul',
		'Africa/Bissau'		=> 'Afrika/Bissau',
		'Africa/Blantyre'	=> 'Afrika/Blantyre',
		'Africa/Brazzaville'	=> 'Afrika/Brazzaville',
		'Africa/Bujumbura'	=> 'Afrika/Bujumbura',
		'Africa/Cairo'		=> 'Afrika/Kairo',
		'Africa/Casablanca'	=> 'Afrika/Casablanca',
		'Africa/Ceuta'		=> 'Afrika/Ceuta',
		'Africa/Conakry'	=> 'Afrika/Conakry',
		'Africa/Dakar'		=> 'Afrika/Dakar',
		'Africa/Dar_es_Salaam'	=> 'Afrika/Dar es Salaam',
		'Africa/Djibouti'	=> 'Afrika/Djibouti',
		'Africa/Douala'		=> 'Afrika/Douala',
		'Africa/El_Aaiun'	=> 'Afrika/El Aaiun',
		'Africa/Freetown'	=> 'Afrika/Freetown',
		'Africa/Gaborone'	=> 'Afrika/Gaborone',
		'Africa/Harare'		=> 'Afrika/Harare',
		'Africa/Johannesburg'	=> 'Afrika/Johannesburg',
		'Africa/Juba'		=> 'Afrika/Juba',
		'Africa/Kampala'	=> 'Afrika/Kampala',
		'Africa/Khartoum'	=> 'Afrika/Khartoum',
		'Africa/Kigali'		=> 'Afrika/Kigali',
		'Africa/Kinshasa'	=> 'Afrika/Kinshasa',
		'Africa/Lagos'		=> 'Afrika/Lagos',
		'Africa/Libreville'	=> 'Afrika/Libreville',
		'Africa/Lome'		=> 'Afrika/Lome',
		'Africa/Luanda'		=> 'Afrika/Luanda',
		'Africa/Lubumbashi'	=> 'Afrika/Lubumbashi',
		'Africa/Lusaka'		=> 'Afrika/Lusaka',
		'Africa/Malabo'		=> 'Afrika/Malabo',
		'Africa/Maputo'		=> 'Afrika/Maputo',
		'Africa/Maseru'		=> 'Afrika/Maseru',
		'Africa/Mbabane'	=> 'Afrika/Mbabane',
		'Africa/Mogadishu'	=> 'Afrika/Mogadishu',
		'Africa/Monrovia'	=> 'Afrika/Monrovia',
		'Africa/Nairobi'	=> 'Afrika/Nairobi',
		'Africa/Ndjamena'	=> 'Afrika/Ndjamena',
		'Africa/Niamey'		=> 'Afrika/Niamey',
		'Africa/Nouakchott'	=> 'Afrika/Nouakchott',
		'Africa/Ouagadougou'	=> 'Afrika/Ouagadougou',
		'Africa/Porto-Novo'	=> 'Afrika/Porto-Novo',
		'Africa/Sao_Tome'	=> 'Afrika/Sao Tome',
		'Africa/Tripoli'	=> 'Afrika/Tripoli',
		'Africa/Tunis'		=> 'Afrika/Tunis',
		'Africa/Windhoek'	=> 'Afrika/Windhoek',

		'America/Adak'		=> 'Amerika/Adak',
		'America/Anchorage'	=> 'Amerika/Anchorage',
		'America/Anguilla'	=> 'Amerika/Anguilla',
		'America/Antigua'	=> 'Amerika/Antigua',
		'America/Araguaina'	=> 'Amerika/Araguaina',

		'America/Argentina/Buenos_Aires'	=> 'Amerika/Argentina/Buenos Aires',
		'America/Argentina/Catamarca'	=> 'Amerika/Argentina/Catamarca',
		'America/Argentina/Cordoba'		=> 'Amerika/Argentina/Cordoba',
		'America/Argentina/Jujuy'		=> 'Amerika/Argentina/Jujuy',
		'America/Argentina/La_Rioja'	=> 'Amerika/Argentina/La Rioja',
		'America/Argentina/Mendoza'		=> 'Amerika/Argentina/Mendoza',
		'America/Argentina/Rio_Gallegos'	=> 'Amerika/Argentina/Rio Gallegos',
		'America/Argentina/Salta'		=> 'Amerika/Argentina/Salta',
		'America/Argentina/San_Juan'	=> 'Amerika/Argentina/San Juan',
		'America/Argentina/San_Luis'	=> 'Amerika/Argentina/San Luis',
		'America/Argentina/Tucuman'		=> 'Amerika/Argentina/Tucuman',
		'America/Argentina/Ushuaia'		=> 'Amerika/Argentina/Ushuaia',

		'America/Aruba'			=> 'Amerika/Aruba',
		'America/Asuncion'		=> 'Amerika/Asuncion',
		'America/Atikokan'		=> 'Amerika/Atikokan',
		'America/Bahia'			=> 'Amerika/Bahia',
		'America/Bahia_Banderas'	=> 'Amerika/Bahia Banderas',
		'America/Barbados'		=> 'Amerika/Barbados',
		'America/Belem'			=> 'Amerika/Belem',
		'America/Belize'		=> 'Amerika/Belize',
		'America/Blanc-Sablon'	=> 'Amerika/Blanc-Sablon',
		'America/Boa_Vista'		=> 'Amerika/Boa Vista',
		'America/Bogota'		=> 'Amerika/Bogota',
		'America/Boise'			=> 'Amerika/Boise',
		'America/Cambridge_Bay'	=> 'Amerika/Cambridge Bay',
		'America/Campo_Grande'	=> 'Amerika/Campo Grande',
		'America/Cancun'		=> 'Amerika/Cancun',
		'America/Caracas'		=> 'Amerika/Caracas',
		'America/Cayenne'		=> 'Amerika/Cayenne',
		'America/Cayman'		=> 'Amerika/Cayman',
		'America/Chicago'		=> 'Amerika/Chicago',
		'America/Chihuahua'		=> 'Amerika/Chihuahua',
		'America/Costa_Rica'	=> 'Amerika/Costa Rica',
		'America/Creston'		=> 'Amerika/Creston',
		'America/Cuiaba'		=> 'Amerika/Cuiaba',
		'America/Curacao'		=> 'Amerika/Curacao',
		'America/Danmarkshavn'	=> 'Amerika/Danmarkshavn',
		'America/Dawson'		=> 'Amerika/Dawson',
		'America/Dawson_Creek'	=> 'Amerika/Dawson Creek',
		'America/Denver'		=> 'Amerika/Denver',
		'America/Detroit'		=> 'Amerika/Detroit',
		'America/Dominica'		=> 'Amerika/Dominica',
		'America/Edmonton'		=> 'Amerika/Edmonton',
		'America/Eirunepe'		=> 'Amerika/Eirunepe',
		'America/El_Salvador'	=> 'Amerika/El Salvador',
		'America/Fortaleza'		=> 'Amerika/Fortaleza',
		'America/Glace_Bay'		=> 'Amerika/Glace Bay',
		'America/Godthab'		=> 'Amerika/Godthab',
		'America/Goose_Bay'		=> 'Amerika/Goose Bay',
		'America/Grand_Turk'	=> 'Amerika/Grand Turk',
		'America/Grenada'		=> 'Amerika/Grenada',
		'America/Guadeloupe'	=> 'Amerika/Guadeloupe',
		'America/Guatemala'		=> 'Amerika/Guatemala',
		'America/Guayaquil'		=> 'Amerika/Guayaquil',
		'America/Guyana'		=> 'Amerika/Guyana',
		'America/Halifax'		=> 'Amerika/Halifax',
		'America/Havana'		=> 'Amerika/Havana',
		'America/Hermosillo'		=> 'Amerika/Hermosillo',
		'America/Indiana/Indianapolis'	=> 'Amerika/Indiana/Indianapolis',
		'America/Indiana/Knox'		=> 'Amerika/Indiana/Knox',
		'America/Indiana/Marengo'	=> 'Amerika/Indiana/Marengo',
		'America/Indiana/Petersburg'	=> 'Amerika/Indiana/Petersburg',
		'America/Indiana/Tell_City'	=> 'Amerika/Indiana/Tell City',
		'America/Indiana/Vevay'		=> 'Amerika/Indiana/Vevay',
		'America/Indiana/Vincennes'	=> 'Amerika/Indiana/Vincennes',
		'America/Indiana/Winamac'	=> 'Amerika/Indiana/Winamac',
		'America/Inuvik'		=> 'Amerika/Inuvik',
		'America/Iqaluit'		=> 'Amerika/Iqaluit',
		'America/Jamaica'		=> 'Amerika/Jamaica',
		'America/Juneau'		=> 'Amerika/Juneau',
		'America/Kentucky/Louisville'	=> 'Amerika/Kentucky/Louisville',
		'America/Kentucky/Monticello'	=> 'Amerika/Kentucky/Monticello',
		'America/Kralendijk'	=> 'Amerika/Kralendijk',
		'America/La_Paz'		=> 'Amerika/La Paz',
		'America/Lima'			=> 'Amerika/Lima',
		'America/Los_Angeles'	=> 'Amerika/Los Angeles',
		'America/Lower_Princes'	=> 'Amerika/Lower Princes',
		'America/Maceio'		=> 'Amerika/Maceio',
		'America/Managua'		=> 'Amerika/Managua',
		'America/Manaus'		=> 'Amerika/Manaus',
		'America/Marigot'		=> 'Amerika/Marigot',
		'America/Martinique'	=> 'Amerika/Martinique',
		'America/Matamoros'		=> 'Amerika/Matamoros',
		'America/Mazatlan'		=> 'Amerika/Mazatlan',
		'America/Menominee'		=> 'Amerika/Menominee',
		'America/Merida'		=> 'Amerika/Merida',
		'America/Metlakatla'	=> 'Amerika/Metlakatla',
		'America/Mexico_City'	=> 'Amerika/Mexico City',
		'America/Miquelon'		=> 'Amerika/Miquelon',
		'America/Moncton'		=> 'Amerika/Moncton',
		'America/Monterrey'		=> 'Amerika/Monterrey',
		'America/Montevideo'	=> 'Amerika/Montevideo',
		'America/Montreal'		=> 'Amerika/Montreal',
		'America/Montserrat'	=> 'Amerika/Montserrat',
		'America/Nassau'		=> 'Amerika/Nassau',
		'America/New_York'		=> 'Amerika/New York',
		'America/Nipigon'		=> 'Amerika/Nipigon',
		'America/Nome'			=> 'Amerika/Nome',
		'America/Noronha'		=> 'Amerika/Noronha',
		'America/North_Dakota/Beulah'		=> 'Amerika/North Dakota/Beulah',
		'America/North_Dakota/Center'		=> 'Amerika/North Dakota/Center',
		'America/North_Dakota/New_Salem'	=> 'Amerika/North Dakota/New Salem',
		'America/Ojinaga'		=> 'Amerika/Ojinaga',
		'America/Panama'		=> 'Amerika/Panama',
		'America/Pangnirtung'	=> 'Amerika/Pangnirtung',
		'America/Paramaribo'	=> 'Amerika/Paramaribo',
		'America/Phoenix'		=> 'Amerika/Phoenix',
		'America/Port-au-Prince'	=> 'Amerika/Port-au-Prince',
		'America/Port_of_Spain'	=> 'Amerika/Port of Spain',
		'America/Porto_Velho'	=> 'Amerika/Porto Velho',
		'America/Puerto_Rico'	=> 'Amerika/Puerto Rico',
		'America/Rainy_River'	=> 'Amerika/Rainy River',
		'America/Rankin_Inlet'	=> 'Amerika/Rankin Inlet',
		'America/Recife'		=> 'Amerika/Recife',
		'America/Regina'		=> 'Amerika/Regina',
		'America/Resolute'		=> 'Amerika/Resolute',
		'America/Rio_Branco'	=> 'Amerika/Rio Branco',
		'America/Santa_Isabel'	=> 'Amerika/Santa Isabel',
		'America/Santarem'		=> 'Amerika/Santarem',
		'America/Santiago'		=> 'Amerika/Santiago',
		'America/Santo_Domingo'	=> 'Amerika/Santo Domingo',
		'America/Sao_Paulo'		=> 'Amerika/Sao Paulo',
		'America/Scoresbysund'	=> 'Amerika/Scoresbysund',
		'America/Shiprock'		=> 'Amerika/Shiprock',
		'America/Sitka'			=> 'Amerika/Sitka',
		'America/St_Barthelemy'	=> 'Amerika/St. Barthelemy',
		'America/St_Johns'		=> 'Amerika/St. Johns',
		'America/St_Kitts'		=> 'Amerika/St. Kitts',
		'America/St_Lucia'		=> 'Amerika/St. Lucia',
		'America/St_Thomas'		=> 'Amerika/St. Thomas',
		'America/St_Vincent'	=> 'Amerika/St. Vincent',
		'America/Swift_Current'	=> 'Amerika/Swift Current',
		'America/Tegucigalpa'	=> 'Amerika/Tegucigalpa',
		'America/Thule'			=> 'Amerika/Thule',
		'America/Thunder_Bay'	=> 'Amerika/Thunder Bay',
		'America/Tijuana'		=> 'Amerika/Tijuana',
		'America/Toronto'		=> 'Amerika/Toronto',
		'America/Tortola'		=> 'Amerika/Tortola',
		'America/Vancouver'		=> 'Amerika/Vancouver',
		'America/Whitehorse'	=> 'Amerika/Whitehorse',
		'America/Winnipeg'		=> 'Amerika/Winnipeg',
		'America/Yakutat'		=> 'Amerika/Yakutat',
		'America/Yellowknife'	=> 'Amerika/Yellowknife',

		'Antarctica/Casey'		=> 'Antarktis/Casey',
		'Antarctica/Davis'		=> 'Antarktis/Davis',
		'Antarctica/DumontDUrville'	=> 'Antarktis/Dumont d\'Urville',
		'Antarctica/Macquarie'	=> 'Antarktis/Macquarie',
		'Antarctica/Mawson'		=> 'Antarktis/Mawson',
		'Antarctica/McMurdo'	=> 'Antarktis/McMurdo',
		'Antarctica/Palmer'		=> 'Antarktis/Palmer',
		'Antarctica/Rothera'	=> 'Antarktis/Rothera',
		'Antarctica/South_Pole'	=> 'Antarktis/Sydpolen',
		'Antarctica/Syowa'		=> 'Antarktis/Syowa',
		'Antarctica/Vostok'		=> 'Antarktis/Vostok',

		'Arctic/Longyearbyen'	=> 'Arktis/Longyearbyen',

		'Asia/Aden'			=> 'Asia/Aden',
		'Asia/Almaty'		=> 'Asia/Almaty',
		'Asia/Amman'		=> 'Asia/Amman',
		'Asia/Anadyr'		=> 'Asia/Anadyr',
		'Asia/Aqtau'		=> 'Asia/Aktau',
		'Asia/Aqtobe'		=> 'Asia/Aktobe',
		'Asia/Ashgabat'		=> 'Asia/Asjkhabad',
		'Asia/Baghdad'		=> 'Asia/Bagdad',
		'Asia/Bahrain'		=> 'Asia/Bahrain',
		'Asia/Baku'			=> 'Asia/Baku',
		'Asia/Bangkok'		=> 'Asia/Bangkok',
		'Asia/Beirut'		=> 'Asia/Beirut',
		'Asia/Bishkek'		=> 'Asia/Bisjkek',
		'Asia/Brunei'		=> 'Asia/Brunei',
		'Asia/Choibalsan'	=> 'Asia/Choibalsan',
		'Asia/Chongqing'	=> 'Asia/Chongqing',
		'Asia/Colombo'		=> 'Asia/Colombo',
		'Asia/Damascus'		=> 'Asia/Damaskus',
		'Asia/Dhaka'		=> 'Asia/Dhaka',
		'Asia/Dili'			=> 'Asia/Dili',
		'Asia/Dubai'		=> 'Asia/Dubai',
		'Asia/Dushanbe'		=> 'Asia/Dusjanbe',
		'Asia/Gaza'			=> 'Asia/Gaza',
		'Asia/Harbin'		=> 'Asia/Harbin',
		'Asia/Hebron'		=> 'Asia/Hebron',
		'Asia/Ho_Chi_Minh'	=> 'Asia/Hô Chí Minh',
		'Asia/Hong_Kong'	=> 'Asia/Hongkong',
		'Asia/Hovd'			=> 'Asia/Khovd',
		'Asia/Irkutsk'		=> 'Asia/Irkutsk',
		'Asia/Jakarta'		=> 'Asia/Jakarta',
		'Asia/Jayapura'		=> 'Asia/Jaya Pura',
		'Asia/Jerusalem'	=> 'Asia/Jerusalem',
		'Asia/Kabul'		=> 'Asia/Kabul',
		'Asia/Kamchatka'	=> 'Asia/Kamtsjatka',
		'Asia/Karachi'		=> 'Asia/Karachi',
		'Asia/Kashgar'		=> 'Asia/Kashgar',
		'Asia/Kathmandu'	=> 'Asia/Katmandu',
		'Asia/Khandyga'		=> 'Asia/Khandyga',
		'Asia/Kolkata'		=> 'Asia/Kolkata',
		'Asia/Krasnoyarsk'	=> 'Asia/Krasnojarsk',
		'Asia/Kuala_Lumpur'	=> 'Asia/Kuala Lumpur',
		'Asia/Kuching'		=> 'Asia/Kuching',
		'Asia/Kuwait'		=> 'Asia/Kuwait',
		'Asia/Macau'		=> 'Asia/Macao',
		'Asia/Magadan'		=> 'Asia/Magadan',
		'Asia/Makassar'		=> 'Asia/Makassar',
		'Asia/Manila'		=> 'Asia/Manila',
		'Asia/Muscat'		=> 'Asia/Muskat',
		'Asia/Nicosia'		=> 'Asia/Nikosia',
		'Asia/Novokuznetsk'	=> 'Asia/Novokuznetsk',
		'Asia/Novosibirsk'	=> 'Asia/Novosibirsk',
		'Asia/Omsk'			=> 'Asia/Omsk',
		'Asia/Oral'			=> 'Asia/Oral',
		'Asia/Phnom_Penh'	=> 'Asia/Phnom Penh',
		'Asia/Pontianak'	=> 'Asia/Pontianak',
		'Asia/Pyongyang'	=> 'Asia/Pyongyang',
		'Asia/Qatar'		=> 'Asia/Qatar',
		'Asia/Qyzylorda'	=> 'Asia/Kyzylorda',
		'Asia/Rangoon'		=> 'Asia/Yangôn',
		'Asia/Riyadh'		=> 'Asia/Riyadh',
		'Asia/Sakhalin'		=> 'Asia/Sakhalin',
		'Asia/Samarkand'	=> 'Asia/Samarkand',
		'Asia/Seoul'		=> 'Asia/Seoul',
		'Asia/Shanghai'		=> 'Asia/Shanghai',
		'Asia/Singapore'	=> 'Asia/Singapore',
		'Asia/Taipei'		=> 'Asia/Taipei',
		'Asia/Tashkent'		=> 'Asia/Tasjkent',
		'Asia/Tbilisi'		=> 'Asia/Tbilisi',
		'Asia/Tehran'		=> 'Asia/Teheran',
		'Asia/Thimphu'		=> 'Asia/Thimpu',
		'Asia/Tokyo'		=> 'Asia/Tokyo',
		'Asia/Ulaanbaatar'	=> 'Asia/Ulan Bator',
		'Asia/Urumqi'		=> 'Asia/Ürümqi',
		'Asia/Ust-Nera'		=> 'Asia/Ust-Nera',
		'Asia/Vientiane'	=> 'Asia/Vientiane',
		'Asia/Vladivostok'	=> 'Asia/Vladivostok',
		'Asia/Yakutsk'		=> 'Asia/Yakutsk',
		'Asia/Yekaterinburg'	=> 'Asia/Jekaterinburg',
		'Asia/Yerevan'		=> 'Asia/Jerevan',

		'Atlantic/Azores'		=> 'Atlanterhavet/Azorene',
		'Atlantic/Bermuda'		=> 'Atlanterhavet/Bermuda',
		'Atlantic/Canary'		=> 'Atlanterhavet/Kanariøyene',
		'Atlantic/Cape_Verde'	=> 'Atlanterhavet/Kapp Verde',
		'Atlantic/Faroe'		=> 'Atlanterhavet/Færøyene',
		'Atlantic/Madeira'		=> 'Atlanterhavet/Madeira',
		'Atlantic/Reykjavik'	=> 'Atlanterhavet/Reykjavik',
		'Atlantic/South_Georgia'	=> 'Atlanterhavet/South Georgia',
		'Atlantic/St_Helena'	=> 'Atlanterhavet/St. Helena',
		'Atlantic/Stanley'		=> 'Atlanterhavet/Stanley',

		'Australia/Adelaide'	=> 'Australia/Adelaide',
		'Australia/Brisbane'	=> 'Australia/Brisbane',
		'Australia/Broken_Hill'	=> 'Australia/Broken Hill',
		'Australia/Currie'		=> 'Australia/Currie',
		'Australia/Darwin'		=> 'Australia/Darwin',
		'Australia/Eucla'		=> 'Australia/Eucla',
		'Australia/Hobart'		=> 'Australia/Hobart',
		'Australia/Lindeman'	=> 'Australia/Lindeman',
		'Australia/Lord_Howe'	=> 'Australia/Lord Howe',
		'Australia/Melbourne'	=> 'Australia/Melbourne',
		'Australia/Perth'		=> 'Australia/Perth',
		'Australia/Sydney'		=> 'Australia/Sydney',

		'Europe/Amsterdam'	=> 'Europa/Amsterdam',
		'Europe/Andorra'	=> 'Europa/Andorra',
		'Europe/Athens'		=> 'Europa/Aten',
		'Europe/Belgrade'	=> 'Europa/Beograd',
		'Europe/Berlin'		=> 'Europa/Berlin',
		'Europe/Bratislava'	=> 'Europa/Bratislava',
		'Europe/Brussels'	=> 'Europa/Brüssel',
		'Europe/Bucharest'	=> 'Europa/Bucuresti',
		'Europe/Budapest'	=> 'Europa/Budapest',
		'Europe/Busingen'	=> 'Europa/Büsingen',
		'Europe/Chisinau'	=> 'Europa/Chisinau',
		'Europe/Copenhagen'	=> 'Europa/København',
		'Europe/Dublin'		=> 'Europa/Dublin',
		'Europe/Gibraltar'	=> 'Europa/Gibraltar',
		'Europe/Guernsey'	=> 'Europa/Guernsey',
		'Europe/Helsinki'	=> 'Europa/Helsinki',
		'Europe/Isle_of_Man'	=> 'Europa/Isle of Man',
		'Europe/Istanbul'	=> 'Europa/Istanbul',
		'Europe/Jersey'		=> 'Europa/Jersey',
		'Europe/Kaliningrad'	=> 'Europa/Kaliningrad',
		'Europe/Kiev'		=> 'Europa/Kiev',
		'Europe/Lisbon'		=> 'Europa/Lisboa',
		'Europe/Ljubljana'	=> 'Europa/Ljubljana',
		'Europe/London'		=> 'Europa/London',
		'Europe/Luxembourg'	=> 'Europa/Luxemburg',
		'Europe/Madrid'		=> 'Europa/Madrid',
		'Europe/Malta'		=> 'Europa/Malta',
		'Europe/Mariehamn'	=> 'Europa/Mariehamn',
		'Europe/Minsk'		=> 'Europa/Minsk',
		'Europe/Monaco'		=> 'Europa/Monaco',
		'Europe/Moscow'		=> 'Europa/Moskva',
		'Europe/Oslo'		=> 'Europa/Oslo',
		'Europe/Paris'		=> 'Europa/Paris',
		'Europe/Podgorica'	=> 'Europa/Podgorica',
		'Europe/Prague'		=> 'Europa/Praha',
		'Europe/Riga'		=> 'Europa/Riga',
		'Europe/Rome'		=> 'Europa/Roma',
		'Europe/Samara'		=> 'Europa/Samara',
		'Europe/San_Marino'	=> 'Europa/San Marino',
		'Europe/Sarajevo'	=> 'Europa/Sarajevo',
		'Europe/Simferopol'	=> 'Europa/Simferopol',
		'Europe/Skopje'		=> 'Europa/Skopje',
		'Europe/Sofia'		=> 'Europa/Sofia',
		'Europe/Stockholm'	=> 'Europa/Stockholm',
		'Europe/Tallinn'	=> 'Europa/Tallinn',
		'Europe/Tirane'		=> 'Europa/Tirana',
		'Europe/Uzhgorod'	=> 'Europa/Uzjhorod',
		'Europe/Vaduz'		=> 'Europa/Vaduz',
		'Europe/Vatican'	=> 'Europa/Vatikanstaten',
		'Europe/Vienna'		=> 'Europa/Wien',
		'Europe/Vilnius'	=> 'Europa/Vilnius',
		'Europe/Volgograd'	=> 'Europa/Volgograd',
		'Europe/Warsaw'		=> 'Europa/Warszawa',
		'Europe/Zagreb'		=> 'Europa/Zagreb',
		'Europe/Zaporozhye'	=> 'Europa/Zaporizjzja',
		'Europe/Zurich'		=> 'Europa/Zürich',

		'Indian/Antananarivo'	=> 'Indiahavet/Antananarivo',
		'Indian/Chagos'		=> 'Indiahavet/Chagos',
		'Indian/Christmas'	=> 'Indiahavet/Christmas',
		'Indian/Cocos'		=> 'Indiahavet/Cocos',
		'Indian/Comoro'		=> 'Indiahavet/Comoro',
		'Indian/Kerguelen'	=> 'Indiahavet/Kerguelen',
		'Indian/Mahe'		=> 'Indiahavet/Mahe',
		'Indian/Maldives'	=> 'Indiahavet/Maldives',
		'Indian/Mauritius'	=> 'Indiahavet/Mauritius',
		'Indian/Mayotte'	=> 'Indiahavet/Mayotte',
		'Indian/Reunion'	=> 'Indiahavet/Reunion',

		'Pacific/Apia'		=> 'Stillehavet/Apia',
		'Pacific/Auckland'	=> 'Stillehavet/Auckland',
		'Pacific/Chatham'	=> 'Stillehavet/Chatham',
		'Pacific/Chuuk'		=> 'Stillehavet/Chuuk',
		'Pacific/Easter'	=> 'Stillehavet/Easter',
		'Pacific/Efate'		=> 'Stillehavet/Efate',
		'Pacific/Enderbury'	=> 'Stillehavet/Enderbury',
		'Pacific/Fakaofo'	=> 'Stillehavet/Fakaofo',
		'Pacific/Fiji'		=> 'Stillehavet/Fiji',
		'Pacific/Funafuti'	=> 'Stillehavet/Funafuti',
		'Pacific/Galapagos'	=> 'Stillehavet/Galapagos',
		'Pacific/Gambier'	=> 'Stillehavet/Gambier',
		'Pacific/Guadalcanal'	=> 'Stillehavet/Guadalcanal',
		'Pacific/Guam'		=> 'Stillehavet/Guam',
		'Pacific/Honolulu'	=> 'Stillehavet/Honolulu',
		'Pacific/Johnston'	=> 'Stillehavet/Johnston',
		'Pacific/Kiritimati'	=> 'Stillehavet/Kiritimati',
		'Pacific/Kosrae'	=> 'Stillehavet/Kosrae',
		'Pacific/Kwajalein'	=> 'Stillehavet/Kwajalein',
		'Pacific/Majuro'	=> 'Stillehavet/Majuro',
		'Pacific/Marquesas'	=> 'Stillehavet/Marquesas',
		'Pacific/Midway'	=> 'Stillehavet/Midway',
		'Pacific/Nauru'		=> 'Stillehavet/Nauru',
		'Pacific/Niue'		=> 'Stillehavet/Niue',
		'Pacific/Norfolk'	=> 'Stillehavet/Norfolk',
		'Pacific/Noumea'	=> 'Stillehavet/Noumea',
		'Pacific/Pago_Pago'	=> 'Stillehavet/Pago Pago',
		'Pacific/Palau'		=> 'Stillehavet/Palau',
		'Pacific/Pitcairn'	=> 'Stillehavet/Pitcairn',
		'Pacific/Pohnpei'	=> 'Stillehavet/Pohnpei',
		'Pacific/Port_Moresby'	=> 'Stillehavet/Port Moresby',
		'Pacific/Rarotonga'	=> 'Stillehavet/Rarotonga',
		'Pacific/Saipan'	=> 'Stillehavet/Saipan',
		'Pacific/Tahiti'	=> 'Stillehavet/Tahiti',
		'Pacific/Tarawa'	=> 'Stillehavet/Tarawa',
		'Pacific/Tongatapu'	=> 'Stillehavet/Tongatapu',
		'Pacific/Wake'		=> 'Stillehavet/Wake',
		'Pacific/Wallis'	=> 'Stillehavet/Wallis',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'j. F Y \k\l\. G.i'     => '1. januar 2007 kl. 13.37',
        'd.m.Y G:i'             => '01.01.2007 13:37',
        'd M Y, H:i'			=> '01 Jan 2007, 13:37',
		'd M Y H:i'				=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'		=> 'Jan 1st, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Mon Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'January 1st, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Today, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Today, 1:37 pm / January 1st, 2007, 1:37 pm',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'l j. F Y \k\l\. G.i', // mandag 1. januar 2007 kl. 13.37

));
