IF ("${CMAKE_MAJOR_VERSION}.${CMAKE_MINOR_VERSION}.${CMAKE_PATCH_VERSION}" VERSION_LESS "2.8.7")
  FUNCTION(MESSAGE_ONCE id out)
    MESSAGE(STATUS "${out}")
  ENDFUNCTION()
ELSE()
  FUNCTION(MESSAGE_ONCE id out)
    STRING(MD5 hash "${out}")
    IF(NOT __msg1_${id} STREQUAL "${hash}")
      MESSAGE(STATUS "${out}")
    ENDIF()
    SET(__msg1_${id} ${hash} CACHE INTERNAL "")
  ENDFUNCTION()
ENDIF()

MACRO(SET_IF_UNSET VAR VAL)
  IF(NOT DEFINED ${VAR})
    SET(${VAR} ${VAL})
  ENDIF()
ENDMACRO()
