/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version = 0;
    private boolean needStackingForCommitRollbackPrepare = false;
    private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
    private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
    private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
    private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
    private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
    private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
    private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
    private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
    private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
    private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
    private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
    private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";
    boolean isTransLoose = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        super(connection, oracleXAConnection);
        try {
            this.m_version = ((OracleConnection)connection).getVersionNumber();
            this.needStackingForCommitRollbackPrepare = this.m_version < 9000;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.m_version < 8170) {
            throw new XAException(-6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Xid xid, int n2) throws XAException {
        Connection connection = this.connection;
        synchronized (connection) {
            int n3 = -1;
            try {
                if (xid == null) {
                    throw new XAException(-5);
                }
                int n4 = n2 & 0xFF00;
                int n5 = (n2 &= 0xFFFF00FF) & 0x10000 | (this.isTransLoose ? 65536 : 0);
                if (((n2 &= 0xFFFEFFFF) & 0x8200002) != n2 || n5 != 0 && (n5 & 0x10000) != 65536) {
                    throw new XAException(-5);
                }
                if ((n4 & 0xFF00) != 0 && n4 != 256 && n4 != 512 && n4 != 1024) {
                    throw new XAException(-5);
                }
                if ((n2 & 0x8200000) != 0 && ((n4 & 0xFF00) != 0 || (n5 & 0x10000) != 0)) {
                    throw new XAException(-5);
                }
                n2 |= n4 | n5;
                this.saveAndAlterAutoCommitModeForGlobalTransaction();
                try {
                    n3 = this.doStart(xid, n2);
                }
                catch (SQLException sQLException) {
                    this.checkError(sQLException, -3);
                }
                this.checkError(n3);
                boolean[] blArray = new boolean[]{false};
                super.createOrUpdateXid(xid, false, blArray);
            }
            catch (XAException xAException) {
                this.restoreAutoCommitModeForGlobalTransaction();
                throw xAException;
            }
        }
    }

    protected int doStart(Xid xid, int n2) throws XAException, SQLException {
        int n3 = -1;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_start_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.setInt(5, this.timeout);
            callableStatement.setInt(6, n2);
            callableStatement.execute();
            n3 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                throw new XAException(-6);
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int n2) throws XAException {
        Connection connection = this.connection;
        synchronized (connection) {
            int n3 = -1;
            boolean bl = false;
            boolean bl2 = false;
            try {
                if (xid == null) {
                    throw new XAException(-5);
                }
                int n4 = 638582786;
                if ((n2 & n4) != n2) {
                    throw new XAException(-5);
                }
                Xid xid2 = null;
                bl = (n2 & 0x4000000) != 0;
                boolean bl3 = bl2 = (n2 & 0x20000000) != 0;
                if (bl || bl2) {
                    xid2 = super.suspendStacked(xid);
                }
                try {
                    boolean bl4 = false;
                    if (bl || bl2) {
                        bl4 = this.isXidSuspended(xid);
                        if (bl4) {
                            super.resumeStacked(xid);
                        }
                        this.removeXidFromList(xid);
                    } else if (n2 == 0x2000000) {
                        boolean[] blArray = new boolean[]{false};
                        super.createOrUpdateXid(xid, true, blArray);
                        bl4 = blArray[0];
                    }
                    n3 = this.doEnd(xid, n2, bl4);
                }
                catch (SQLException sQLException) {
                    this.checkError(sQLException, -3);
                }
                if (xid2 != null) {
                    super.resumeStacked(xid2);
                } else if (this.isXidListEmpty()) {
                    this.exitGlobalTxnMode();
                    this.activeXid = null;
                }
                this.checkError(n3);
                if (bl && n2 != 0x4000000 || bl2 && n2 != 0x20000000) {
                    throw new XAException(-5);
                }
            }
            finally {
                this.restoreAutoCommitModeForGlobalTransaction();
            }
        }
    }

    protected int doEnd(Xid xid, int n2, boolean bl) throws XAException, SQLException {
        CallableStatement callableStatement = null;
        int n3 = -1;
        try {
            callableStatement = this.connection.prepareCall(xa_end_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.setInt(5, n2);
            callableStatement.execute();
            n3 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                throw new XAException(-6);
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        Connection connection = this.connection;
        synchronized (connection) {
            if (xid == null) {
                throw new XAException(-5);
            }
            Xid xid2 = null;
            if (this.needStackingForCommitRollbackPrepare) {
                xid2 = super.suspendStacked(xid);
            } else {
                this.removeXidFromList(xid);
                if (this.activeXid == null) {
                    this.exitGlobalTxnMode();
                }
            }
            try {
                try {
                    this.doCommit(xid, bl);
                }
                catch (SQLException sQLException) {
                    this.checkError(sQLException, -3);
                }
            }
            catch (XAException xAException) {
                if (xAException.errorCode == -7) {
                    try {
                        this.connection.close();
                    }
                    catch (SQLException sQLException) {}
                } else if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(xid2);
                }
                throw xAException;
            }
            if (this.needStackingForCommitRollbackPrepare) {
                super.resumeStacked(xid2);
            }
        }
    }

    protected void doCommit(Xid xid, boolean bl) throws XAException, SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_commit_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.setInt(5, bl ? 1 : 0);
            callableStatement.execute();
            int n2 = callableStatement.getInt(1);
            this.checkError(n2, -7);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                throw new XAException(-6);
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare(Xid xid) throws XAException {
        Connection connection = this.connection;
        synchronized (connection) {
            int n2 = 0;
            if (xid == null) {
                throw new XAException(-5);
            }
            Xid xid2 = null;
            if (this.needStackingForCommitRollbackPrepare) {
                xid2 = super.suspendStacked(xid);
            }
            try {
                try {
                    n2 = this.doPrepare(xid);
                    if (n2 != 0 && n2 != 3) {
                        int n3 = OracleXAException.errorConvert(n2);
                        if (n3 != 0 && n3 != 3) {
                            XAException xAException = OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), n2);
                            xAException.fillInStackTrace();
                            throw xAException;
                        }
                        n2 = n3;
                    }
                }
                catch (SQLException sQLException) {
                    this.checkError(sQLException, -3);
                }
            }
            catch (XAException xAException) {
                if (xAException.errorCode == -7) {
                    try {
                        this.connection.close();
                    }
                    catch (SQLException sQLException) {}
                } else if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(xid2);
                }
                throw xAException;
            }
            if (this.needStackingForCommitRollbackPrepare) {
                super.resumeStacked(xid2);
            }
            return n2;
        }
    }

    protected int doPrepare(Xid xid) throws XAException, SQLException {
        int n2 = 0;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_prepare_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.execute();
            n2 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                throw new XAException(-6);
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(Xid xid) throws XAException {
        Connection connection = this.connection;
        synchronized (connection) {
            int n2 = 0;
            if (xid == null) {
                throw new XAException(-5);
            }
            this.removeXidFromList(xid);
            try {
                n2 = this.doForget(xid);
            }
            catch (SQLException sQLException) {
                this.checkError(sQLException, -3);
            }
            this.checkError(n2);
        }
    }

    protected int doForget(Xid xid) throws XAException, SQLException {
        int n2 = 0;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_forget_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.execute();
            n2 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n2 = sQLException.getErrorCode();
            if (n2 == 0) {
                throw new XAException(-6);
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        Connection connection = this.connection;
        synchronized (connection) {
            int n2 = 0;
            if (xid == null) {
                throw new XAException(-5);
            }
            Xid xid2 = null;
            if (this.needStackingForCommitRollbackPrepare) {
                xid2 = super.suspendStacked(xid);
            } else {
                this.removeXidFromList(xid);
                if (this.activeXid == null) {
                    this.exitGlobalTxnMode();
                }
            }
            try {
                this.doRollback(xid);
            }
            catch (SQLException sQLException) {
                this.checkError(sQLException, -3);
            }
            if (this.needStackingForCommitRollbackPrepare) {
                super.resumeStacked(xid2);
            }
            this.checkError(n2);
        }
    }

    protected void doRollback(Xid xid) throws XAException, SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_rollback_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.execute();
            int n2 = callableStatement.getInt(1);
            this.checkError(n2, -7);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                throw new XAException(-6);
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTwoPhaseAction(int n2, int n3, String[] stringArray, Xid[] xidArray) throws XAException {
        Connection connection = this.connection;
        synchronized (connection) {
            this.doDoTwoPhaseAction(n2, n3, stringArray, xidArray);
        }
    }

    protected int doDoTwoPhaseAction(int n2, int n3, String[] stringArray, Xid[] xidArray) throws XAException {
        throw new XAException(-6);
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

