# Global Principal Key configuration

You can configure a default principal key using a global key provider. This key is used by all databases that do not have their own encryption keys configured.

There are two main functions for this:

- [pg_tde_create_key_using_global_key_provider()](../functions.md#pg_tde_create_key_using_global_key_provider) creates a principal key at a global key provider
- [pg_tde_set_default_key_using_global_key_provider()](../functions.md#pg_tde_set_default_key_using_global_key_provider) sets the default principal key and rotates the internal encryption key if one is already configured

## Create a default principal key

!!! note

    The sample output below is for demonstration purposes only. Be sure to replace the key name and provider with your actual values.

To create a global principal key, run:

```sql
SELECT pg_tde_create_key_using_global_key_provider(
    'key-name',
    'global_vault_provider'
);
```

??? example "Sample output"
    ```sql
        postgres=# SELECT pg_tde_create_key_using_global_key_provider(
            'keytest1',
            'file-keyring'
        );
        pg_tde_create_key_using_global_key_provider
        ---------------------------------------------

        (1 row)
    ```

## Configure a default principal key

To configure a global principal key, run:

```sql
SELECT pg_tde_set_default_key_using_global_key_provider(
    'key-name',
    'global_vault_provider'
);
```

??? example "Sample output"
    ```sql
        postgres=# SELECT pg_tde_set_default_key_using_global_key_provider(
            'keytest1',
            'file-keyring'
        );
        pg_tde_set_default_key_using_global_key_provider 
        --------------------------------------------------

        (1 row)
    ```

## Parameter description

* `key-name` is the name under which the principal key is stored in the provider.
* `global_vault_provider` is the name of the global key provider you previously configured.

!!! note

    If no error is reported, the action completed successfully.

## How key generation works

The key material (actual cryptographic key) is auto-generated by `pg_tde` and stored securely by the configured provider.

!!! note

    This process sets the **default principal key for the entire server**. Any database without a key explicitly configured will fall back to this key.

## Next steps

To confirm that encryption is working as expected, follow the validation steps:

[Validate Encryption with pg_tde :material-arrow-right:](../test.md){.md-button}
