# Improved Log statements

**Percona XtraBackup** is an open-source command-line utility. Command-line
tools have limited interaction with the background operations and the logs
provide the progress of an operation or more information about errors.

In earlier versions, the error logs did not have a standard structure.
Notice in the following examples the variance in the log statements:

* The backup log statement header has the name of the module, `xtrabackup`,
  which generated the statement but no timestamp:

```
 xtrabackup: recognized client arguments: --parallel=4 --target-dir=/data/backups/ --backup=1

./bin/xtrabackup version 8.0.27-19 based on MySQL server 8.0.27 Linux (x86_64) (revision id: b0f75188ca3)
```

* The copy-back log statement has a timestamp but no module name. The
  timestamp is a mix of UTC and the local timezone.

```
220322 19:05:13 [01] Copying undo_001 to /data/backups/undo_001
```

* The following prepare log statements do not have header information,
  which makes diagnosing an issue more difficult.

```
Completed space ID check of 1008 files.
Initializing buffer pool, total size = 128.000000M, instances = 1, chunk size =128.000000M
Completed initialization of buffer pool
If the mysqld execution user is authorized, page cleaner thread priority can be changed. See the man page of setpriority().
```

## Log statement structure

Starting in **Percona XtraBackup** 8.0.28-20, changes have been made to
improve the log statements. The improved log structure is displayed in the
backup, prepare, move-back/copy-back error logs.

Each log statement has the following attributes:

* **Timestamp** - a timestamp for when the event occurred in a UTC format.


* **Severity** - the severity level of a statement indicates the importance
  of an event.


* **ID** - this identifier is currently not used but may be used in future
  versions.


* **Context** - the name of the module that issued the log statement, such
  as **XtraBackup**, **InnoDB**, or **Server**.


* **Message** - a description of the event generated by the module.

An example of a `prepare` log that is generated with the improved structure.
The
uniformity of the headers makes it easier to follow an operation’s progress
or review the log to diagnose issues.

```
2022-03-22T19:15:36.142247+05:30 0 [Note] [MY-011825] [Xtrabackup] This target seems to be not prepared yet.
2022-03-22T19:15:36.142792+05:30 0 [Note] [MY-013251] [InnoDB] Number of pools: 1
2022-03-22T19:15:36.149212+05:30 0 [Note] [MY-011825] [Xtrabackup] xtrabackup_logfile detected: size=8388608, start_lsn=(33311656)
2022-03-22T19:15:36.149998+05:30 0 [Note] [MY-011825] [Xtrabackup] using the following InnoDB configuration for recovery:
2022-03-22T19:15:36.150023+05:30 0 [Note] [MY-011825] [Xtrabackup] innodb_data_home_dir = .
2022-03-22T19:15:36.150036+05:30 0 [Note] [MY-011825] [Xtrabackup] innodb_data_file_path = ibdata1:12M:autoextend
2022-03-22T19:15:36.150078+05:30 0 [Note] [MY-011825] [Xtrabackup] innodb_log_group_home_dir = .
2022-03-22T19:15:36.150095+05:30 0 [Note] [MY-011825] [Xtrabackup] innodb_log_files_in_group = 1
2022-03-22T19:15:36.150111+05:30 0 [Note] [MY-011825] [Xtrabackup] innodb_log_file_size = 8388608
2022-03-22T19:15:36.151667+05:30 0 [Note] [MY-011825] [Xtrabackup] inititialize_service_handles suceeded
2022-03-22T19:15:36.151903+05:30 0 [Note] [MY-011825] [Xtrabackup] using the following InnoDB configuration for recovery:
2022-03-22T19:15:36.151926+05:30 0 [Note] [MY-011825] [Xtrabackup] innodb_data_home_dir = .
2022-03-22T19:15:36.151954+05:30 0 [Note] [MY-011825] [Xtrabackup] innodb_data_file_path = ibdata1:12M:autoextend
2022-03-22T19:15:36.151976+05:30 0 [Note] [MY-011825] [Xtrabackup] innodb_log_group_home_dir = .
2022-03-22T19:15:36.151991+05:30 0 [Note] [MY-011825] [Xtrabackup] innodb_log_files_in_group = 1
2022-03-22T19:15:36.152004+05:30 0 [Note] [MY-011825] [Xtrabackup] innodb_log_file_size = 8388608
2022-03-22T19:15:36.152021+05:30 0 [Note] [MY-011825] [Xtrabackup] Starting InnoDB instance for recovery.
2022-03-22T19:15:36.152035+05:30 0 [Note] [MY-011825] [Xtrabackup] Using 104857600 bytes for buffer pool (set by --use-memory parameter)
```
