-- topology:
--
-- x x x x x
-- ^dc
--   ^ 1st tier server id
--     ^ 2nd tier server id
--       ^ 3rd tier server id

-- 55555
-- + 11000     (dc1) (lag=7)   <--
--   + 11100         (lag=8)   <--
--   + 11200         (lag=8)   <--
--   + 11300         (lag=7)
-- + 21000     (dc2) (lag=0)   <--
--   + 21100         (lag=1)   <--
-- + 22000     (dc2) (lag=0)
--   + 22100         (lag=10)
-- + 23000     (dc2) (lag=0)   <--
--   + 23100         (lag=9)   <--
--   + 23200         (lag=8)   <--
-- + 31000     (dc3) (lag=2)
-- + 32000     (dc3) (lag=2)   <--
--   + 32100         (lag=5)   <--
--     + 32110       (lag=5)   <--
--   + 32200         (lag=4)   <--
--     + 32210       (lag=4)
--     + 32220       (lag=4)
--     + 32230       (lag=7)   <--
-- + 33000     (dc3) (lag=3)   <--
--

-- drop the default configuration
DELETE FROM database_instance;

-- create the topology as shown above
-- add servers
-- 55555
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',55555,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,55555,'00022293-0000-0000-0000-000000055555','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',22294,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,7,'[{"Hostname":"testhost","Port":11000},{"Hostname":"testhost","Port":21000},{"Hostname":"testhost","Port":22000},{"Hostname":"testhost","Port":23000},{"Hostname":"testhost","Port":31000},{"Hostname":"testhost","Port":32000},{"Hostname":"testhost","Port":33000}]','testhost:55555','','ny','us-region','','',0,0,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 11000
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',11000,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,11000,'00022293-0000-0000-0000-000000011000','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',55555,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,3,'[{"Hostname":"testhost","Port":11100},{"Hostname":"testhost","Port":11200},{"Hostname":"testhost","Port":11300}]','testhost:55555','','dc1','us-region','','',0,1,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 11100
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',11100,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000011100','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',11000,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,0,'[]','testhost:55555','','dc1','us-region','','',0,2,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 11200
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',11200,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000011200','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',11000,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,0,'[]','testhost:55555','','dc1','us-region','','',0,2,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 11300
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',11300,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000011300','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',11000,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,0,'[]','testhost:55555','','dc1','us-region','','',0,2,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 21000
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',21000,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000021000','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',55555,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,1,'[{"Hostname":"testhost","Port":21100}]','testhost:55555','','dc2','us-region','','',0,1,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 21100
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',21100,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000021100','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',21000,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,0,'[]','testhost:55555','','dc2','us-region','','',0,2,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 22000
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',22000,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000022000','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',55555,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,1,'[{"Hostname":"testhost","Port":22100}]','testhost:55555','','dc2','us-region','','',0,1,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 22100
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',22100,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000022100','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',22000,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,0,'[]','testhost:55555','','dc2','us-region','','',0,2,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 23000
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',23000,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000023000','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',55555,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,2,'[{"Hostname":"testhost","Port":23100},{"Hostname":"testhost","Port":23200}]','testhost:55555','','dc2','us-region','','',0,1,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 23100
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',23100,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000023100','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',23000,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,0,'[]','testhost:55555','','dc2','us-region','','',0,2,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 23200
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',23200,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000023200','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',23000,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,0,'[]','testhost:55555','','dc2','us-region','','',0,2,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 31000
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',31000,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000031000','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',55555,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,0,'[]','testhost:55555','','dc3','us-region','','',0,1,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');


-- 32000
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',32000,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000032000','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',55555,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,2,'[{"Hostname":"testhost","Port":32100},{"Hostname":"testhost","Port":32200}]','testhost:55555','','dc3','us-region','','',0,1,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 32100
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',32100,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000033100','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',32000,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,1,'[{"Hostname":"testhost","Port":32110}]','testhost:55555','','dc3','us-region','','',0,2,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 32110
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',32110,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000032110','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',32100,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,0,'[]','testhost:55555','','dc3','us-region','','',0,3,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 32200
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',32200,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000032200','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',32000,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,3,'[{"Hostname":"testhost","Port":32210},{"Hostname":"testhost","Port":32220},{"Hostname":"testhost","Port":32230}]','testhost:55555','','dc3','us-region','','',0,2,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 32210
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',32210,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000032210','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',32200,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,0,'[]','testhost:55555','','dc3','us-region','','',0,3,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 32220
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',32220,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000032220','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',32200,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,0,'[]','testhost:55555','','dc3','us-region','','',0,3,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 32230
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',32230,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000032230','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',32200,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,0,'[]','testhost:55555','','dc3','us-region','','',0,3,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- 33000
INSERT INTO database_instance (hostname, port, last_checked, last_attempted_check, last_seen, uptime, server_id, server_uuid, version, binlog_server, read_only, binlog_format, log_bin, log_slave_updates, binary_log_file, binary_log_pos, master_host, master_port, slave_sql_running, slave_io_running, has_replication_filters, oracle_gtid, master_uuid, ancestry_uuid, executed_gtid_set, gtid_purged, gtid_errant, supports_oracle_gtid, mariadb_gtid, pseudo_gtid, master_log_file, read_master_log_pos, relay_master_log_file, exec_master_log_pos, relay_log_file, relay_log_pos, last_sql_error, last_io_error, seconds_behind_master, slave_lag_seconds, sql_delay, allow_tls, num_slave_hosts, slave_hosts, cluster_name, suggested_cluster_alias, data_center, region, physical_environment, instance_alias, semi_sync_enforced, replication_depth, is_co_master, replication_credentials_available, has_replication_credentials, version_comment, major_version, last_check_partial_success, binlog_row_image, last_discovery_latency, semi_sync_master_enabled, semi_sync_replica_enabled, gtid_mode, replication_group_members) VALUES ('testhost',33000,'2017-02-02 08:29:57','2017-02-02 08:29:57','2017-02-02 08:29:57',670442,102,'00022293-0000-0000-0000-000000033000','5.6.28-log',0,0,'STATEMENT',1,1,'mysql-bin.000129',136688950,'testhost',55555,1,1,0,0,'','','','','',0,0,1,'mysql-bin.000132',15931747,'mysql-bin.000132',15931747,'mysql-relay.000002',15868528,'\"\"','\"\"',0,0,0,0,0,'[]','testhost:55555','','dc3','us-region','','',0,1,0,0,1,'MySQL Community Server (GPL)','5.6',0,'full',0,0,0,'OFF', '[]');

-- setup lag
UPDATE database_instance SET slave_lag_seconds=7  where port = 11000;
UPDATE database_instance SET slave_lag_seconds=8  where port = 11100;
UPDATE database_instance SET slave_lag_seconds=8  where port = 11200;
UPDATE database_instance SET slave_lag_seconds=7  where port = 11300;

UPDATE database_instance SET slave_lag_seconds=0  where port = 21000;
UPDATE database_instance SET slave_lag_seconds=1  where port = 21100;
UPDATE database_instance SET slave_lag_seconds=0  where port = 22000;
UPDATE database_instance SET slave_lag_seconds=10 where port = 22100;
UPDATE database_instance SET slave_lag_seconds=0  where port = 23000;
UPDATE database_instance SET slave_lag_seconds=9  where port = 23100;
UPDATE database_instance SET slave_lag_seconds=8  where port = 23200;

UPDATE database_instance SET slave_lag_seconds=2 where port = 31000;
UPDATE database_instance SET slave_lag_seconds=2 where port = 32000;
UPDATE database_instance SET slave_lag_seconds=5 where port = 32100;
UPDATE database_instance SET slave_lag_seconds=5 where port = 32110;
UPDATE database_instance SET slave_lag_seconds=4 where port = 32200;
UPDATE database_instance SET slave_lag_seconds=4 where port = 32210;
UPDATE database_instance SET slave_lag_seconds=4 where port = 32220;
UPDATE database_instance SET slave_lag_seconds=7 where port = 32230;
UPDATE database_instance SET slave_lag_seconds=3 where port = 33000;

