--------------------------------------------------------------------------------
-- 
-- CTU CAN FD IP Core 
-- Copyright (C) 2021-present Ondrej Ille
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to use, copy, modify, merge, publish, distribute the Component for
-- educational, research, evaluation, self-interest purposes. Using the
-- Component for commercial purposes is forbidden unless previously agreed with
-- Copyright holder.
-- 
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
-- 
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
-- 
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
-- 
-- -------------------------------------------------------------------------------
-- 
-- CTU CAN FD IP Core 
-- Copyright (C) 2015-2020 MIT License
-- 
-- Authors:
--     Ondrej Ille <ondrej.ille@gmail.com>
--     Martin Jerabek <martin.jerabek01@gmail.com>
-- 
-- Project advisors: 
-- 	Jiri Novak <jnovak@fel.cvut.cz>
-- 	Pavel Pisa <pisa@cmp.felk.cvut.cz>
-- 
-- Department of Measurement         (http://meas.fel.cvut.cz/)
-- Faculty of Electrical Engineering (http://www.fel.cvut.cz)
-- Czech Technical University        (http://www.cvut.cz/)
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to deal in the Component without restriction, including without limitation
-- the rights to use, copy, modify, merge, publish, distribute, sublicense,
-- and/or sell copies of the Component, and to permit persons to whom the
-- Component is furnished to do so, subject to the following conditions:
-- 
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
-- 
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
-- 
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
-- 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Memory map for: CAN_Registers
-- This file is autogenerated, DO NOT EDIT!
--------------------------------------------------------------------------------

Library ieee;
use ieee.std_logic_1164.all;

package can_fd_register_map is

  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  -- Address block: Control_registers
  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  constant CONTROL_REGISTERS_BLOCK      : std_logic_vector(3 downto 0) := x"0";

  constant DEVICE_ID_ADR             : std_logic_vector(11 downto 0) := x"000";
  constant VERSION_ADR               : std_logic_vector(11 downto 0) := x"002";
  constant MODE_ADR                  : std_logic_vector(11 downto 0) := x"004";
  constant SETTINGS_ADR              : std_logic_vector(11 downto 0) := x"006";
  constant STATUS_ADR                : std_logic_vector(11 downto 0) := x"008";
  constant COMMAND_ADR               : std_logic_vector(11 downto 0) := x"00C";
  constant INT_STAT_ADR              : std_logic_vector(11 downto 0) := x"010";
  constant INT_ENA_SET_ADR           : std_logic_vector(11 downto 0) := x"014";
  constant INT_ENA_CLR_ADR           : std_logic_vector(11 downto 0) := x"018";
  constant INT_MASK_SET_ADR          : std_logic_vector(11 downto 0) := x"01C";
  constant INT_MASK_CLR_ADR          : std_logic_vector(11 downto 0) := x"020";
  constant BTR_ADR                   : std_logic_vector(11 downto 0) := x"024";
  constant BTR_FD_ADR                : std_logic_vector(11 downto 0) := x"028";
  constant EWL_ADR                   : std_logic_vector(11 downto 0) := x"02C";
  constant ERP_ADR                   : std_logic_vector(11 downto 0) := x"02D";
  constant FAULT_STATE_ADR           : std_logic_vector(11 downto 0) := x"02E";
  constant REC_ADR                   : std_logic_vector(11 downto 0) := x"030";
  constant TEC_ADR                   : std_logic_vector(11 downto 0) := x"032";
  constant ERR_NORM_ADR              : std_logic_vector(11 downto 0) := x"034";
  constant ERR_FD_ADR                : std_logic_vector(11 downto 0) := x"036";
  constant CTR_PRES_ADR              : std_logic_vector(11 downto 0) := x"038";
  constant FILTER_A_MASK_ADR         : std_logic_vector(11 downto 0) := x"03C";
  constant FILTER_A_VAL_ADR          : std_logic_vector(11 downto 0) := x"040";
  constant FILTER_B_MASK_ADR         : std_logic_vector(11 downto 0) := x"044";
  constant FILTER_B_VAL_ADR          : std_logic_vector(11 downto 0) := x"048";
  constant FILTER_C_MASK_ADR         : std_logic_vector(11 downto 0) := x"04C";
  constant FILTER_C_VAL_ADR          : std_logic_vector(11 downto 0) := x"050";
  constant FILTER_RAN_LOW_ADR        : std_logic_vector(11 downto 0) := x"054";
  constant FILTER_RAN_HIGH_ADR       : std_logic_vector(11 downto 0) := x"058";
  constant FILTER_CONTROL_ADR        : std_logic_vector(11 downto 0) := x"05C";
  constant FILTER_STATUS_ADR         : std_logic_vector(11 downto 0) := x"05E";
  constant RX_MEM_INFO_ADR           : std_logic_vector(11 downto 0) := x"060";
  constant RX_POINTERS_ADR           : std_logic_vector(11 downto 0) := x"064";
  constant RX_STATUS_ADR             : std_logic_vector(11 downto 0) := x"068";
  constant RX_SETTINGS_ADR           : std_logic_vector(11 downto 0) := x"06A";
  constant RX_DATA_ADR               : std_logic_vector(11 downto 0) := x"06C";
  constant TX_STATUS_ADR             : std_logic_vector(11 downto 0) := x"070";
  constant TX_COMMAND_ADR            : std_logic_vector(11 downto 0) := x"074";
  constant TXTB_INFO_ADR             : std_logic_vector(11 downto 0) := x"076";
  constant TX_PRIORITY_ADR           : std_logic_vector(11 downto 0) := x"078";
  constant ERR_CAPT_ADR              : std_logic_vector(11 downto 0) := x"07C";
  constant RETR_CTR_ADR              : std_logic_vector(11 downto 0) := x"07D";
  constant ALC_ADR                   : std_logic_vector(11 downto 0) := x"07E";
  constant TS_INFO_ADR               : std_logic_vector(11 downto 0) := x"07F";
  constant TRV_DELAY_ADR             : std_logic_vector(11 downto 0) := x"080";
  constant SSP_CFG_ADR               : std_logic_vector(11 downto 0) := x"082";
  constant RX_FR_CTR_ADR             : std_logic_vector(11 downto 0) := x"084";
  constant TX_FR_CTR_ADR             : std_logic_vector(11 downto 0) := x"088";
  constant DEBUG_REGISTER_ADR        : std_logic_vector(11 downto 0) := x"08C";
  constant YOLO_REG_ADR              : std_logic_vector(11 downto 0) := x"090";
  constant TIMESTAMP_LOW_ADR         : std_logic_vector(11 downto 0) := x"094";
  constant TIMESTAMP_HIGH_ADR        : std_logic_vector(11 downto 0) := x"098";

  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  -- Address block: TX_Buffer_1
  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  constant TX_BUFFER_1_BLOCK            : std_logic_vector(3 downto 0) := x"1";

  constant TXTB1_DATA_1_ADR          : std_logic_vector(11 downto 0) := x"100";
  constant TXTB1_DATA_2_ADR          : std_logic_vector(11 downto 0) := x"104";
  constant TXTB1_DATA_3_ADR          : std_logic_vector(11 downto 0) := x"108";
  constant TXTB1_DATA_4_ADR          : std_logic_vector(11 downto 0) := x"10C";
  constant TXTB1_DATA_5_ADR          : std_logic_vector(11 downto 0) := x"110";
  constant TXTB1_DATA_6_ADR          : std_logic_vector(11 downto 0) := x"114";
  constant TXTB1_DATA_7_ADR          : std_logic_vector(11 downto 0) := x"118";
  constant TXTB1_DATA_8_ADR          : std_logic_vector(11 downto 0) := x"11C";
  constant TXTB1_DATA_9_ADR          : std_logic_vector(11 downto 0) := x"120";
  constant TXTB1_DATA_10_ADR         : std_logic_vector(11 downto 0) := x"124";
  constant TXTB1_DATA_11_ADR         : std_logic_vector(11 downto 0) := x"128";
  constant TXTB1_DATA_12_ADR         : std_logic_vector(11 downto 0) := x"12C";
  constant TXTB1_DATA_13_ADR         : std_logic_vector(11 downto 0) := x"130";
  constant TXTB1_DATA_14_ADR         : std_logic_vector(11 downto 0) := x"134";
  constant TXTB1_DATA_15_ADR         : std_logic_vector(11 downto 0) := x"138";
  constant TXTB1_DATA_16_ADR         : std_logic_vector(11 downto 0) := x"13C";
  constant TXTB1_DATA_17_ADR         : std_logic_vector(11 downto 0) := x"140";
  constant TXTB1_DATA_18_ADR         : std_logic_vector(11 downto 0) := x"144";
  constant TXTB1_DATA_19_ADR         : std_logic_vector(11 downto 0) := x"148";
  constant TXTB1_DATA_20_ADR         : std_logic_vector(11 downto 0) := x"14C";
  constant TXTB1_DATA_21_ADR         : std_logic_vector(11 downto 0) := x"150";

  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  -- Address block: TX_Buffer_2
  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  constant TX_BUFFER_2_BLOCK            : std_logic_vector(3 downto 0) := x"2";

  constant TXTB2_DATA_1_ADR          : std_logic_vector(11 downto 0) := x"200";
  constant TXTB2_DATA_2_ADR          : std_logic_vector(11 downto 0) := x"204";
  constant TXTB2_DATA_3_ADR          : std_logic_vector(11 downto 0) := x"208";
  constant TXTB2_DATA_4_ADR          : std_logic_vector(11 downto 0) := x"20C";
  constant TXTB2_DATA_5_ADR          : std_logic_vector(11 downto 0) := x"210";
  constant TXTB2_DATA_6_ADR          : std_logic_vector(11 downto 0) := x"214";
  constant TXTB2_DATA_7_ADR          : std_logic_vector(11 downto 0) := x"218";
  constant TXTB2_DATA_8_ADR          : std_logic_vector(11 downto 0) := x"21C";
  constant TXTB2_DATA_9_ADR          : std_logic_vector(11 downto 0) := x"220";
  constant TXTB2_DATA_10_ADR         : std_logic_vector(11 downto 0) := x"224";
  constant TXTB2_DATA_11_ADR         : std_logic_vector(11 downto 0) := x"228";
  constant TXTB2_DATA_12_ADR         : std_logic_vector(11 downto 0) := x"22C";
  constant TXTB2_DATA_13_ADR         : std_logic_vector(11 downto 0) := x"230";
  constant TXTB2_DATA_14_ADR         : std_logic_vector(11 downto 0) := x"234";
  constant TXTB2_DATA_15_ADR         : std_logic_vector(11 downto 0) := x"238";
  constant TXTB2_DATA_16_ADR         : std_logic_vector(11 downto 0) := x"23C";
  constant TXTB2_DATA_17_ADR         : std_logic_vector(11 downto 0) := x"240";
  constant TXTB2_DATA_18_ADR         : std_logic_vector(11 downto 0) := x"244";
  constant TXTB2_DATA_19_ADR         : std_logic_vector(11 downto 0) := x"248";
  constant TXTB2_DATA_20_ADR         : std_logic_vector(11 downto 0) := x"24C";
  constant TXTB2_DATA_21_ADR         : std_logic_vector(11 downto 0) := x"250";

  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  -- Address block: TX_Buffer_3
  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  constant TX_BUFFER_3_BLOCK            : std_logic_vector(3 downto 0) := x"3";

  constant TXTB3_DATA_1_ADR          : std_logic_vector(11 downto 0) := x"300";
  constant TXTB3_DATA_2_ADR          : std_logic_vector(11 downto 0) := x"304";
  constant TXTB3_DATA_3_ADR          : std_logic_vector(11 downto 0) := x"308";
  constant TXTB3_DATA_4_ADR          : std_logic_vector(11 downto 0) := x"30C";
  constant TXTB3_DATA_5_ADR          : std_logic_vector(11 downto 0) := x"310";
  constant TXTB3_DATA_6_ADR          : std_logic_vector(11 downto 0) := x"314";
  constant TXTB3_DATA_7_ADR          : std_logic_vector(11 downto 0) := x"318";
  constant TXTB3_DATA_8_ADR          : std_logic_vector(11 downto 0) := x"31C";
  constant TXTB3_DATA_9_ADR          : std_logic_vector(11 downto 0) := x"320";
  constant TXTB3_DATA_10_ADR         : std_logic_vector(11 downto 0) := x"324";
  constant TXTB3_DATA_11_ADR         : std_logic_vector(11 downto 0) := x"328";
  constant TXTB3_DATA_12_ADR         : std_logic_vector(11 downto 0) := x"32C";
  constant TXTB3_DATA_13_ADR         : std_logic_vector(11 downto 0) := x"330";
  constant TXTB3_DATA_14_ADR         : std_logic_vector(11 downto 0) := x"334";
  constant TXTB3_DATA_15_ADR         : std_logic_vector(11 downto 0) := x"338";
  constant TXTB3_DATA_16_ADR         : std_logic_vector(11 downto 0) := x"33C";
  constant TXTB3_DATA_17_ADR         : std_logic_vector(11 downto 0) := x"340";
  constant TXTB3_DATA_18_ADR         : std_logic_vector(11 downto 0) := x"344";
  constant TXTB3_DATA_19_ADR         : std_logic_vector(11 downto 0) := x"348";
  constant TXTB3_DATA_20_ADR         : std_logic_vector(11 downto 0) := x"34C";
  constant TXTB3_DATA_21_ADR         : std_logic_vector(11 downto 0) := x"350";

  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  -- Address block: TX_Buffer_4
  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  constant TX_BUFFER_4_BLOCK            : std_logic_vector(3 downto 0) := x"4";

  constant TXTB4_DATA_1_ADR          : std_logic_vector(11 downto 0) := x"400";
  constant TXTB4_DATA_2_ADR          : std_logic_vector(11 downto 0) := x"404";
  constant TXTB4_DATA_3_ADR          : std_logic_vector(11 downto 0) := x"408";
  constant TXTB4_DATA_4_ADR          : std_logic_vector(11 downto 0) := x"40C";
  constant TXTB4_DATA_5_ADR          : std_logic_vector(11 downto 0) := x"410";
  constant TXTB4_DATA_6_ADR          : std_logic_vector(11 downto 0) := x"414";
  constant TXTB4_DATA_7_ADR          : std_logic_vector(11 downto 0) := x"418";
  constant TXTB4_DATA_8_ADR          : std_logic_vector(11 downto 0) := x"41C";
  constant TXTB4_DATA_9_ADR          : std_logic_vector(11 downto 0) := x"420";
  constant TXTB4_DATA_10_ADR         : std_logic_vector(11 downto 0) := x"424";
  constant TXTB4_DATA_11_ADR         : std_logic_vector(11 downto 0) := x"428";
  constant TXTB4_DATA_12_ADR         : std_logic_vector(11 downto 0) := x"42C";
  constant TXTB4_DATA_13_ADR         : std_logic_vector(11 downto 0) := x"430";
  constant TXTB4_DATA_14_ADR         : std_logic_vector(11 downto 0) := x"434";
  constant TXTB4_DATA_15_ADR         : std_logic_vector(11 downto 0) := x"438";
  constant TXTB4_DATA_16_ADR         : std_logic_vector(11 downto 0) := x"43C";
  constant TXTB4_DATA_17_ADR         : std_logic_vector(11 downto 0) := x"440";
  constant TXTB4_DATA_18_ADR         : std_logic_vector(11 downto 0) := x"444";
  constant TXTB4_DATA_19_ADR         : std_logic_vector(11 downto 0) := x"448";
  constant TXTB4_DATA_20_ADR         : std_logic_vector(11 downto 0) := x"44C";
  constant TXTB4_DATA_21_ADR         : std_logic_vector(11 downto 0) := x"450";

  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  -- Address block: TX_Buffer_5
  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  constant TX_BUFFER_5_BLOCK            : std_logic_vector(3 downto 0) := x"5";

  constant TXTB5_DATA_1_ADR          : std_logic_vector(11 downto 0) := x"500";
  constant TXTB5_DATA_2_ADR          : std_logic_vector(11 downto 0) := x"504";
  constant TXTB5_DATA_3_ADR          : std_logic_vector(11 downto 0) := x"508";
  constant TXTB5_DATA_4_ADR          : std_logic_vector(11 downto 0) := x"50C";
  constant TXTB5_DATA_5_ADR          : std_logic_vector(11 downto 0) := x"510";
  constant TXTB5_DATA_6_ADR          : std_logic_vector(11 downto 0) := x"514";
  constant TXTB5_DATA_7_ADR          : std_logic_vector(11 downto 0) := x"518";
  constant TXTB5_DATA_8_ADR          : std_logic_vector(11 downto 0) := x"51C";
  constant TXTB5_DATA_9_ADR          : std_logic_vector(11 downto 0) := x"520";
  constant TXTB5_DATA_10_ADR         : std_logic_vector(11 downto 0) := x"524";
  constant TXTB5_DATA_11_ADR         : std_logic_vector(11 downto 0) := x"528";
  constant TXTB5_DATA_12_ADR         : std_logic_vector(11 downto 0) := x"52C";
  constant TXTB5_DATA_13_ADR         : std_logic_vector(11 downto 0) := x"530";
  constant TXTB5_DATA_14_ADR         : std_logic_vector(11 downto 0) := x"534";
  constant TXTB5_DATA_15_ADR         : std_logic_vector(11 downto 0) := x"538";
  constant TXTB5_DATA_16_ADR         : std_logic_vector(11 downto 0) := x"53C";
  constant TXTB5_DATA_17_ADR         : std_logic_vector(11 downto 0) := x"540";
  constant TXTB5_DATA_18_ADR         : std_logic_vector(11 downto 0) := x"544";
  constant TXTB5_DATA_19_ADR         : std_logic_vector(11 downto 0) := x"548";
  constant TXTB5_DATA_20_ADR         : std_logic_vector(11 downto 0) := x"54C";
  constant TXTB5_DATA_21_ADR         : std_logic_vector(11 downto 0) := x"550";

  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  -- Address block: TX_Buffer_6
  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  constant TX_BUFFER_6_BLOCK            : std_logic_vector(3 downto 0) := x"6";

  constant TXTB6_DATA_1_ADR          : std_logic_vector(11 downto 0) := x"600";
  constant TXTB6_DATA_2_ADR          : std_logic_vector(11 downto 0) := x"604";
  constant TXTB6_DATA_3_ADR          : std_logic_vector(11 downto 0) := x"608";
  constant TXTB6_DATA_4_ADR          : std_logic_vector(11 downto 0) := x"60C";
  constant TXTB6_DATA_5_ADR          : std_logic_vector(11 downto 0) := x"610";
  constant TXTB6_DATA_6_ADR          : std_logic_vector(11 downto 0) := x"614";
  constant TXTB6_DATA_7_ADR          : std_logic_vector(11 downto 0) := x"618";
  constant TXTB6_DATA_8_ADR          : std_logic_vector(11 downto 0) := x"61C";
  constant TXTB6_DATA_9_ADR          : std_logic_vector(11 downto 0) := x"620";
  constant TXTB6_DATA_10_ADR         : std_logic_vector(11 downto 0) := x"624";
  constant TXTB6_DATA_11_ADR         : std_logic_vector(11 downto 0) := x"628";
  constant TXTB6_DATA_12_ADR         : std_logic_vector(11 downto 0) := x"62C";
  constant TXTB6_DATA_13_ADR         : std_logic_vector(11 downto 0) := x"630";
  constant TXTB6_DATA_14_ADR         : std_logic_vector(11 downto 0) := x"634";
  constant TXTB6_DATA_15_ADR         : std_logic_vector(11 downto 0) := x"638";
  constant TXTB6_DATA_16_ADR         : std_logic_vector(11 downto 0) := x"63C";
  constant TXTB6_DATA_17_ADR         : std_logic_vector(11 downto 0) := x"640";
  constant TXTB6_DATA_18_ADR         : std_logic_vector(11 downto 0) := x"644";
  constant TXTB6_DATA_19_ADR         : std_logic_vector(11 downto 0) := x"648";
  constant TXTB6_DATA_20_ADR         : std_logic_vector(11 downto 0) := x"64C";
  constant TXTB6_DATA_21_ADR         : std_logic_vector(11 downto 0) := x"650";

  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  -- Address block: TX_Buffer_7
  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  constant TX_BUFFER_7_BLOCK            : std_logic_vector(3 downto 0) := x"7";

  constant TXTB7_DATA_1_ADR          : std_logic_vector(11 downto 0) := x"700";
  constant TXTB7_DATA_2_ADR          : std_logic_vector(11 downto 0) := x"704";
  constant TXTB7_DATA_3_ADR          : std_logic_vector(11 downto 0) := x"708";
  constant TXTB7_DATA_4_ADR          : std_logic_vector(11 downto 0) := x"70C";
  constant TXTB7_DATA_5_ADR          : std_logic_vector(11 downto 0) := x"710";
  constant TXTB7_DATA_6_ADR          : std_logic_vector(11 downto 0) := x"714";
  constant TXTB7_DATA_7_ADR          : std_logic_vector(11 downto 0) := x"718";
  constant TXTB7_DATA_8_ADR          : std_logic_vector(11 downto 0) := x"71C";
  constant TXTB7_DATA_9_ADR          : std_logic_vector(11 downto 0) := x"720";
  constant TXTB7_DATA_10_ADR         : std_logic_vector(11 downto 0) := x"724";
  constant TXTB7_DATA_11_ADR         : std_logic_vector(11 downto 0) := x"728";
  constant TXTB7_DATA_12_ADR         : std_logic_vector(11 downto 0) := x"72C";
  constant TXTB7_DATA_13_ADR         : std_logic_vector(11 downto 0) := x"730";
  constant TXTB7_DATA_14_ADR         : std_logic_vector(11 downto 0) := x"734";
  constant TXTB7_DATA_15_ADR         : std_logic_vector(11 downto 0) := x"738";
  constant TXTB7_DATA_16_ADR         : std_logic_vector(11 downto 0) := x"73C";
  constant TXTB7_DATA_17_ADR         : std_logic_vector(11 downto 0) := x"740";
  constant TXTB7_DATA_18_ADR         : std_logic_vector(11 downto 0) := x"744";
  constant TXTB7_DATA_19_ADR         : std_logic_vector(11 downto 0) := x"748";
  constant TXTB7_DATA_20_ADR         : std_logic_vector(11 downto 0) := x"74C";
  constant TXTB7_DATA_21_ADR         : std_logic_vector(11 downto 0) := x"750";

  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  -- Address block: TX_Buffer_8
  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  constant TX_BUFFER_8_BLOCK            : std_logic_vector(3 downto 0) := x"8";

  constant TXTB8_DATA_1_ADR          : std_logic_vector(11 downto 0) := x"800";
  constant TXTB8_DATA_2_ADR          : std_logic_vector(11 downto 0) := x"804";
  constant TXTB8_DATA_3_ADR          : std_logic_vector(11 downto 0) := x"808";
  constant TXTB8_DATA_4_ADR          : std_logic_vector(11 downto 0) := x"80C";
  constant TXTB8_DATA_5_ADR          : std_logic_vector(11 downto 0) := x"810";
  constant TXTB8_DATA_6_ADR          : std_logic_vector(11 downto 0) := x"814";
  constant TXTB8_DATA_7_ADR          : std_logic_vector(11 downto 0) := x"818";
  constant TXTB8_DATA_8_ADR          : std_logic_vector(11 downto 0) := x"81C";
  constant TXTB8_DATA_9_ADR          : std_logic_vector(11 downto 0) := x"820";
  constant TXTB8_DATA_10_ADR         : std_logic_vector(11 downto 0) := x"824";
  constant TXTB8_DATA_11_ADR         : std_logic_vector(11 downto 0) := x"828";
  constant TXTB8_DATA_12_ADR         : std_logic_vector(11 downto 0) := x"82C";
  constant TXTB8_DATA_13_ADR         : std_logic_vector(11 downto 0) := x"830";
  constant TXTB8_DATA_14_ADR         : std_logic_vector(11 downto 0) := x"834";
  constant TXTB8_DATA_15_ADR         : std_logic_vector(11 downto 0) := x"838";
  constant TXTB8_DATA_16_ADR         : std_logic_vector(11 downto 0) := x"83C";
  constant TXTB8_DATA_17_ADR         : std_logic_vector(11 downto 0) := x"840";
  constant TXTB8_DATA_18_ADR         : std_logic_vector(11 downto 0) := x"844";
  constant TXTB8_DATA_19_ADR         : std_logic_vector(11 downto 0) := x"848";
  constant TXTB8_DATA_20_ADR         : std_logic_vector(11 downto 0) := x"84C";
  constant TXTB8_DATA_21_ADR         : std_logic_vector(11 downto 0) := x"850";

  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  -- Address block: Test_registers
  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  constant TEST_REGISTERS_BLOCK         : std_logic_vector(3 downto 0) := x"9";

  constant TST_CONTROL_ADR           : std_logic_vector(11 downto 0) := x"900";
  constant TST_DEST_ADR              : std_logic_vector(11 downto 0) := x"904";
  constant TST_WDATA_ADR             : std_logic_vector(11 downto 0) := x"908";
  constant TST_RDATA_ADR             : std_logic_vector(11 downto 0) := x"90C";

  ------------------------------------------------------------------------------
  -- DEVICE_ID register
  --
  -- Identifer of CTU CAN FD. Can be used to check if CTU CAN FD is accessible c
  -- orrectly on its base address.
  ------------------------------------------------------------------------------
  constant DEVICE_ID_L            : natural := 0;
  constant DEVICE_ID_H           : natural := 15;

  -- "DEVICE_ID" field enumerated values
  constant CTU_CAN_FD_ID : std_logic_vector(15 downto 0) := x"CAFD";

  -- DEVICE_ID register reset values
  constant DEVICE_ID_RSTVAL : std_logic_vector(15 downto 0) := x"CAFD";

  ------------------------------------------------------------------------------
  -- VERSION register
  --
  -- Version register. Returns version of CTU CAN FD.
  ------------------------------------------------------------------------------
  constant VER_MINOR_L           : natural := 16;
  constant VER_MINOR_H           : natural := 23;
  constant VER_MAJOR_L           : natural := 24;
  constant VER_MAJOR_H           : natural := 31;

  -- VERSION register reset values

  ------------------------------------------------------------------------------
  -- MODE register
  --
  ------------------------------------------------------------------------------
  constant RST_IND                : natural := 0;
  constant BMM_IND                : natural := 1;
  constant STM_IND                : natural := 2;
  constant AFM_IND                : natural := 3;
  constant FDE_IND                : natural := 4;
  constant TTTM_IND               : natural := 5;
  constant ROM_IND                : natural := 6;
  constant ACF_IND                : natural := 7;
  constant TSTM_IND               : natural := 8;
  constant RXBAM_IND              : natural := 9;
  constant TXBBM_IND             : natural := 10;
  constant SAM_IND               : natural := 11;

  -- "FDE" field enumerated values
  constant FDE_DISABLE        : std_logic := '0';
  constant FDE_ENABLE         : std_logic := '1';

  -- "ACF" field enumerated values
  constant ACF_DISABLED       : std_logic := '0';
  constant ACF_ENABLED        : std_logic := '1';

  -- "BMM" field enumerated values
  constant BMM_DISABLED       : std_logic := '0';
  constant BMM_ENABLED        : std_logic := '1';

  -- "STM" field enumerated values
  constant STM_DISABLED       : std_logic := '0';
  constant STM_ENABLED        : std_logic := '1';

  -- "AFM" field enumerated values
  constant AFM_DISABLED       : std_logic := '0';
  constant AFM_ENABLED        : std_logic := '1';

  -- "ROM" field enumerated values
  constant ROM_DISABLED       : std_logic := '0';
  constant ROM_ENABLED        : std_logic := '1';

  -- "TTTM" field enumerated values
  constant TTTM_DISABLED      : std_logic := '0';
  constant TTTM_ENABLED       : std_logic := '1';

  -- "TXBBM" field enumerated values
  constant TXBBM_DISABLED     : std_logic := '0';
  constant TXBBM_ENABLED      : std_logic := '1';

  -- "RXBAM" field enumerated values
  constant RXBAM_DISABLED     : std_logic := '0';
  constant RXBAM_ENABLED      : std_logic := '1';

  -- "SAM" field enumerated values
  constant SAM_DISABLE        : std_logic := '0';
  constant SAM_ENABLE         : std_logic := '1';

  -- MODE register reset values
  constant RST_RSTVAL         : std_logic := '0';
  constant FDE_RSTVAL         : std_logic := '1';
  constant ACF_RSTVAL         : std_logic := '0';
  constant BMM_RSTVAL         : std_logic := '0';
  constant STM_RSTVAL         : std_logic := '0';
  constant AFM_RSTVAL         : std_logic := '0';
  constant TSTM_RSTVAL        : std_logic := '0';
  constant ROM_RSTVAL         : std_logic := '0';
  constant TTTM_RSTVAL        : std_logic := '0';
  constant TXBBM_RSTVAL       : std_logic := '0';
  constant RXBAM_RSTVAL       : std_logic := '1';
  constant SAM_RSTVAL         : std_logic := '0';

  ------------------------------------------------------------------------------
  -- SETTINGS register
  --
  ------------------------------------------------------------------------------
  constant RTRLE_IND             : natural := 16;
  constant RTRTH_L               : natural := 17;
  constant RTRTH_H               : natural := 20;
  constant ILBP_IND              : natural := 21;
  constant ENA_IND               : natural := 22;
  constant NISOFD_IND            : natural := 23;
  constant PEX_IND               : natural := 24;
  constant TBFBO_IND             : natural := 25;
  constant FDRF_IND              : natural := 26;
  constant PCHKE_IND             : natural := 27;

  -- "RTRLE" field enumerated values
  constant RTRLE_DISABLED     : std_logic := '0';
  constant RTRLE_ENABLED      : std_logic := '1';

  -- "ILBP" field enumerated values
  constant INT_LOOP_DISABLED  : std_logic := '0';
  constant INT_LOOP_ENABLED   : std_logic := '1';

  -- "ENA" field enumerated values
  constant CTU_CAN_DISABLED   : std_logic := '0';
  constant CTU_CAN_ENABLED    : std_logic := '1';

  -- "NISOFD" field enumerated values
  constant ISO_FD             : std_logic := '0';
  constant NON_ISO_FD         : std_logic := '1';

  -- "PEX" field enumerated values
  constant PROTOCOL_EXCEPTION_DISABLED : std_logic := '0';
  constant PROTOCOL_EXCEPTION_ENABLED : std_logic := '1';

  -- "TBFBO" field enumerated values
  constant TXTBUF_FAILED_BUS_OFF_DISABLED : std_logic := '0';
  constant TXTBUF_FAILED_BUS_OFF_ENABLED : std_logic := '1';

  -- "FDRF" field enumerated values
  constant DROP_RF_DISABLED   : std_logic := '0';
  constant DROP_RF_ENABLED    : std_logic := '1';

  -- SETTINGS register reset values
  constant RTRLE_RSTVAL       : std_logic := '0';
  constant RTRTH_RSTVAL : std_logic_vector(3 downto 0) := x"0";
  constant ILBP_RSTVAL        : std_logic := '0';
  constant ENA_RSTVAL         : std_logic := '0';
  constant NISOFD_RSTVAL      : std_logic := '0';
  constant PEX_RSTVAL         : std_logic := '0';
  constant TBFBO_RSTVAL       : std_logic := '1';
  constant FDRF_RSTVAL        : std_logic := '0';

  ------------------------------------------------------------------------------
  -- STATUS register
  --
  ------------------------------------------------------------------------------
  constant RXNE_IND               : natural := 0;
  constant DOR_IND                : natural := 1;
  constant TXNF_IND               : natural := 2;
  constant EFT_IND                : natural := 3;
  constant RXS_IND                : natural := 4;
  constant TXS_IND                : natural := 5;
  constant EWL_IND                : natural := 6;
  constant IDLE_IND               : natural := 7;
  constant PEXS_IND               : natural := 8;
  constant RXPE_IND               : natural := 9;
  constant TXPE_IND              : natural := 10;
  constant TXDPE_IND             : natural := 11;
  constant STCNT_IND             : natural := 16;
  constant STRGS_IND             : natural := 17;
  constant SPRT_IND              : natural := 18;

  -- STATUS register reset values
  constant RXNE_RSTVAL        : std_logic := '0';
  constant TXNF_RSTVAL        : std_logic := '1';
  constant DOR_RSTVAL         : std_logic := '0';
  constant EFT_RSTVAL         : std_logic := '0';
  constant RXS_RSTVAL         : std_logic := '0';
  constant TXS_RSTVAL         : std_logic := '0';
  constant EWL_RSTVAL         : std_logic := '0';
  constant IDLE_RSTVAL        : std_logic := '1';
  constant RXPE_RSTVAL        : std_logic := '0';
  constant TXPE_RSTVAL        : std_logic := '0';
  constant PEXS_RSTVAL        : std_logic := '0';
  constant TXDPE_RSTVAL       : std_logic := '0';

  ------------------------------------------------------------------------------
  -- COMMAND register
  --
  -- Allows issuing commands to CTU CAN FD. Writing logic 1 to each bit gives a 
  -- command to CTU CAN FD. After writing logic 1, logic 0 does not need to be w
  -- ritten.
  ------------------------------------------------------------------------------
  constant RXRPMV_IND             : natural := 1;
  constant RRB_IND                : natural := 2;
  constant CDO_IND                : natural := 3;
  constant ERCRST_IND             : natural := 4;
  constant RXFCRST_IND            : natural := 5;
  constant TXFCRST_IND            : natural := 6;
  constant CPEXS_IND              : natural := 7;
  constant CRXPE_IND              : natural := 8;
  constant CTXPE_IND              : natural := 9;
  constant CTXDPE_IND            : natural := 10;

  -- COMMAND register reset values
  constant RRB_RSTVAL         : std_logic := '0';
  constant CDO_RSTVAL         : std_logic := '0';
  constant ERCRST_RSTVAL      : std_logic := '0';
  constant RXFCRST_RSTVAL     : std_logic := '0';
  constant TXFCRST_RSTVAL     : std_logic := '0';
  constant CPEXS_RSTVAL       : std_logic := '0';
  constant CRXPE_RSTVAL       : std_logic := '0';
  constant CTXDPE_RSTVAL      : std_logic := '0';
  constant CTXPE_RSTVAL       : std_logic := '0';

  ------------------------------------------------------------------------------
  -- INT_STAT register
  --
  -- Interrupt Status register. Reading this register returns logic 1 for each i
  -- nterrupt which ocurred. Writing logic 1 to any bit clears according interru
  -- pt status. Writing logic 0 has no effect.
  ------------------------------------------------------------------------------
  constant RXI_IND                : natural := 0;
  constant TXI_IND                : natural := 1;
  constant EWLI_IND               : natural := 2;
  constant DOI_IND                : natural := 3;
  constant FCSI_IND               : natural := 4;
  constant ALI_IND                : natural := 5;
  constant BEI_IND                : natural := 6;
  constant OFI_IND                : natural := 7;
  constant RXFI_IND               : natural := 8;
  constant BSI_IND                : natural := 9;
  constant RBNEI_IND             : natural := 10;
  constant TXBHCI_IND            : natural := 11;

  -- INT_STAT register reset values
  constant RXI_RSTVAL         : std_logic := '0';
  constant TXI_RSTVAL         : std_logic := '0';
  constant EWLI_RSTVAL        : std_logic := '0';
  constant DOI_RSTVAL         : std_logic := '0';
  constant FCSI_RSTVAL        : std_logic := '0';
  constant ALI_RSTVAL         : std_logic := '0';
  constant BEI_RSTVAL         : std_logic := '0';
  constant RXFI_RSTVAL        : std_logic := '0';
  constant BSI_RSTVAL         : std_logic := '0';
  constant RBNEI_RSTVAL       : std_logic := '0';
  constant OFI_RSTVAL         : std_logic := '0';
  constant TXBHCI_RSTVAL      : std_logic := '0';

  ------------------------------------------------------------------------------
  -- INT_ENA_SET register
  --
  -- Interrupt Enable Set. Writing logic 1 to a bit enables according interrupt.
  --  Writing logic 0 has no effect. Reading this register returns logic 1 for e
  -- ach enabled interrupt. If interrupt is captured in INT_STAT, enabled interr
  -- upt will cause CTU CAN FD to raise interrupt. Interrupts are level-based, i
  -- t remains active until Interrupt status is cleared or interrupt is disabled
  -- .
  ------------------------------------------------------------------------------
  constant INT_ENA_SET_L          : natural := 0;
  constant INT_ENA_SET_H         : natural := 11;

  -- INT_ENA_SET register reset values
  constant INT_ENA_SET_RSTVAL : std_logic_vector(11 downto 0) := x"000";

  ------------------------------------------------------------------------------
  -- INT_ENA_CLR register
  --
  -- Interrupt Enable Clear register. Writing logic 1 disables according interru
  -- pt. Writing logic 0 has no effect. Reading this register has no effect. Dis
  -- abled interrupt wil not cause interrupt to be raised by CTU CAN FD even if 
  -- it is set in Interrupt status register.
  ------------------------------------------------------------------------------
  constant INT_ENA_CLR_L          : natural := 0;
  constant INT_ENA_CLR_H         : natural := 11;

  -- INT_ENA_CLR register reset values
  constant INT_ENA_CLR_RSTVAL : std_logic_vector(11 downto 0) := x"000";

  ------------------------------------------------------------------------------
  -- INT_MASK_SET register
  --
  -- Interrupt Mask set. Writing logic 1 masks according interrupt. Writing logi
  -- c 0 has no effect. Reading this register returns logic 1 for each masked in
  -- terrupt. If particular interrupt is masked, it won't be captured in INT_STA
  -- T register when internal conditions for this interrupt are met (e.g RX buff
  -- er is not empty for RXNEI).
  ------------------------------------------------------------------------------
  constant INT_MASK_SET_L         : natural := 0;
  constant INT_MASK_SET_H        : natural := 11;

  -- INT_MASK_SET register reset values
  constant INT_MASK_SET_RSTVAL : std_logic_vector(11 downto 0) := x"000";

  ------------------------------------------------------------------------------
  -- INT_MASK_CLR register
  --
  -- Interrupt Mask clear register. Writing logic 1 un-masks according interrupt
  -- . Writing logic 0 has no effect. Reading this register has no effect. If pa
  -- rticular interrupt is un-masked, it will be captured in INT_STAT register w
  -- hen internal conditions for this interrupt are met (e.g RX buffer is not em
  -- pty for RXNEI).
  ------------------------------------------------------------------------------
  constant INT_MASK_CLR_L         : natural := 0;
  constant INT_MASK_CLR_H        : natural := 11;

  -- INT_MASK_CLR register reset values
  constant INT_MASK_CLR_RSTVAL : std_logic_vector(11 downto 0) := x"000";

  ------------------------------------------------------------------------------
  -- BTR register
  --
  -- Bit timing register for nominal bit rate.
  ------------------------------------------------------------------------------
  constant PROP_L                 : natural := 0;
  constant PROP_H                 : natural := 6;
  constant PH1_L                  : natural := 7;
  constant PH1_H                 : natural := 12;
  constant PH2_L                 : natural := 13;
  constant PH2_H                 : natural := 18;
  constant BRP_L                 : natural := 19;
  constant BRP_H                 : natural := 26;
  constant SJW_L                 : natural := 27;
  constant SJW_H                 : natural := 31;

  -- BTR register reset values
  constant PROP_RSTVAL : std_logic_vector(6 downto 0) := "0000101";
  constant PH1_RSTVAL : std_logic_vector(5 downto 0) := "000011";
  constant PH2_RSTVAL : std_logic_vector(5 downto 0) := "000101";
  constant BRP_RSTVAL : std_logic_vector(7 downto 0) := x"0A";
  constant SJW_RSTVAL : std_logic_vector(4 downto 0) := "00010";

  ------------------------------------------------------------------------------
  -- BTR_FD register
  --
  -- Bit timing register for data bit rate.
  ------------------------------------------------------------------------------
  constant PROP_FD_L              : natural := 0;
  constant PROP_FD_H              : natural := 5;
  constant PH1_FD_L               : natural := 7;
  constant PH1_FD_H              : natural := 11;
  constant PH2_FD_L              : natural := 13;
  constant PH2_FD_H              : natural := 17;
  constant BRP_FD_L              : natural := 19;
  constant BRP_FD_H              : natural := 26;
  constant SJW_FD_L              : natural := 27;
  constant SJW_FD_H              : natural := 31;

  -- BTR_FD register reset values
  constant PH2_FD_RSTVAL : std_logic_vector(4 downto 0) := "00011";
  constant PROP_FD_RSTVAL : std_logic_vector(5 downto 0) := "000011";
  constant PH1_FD_RSTVAL : std_logic_vector(4 downto 0) := "00011";
  constant BRP_FD_RSTVAL : std_logic_vector(7 downto 0) := x"04";
  constant SJW_FD_RSTVAL : std_logic_vector(4 downto 0) := "00010";

  ------------------------------------------------------------------------------
  -- EWL register
  --
  -- Error warning limit register. This register shall be modified only when SET
  -- TINGS[ENA]=0.
  ------------------------------------------------------------------------------
  constant EW_LIMIT_L             : natural := 0;
  constant EW_LIMIT_H             : natural := 7;

  -- EWL register reset values
  constant EW_LIMIT_RSTVAL : std_logic_vector(7 downto 0) := x"60";

  ------------------------------------------------------------------------------
  -- ERP register
  --
  -- Error passive limit register. This register shall be modified only when SET
  -- TINGS[ENA]=0.
  ------------------------------------------------------------------------------
  constant ERP_LIMIT_L            : natural := 8;
  constant ERP_LIMIT_H           : natural := 15;

  -- ERP register reset values
  constant ERP_LIMIT_RSTVAL : std_logic_vector(7 downto 0) := x"80";

  ------------------------------------------------------------------------------
  -- FAULT_STATE register
  --
  -- Fault Confinement state of the CTU CAN FD.
  ------------------------------------------------------------------------------
  constant ERA_IND               : natural := 16;
  constant ERP_IND               : natural := 17;
  constant BOF_IND               : natural := 18;

  -- FAULT_STATE register reset values
  constant ERP_RSTVAL         : std_logic := '0';
  constant BOF_RSTVAL         : std_logic := '0';
  constant ERA_RSTVAL         : std_logic := '1';

  ------------------------------------------------------------------------------
  -- REC register
  --
  ------------------------------------------------------------------------------
  constant REC_VAL_L              : natural := 0;
  constant REC_VAL_H              : natural := 8;

  -- REC register reset values
  constant REC_VAL_RSTVAL : std_logic_vector(8 downto 0) := (OTHERS => '0');

  ------------------------------------------------------------------------------
  -- TEC register
  --
  ------------------------------------------------------------------------------
  constant TEC_VAL_L             : natural := 16;
  constant TEC_VAL_H             : natural := 24;

  -- TEC register reset values
  constant TEC_VAL_RSTVAL : std_logic_vector(8 downto 0) := (OTHERS => '0');

  ------------------------------------------------------------------------------
  -- ERR_NORM register
  --
  ------------------------------------------------------------------------------
  constant ERR_NORM_VAL_L         : natural := 0;
  constant ERR_NORM_VAL_H        : natural := 15;

  -- ERR_NORM register reset values
  constant ERR_NORM_VAL_RSTVAL : std_logic_vector(15 downto 0) := x"0000";

  ------------------------------------------------------------------------------
  -- ERR_FD register
  --
  ------------------------------------------------------------------------------
  constant ERR_FD_VAL_L          : natural := 16;
  constant ERR_FD_VAL_H          : natural := 31;

  -- ERR_FD register reset values
  constant ERR_FD_VAL_RSTVAL : std_logic_vector(15 downto 0) := x"0000";

  ------------------------------------------------------------------------------
  -- CTR_PRES register
  --
  -- Counter preset register. Error counters can be modified via this register.
  ------------------------------------------------------------------------------
  constant CTPV_L                 : natural := 0;
  constant CTPV_H                 : natural := 8;
  constant PTX_IND                : natural := 9;
  constant PRX_IND               : natural := 10;
  constant ENORM_IND             : natural := 11;
  constant EFD_IND               : natural := 12;

  -- CTR_PRES register reset values
  constant CTPV_RSTVAL : std_logic_vector(8 downto 0) := (OTHERS => '0');
  constant PTX_RSTVAL         : std_logic := '0';
  constant PRX_RSTVAL         : std_logic := '0';
  constant ENORM_RSTVAL       : std_logic := '0';
  constant EFD_RSTVAL         : std_logic := '0';

  ------------------------------------------------------------------------------
  -- FILTER_A_MASK register
  --
  ------------------------------------------------------------------------------
  constant BIT_MASK_A_VAL_L       : natural := 0;
  constant BIT_MASK_A_VAL_H      : natural := 28;

  -- FILTER_A_MASK register reset values
  constant BIT_MASK_A_VAL_RSTVAL
                 : std_logic_vector(28 downto 0) := (OTHERS => '0');

  ------------------------------------------------------------------------------
  -- FILTER_A_VAL register
  --
  ------------------------------------------------------------------------------
  constant BIT_VAL_A_VAL_L        : natural := 0;
  constant BIT_VAL_A_VAL_H       : natural := 28;

  -- FILTER_A_VAL register reset values
  constant BIT_VAL_A_VAL_RSTVAL
                 : std_logic_vector(28 downto 0) := (OTHERS => '0');

  ------------------------------------------------------------------------------
  -- FILTER_B_MASK register
  --
  ------------------------------------------------------------------------------
  constant BIT_MASK_B_VAL_L       : natural := 0;
  constant BIT_MASK_B_VAL_H      : natural := 28;

  -- FILTER_B_MASK register reset values
  constant BIT_MASK_B_VAL_RSTVAL
                 : std_logic_vector(28 downto 0) := (OTHERS => '0');

  ------------------------------------------------------------------------------
  -- FILTER_B_VAL register
  --
  ------------------------------------------------------------------------------
  constant BIT_VAL_B_VAL_L        : natural := 0;
  constant BIT_VAL_B_VAL_H       : natural := 28;

  -- FILTER_B_VAL register reset values
  constant BIT_VAL_B_VAL_RSTVAL
                 : std_logic_vector(28 downto 0) := (OTHERS => '0');

  ------------------------------------------------------------------------------
  -- FILTER_C_MASK register
  --
  ------------------------------------------------------------------------------
  constant BIT_MASK_C_VAL_L       : natural := 0;
  constant BIT_MASK_C_VAL_H      : natural := 28;

  -- FILTER_C_MASK register reset values
  constant BIT_MASK_C_VAL_RSTVAL
                 : std_logic_vector(28 downto 0) := (OTHERS => '0');

  ------------------------------------------------------------------------------
  -- FILTER_C_VAL register
  --
  ------------------------------------------------------------------------------
  constant BIT_VAL_C_VAL_L        : natural := 0;
  constant BIT_VAL_C_VAL_H       : natural := 28;

  -- FILTER_C_VAL register reset values
  constant BIT_VAL_C_VAL_RSTVAL
                 : std_logic_vector(28 downto 0) := (OTHERS => '0');

  ------------------------------------------------------------------------------
  -- FILTER_RAN_LOW register
  --
  ------------------------------------------------------------------------------
  constant BIT_RAN_LOW_VAL_L      : natural := 0;
  constant BIT_RAN_LOW_VAL_H     : natural := 28;

  -- FILTER_RAN_LOW register reset values
  constant BIT_RAN_LOW_VAL_RSTVAL
                 : std_logic_vector(28 downto 0) := (OTHERS => '0');

  ------------------------------------------------------------------------------
  -- FILTER_RAN_HIGH register
  --
  ------------------------------------------------------------------------------
  constant BIT_RAN_HIGH_VAL_L     : natural := 0;
  constant BIT_RAN_HIGH_VAL_H    : natural := 28;

  -- FILTER_RAN_HIGH register reset values
  constant BIT_RAN_HIGH_VAL_RSTVAL
                 : std_logic_vector(28 downto 0) := (OTHERS => '0');

  ------------------------------------------------------------------------------
  -- FILTER_CONTROL register
  --
  -- Filter control register. Configures Frame filters to accept only selected f
  -- rame types. Every bit is active in logic 1.
  ------------------------------------------------------------------------------
  constant FANB_IND               : natural := 0;
  constant FANE_IND               : natural := 1;
  constant FAFB_IND               : natural := 2;
  constant FAFE_IND               : natural := 3;
  constant FBNB_IND               : natural := 4;
  constant FBNE_IND               : natural := 5;
  constant FBFB_IND               : natural := 6;
  constant FBFE_IND               : natural := 7;
  constant FCNB_IND               : natural := 8;
  constant FCNE_IND               : natural := 9;
  constant FCFB_IND              : natural := 10;
  constant FCFE_IND              : natural := 11;
  constant FRNB_IND              : natural := 12;
  constant FRNE_IND              : natural := 13;
  constant FRFB_IND              : natural := 14;
  constant FRFE_IND              : natural := 15;

  -- FILTER_CONTROL register reset values
  constant FANB_RSTVAL        : std_logic := '1';
  constant FAFB_RSTVAL        : std_logic := '1';
  constant FANE_RSTVAL        : std_logic := '1';
  constant FAFE_RSTVAL        : std_logic := '1';
  constant FBNB_RSTVAL        : std_logic := '0';
  constant FBNE_RSTVAL        : std_logic := '0';
  constant FBFB_RSTVAL        : std_logic := '0';
  constant FBFE_RSTVAL        : std_logic := '0';
  constant FCNB_RSTVAL        : std_logic := '0';
  constant FCNE_RSTVAL        : std_logic := '0';
  constant FCFB_RSTVAL        : std_logic := '0';
  constant FRFE_RSTVAL        : std_logic := '0';
  constant FRFB_RSTVAL        : std_logic := '0';
  constant FRNE_RSTVAL        : std_logic := '0';
  constant FRNB_RSTVAL        : std_logic := '0';
  constant FCFE_RSTVAL        : std_logic := '0';

  ------------------------------------------------------------------------------
  -- FILTER_STATUS register
  --
  -- Filter status indicates if frame filters are available in CTU CAN FD.
  ------------------------------------------------------------------------------
  constant SFA_IND               : natural := 16;
  constant SFB_IND               : natural := 17;
  constant SFC_IND               : natural := 18;
  constant SFR_IND               : natural := 19;

  -- FILTER_STATUS register reset values

  ------------------------------------------------------------------------------
  -- RX_MEM_INFO register
  --
  ------------------------------------------------------------------------------
  constant RX_BUFF_SIZE_L         : natural := 0;
  constant RX_BUFF_SIZE_H        : natural := 12;
  constant RX_MEM_FREE_L         : natural := 16;
  constant RX_MEM_FREE_H         : natural := 28;

  -- RX_MEM_INFO register reset values

  ------------------------------------------------------------------------------
  -- RX_POINTERS register
  --
  ------------------------------------------------------------------------------
  constant RX_WPP_L               : natural := 0;
  constant RX_WPP_H              : natural := 11;
  constant RX_RPP_L              : natural := 16;
  constant RX_RPP_H              : natural := 27;

  -- RX_POINTERS register reset values
  constant RX_WPP_RSTVAL : std_logic_vector(11 downto 0) := x"000";
  constant RX_RPP_RSTVAL : std_logic_vector(11 downto 0) := x"000";

  ------------------------------------------------------------------------------
  -- RX_STATUS register
  --
  ------------------------------------------------------------------------------
  constant RXE_IND                : natural := 0;
  constant RXF_IND                : natural := 1;
  constant RXMOF_IND              : natural := 2;
  constant RXFRC_L                : natural := 4;
  constant RXFRC_H               : natural := 14;

  -- RX_STATUS register reset values
  constant RXE_RSTVAL         : std_logic := '1';
  constant RXF_RSTVAL         : std_logic := '0';
  constant RXFRC_RSTVAL : std_logic_vector(10 downto 0) := (OTHERS => '0');
  constant RXMOF_RSTVAL       : std_logic := '0';

  ------------------------------------------------------------------------------
  -- RX_SETTINGS register
  --
  -- Settings of RX buffer FIFO.
  ------------------------------------------------------------------------------
  constant RTSOP_IND             : natural := 16;

  -- "RTSOP" field enumerated values
  constant RTS_END            : std_logic := '0';
  constant RTS_BEG            : std_logic := '1';

  -- RX_SETTINGS register reset values
  constant RTSOP_RSTVAL       : std_logic := '0';

  ------------------------------------------------------------------------------
  -- RX_DATA register
  --
  ------------------------------------------------------------------------------
  constant RX_DATA_L              : natural := 0;
  constant RX_DATA_H             : natural := 31;

  -- RX_DATA register reset values
  constant RX_DATA_RSTVAL : std_logic_vector(31 downto 0) := x"00000000";

  ------------------------------------------------------------------------------
  -- TX_STATUS register
  --
  ------------------------------------------------------------------------------
  constant TX1S_L                 : natural := 0;
  constant TX1S_H                 : natural := 3;
  constant TX2S_L                 : natural := 4;
  constant TX2S_H                 : natural := 7;
  constant TX3S_L                 : natural := 8;
  constant TX3S_H                : natural := 11;
  constant TX4S_L                : natural := 12;
  constant TX4S_H                : natural := 15;
  constant TX5S_L                : natural := 16;
  constant TX5S_H                : natural := 19;
  constant TX6S_L                : natural := 20;
  constant TX6S_H                : natural := 23;
  constant TX7S_L                : natural := 24;
  constant TX7S_H                : natural := 27;
  constant TX8S_L                : natural := 28;
  constant TX8S_H                : natural := 31;

  -- "TX1S" field enumerated values
  constant TXT_NOT_EXIST : std_logic_vector(3 downto 0) := x"0";
  constant TXT_RDY : std_logic_vector(3 downto 0) := x"1";
  constant TXT_TRAN : std_logic_vector(3 downto 0) := x"2";
  constant TXT_ABTP : std_logic_vector(3 downto 0) := x"3";
  constant TXT_TOK : std_logic_vector(3 downto 0) := x"4";
  constant TXT_ERR : std_logic_vector(3 downto 0) := x"6";
  constant TXT_ABT : std_logic_vector(3 downto 0) := x"7";
  constant TXT_ETY : std_logic_vector(3 downto 0) := x"8";
  constant TXT_PER : std_logic_vector(3 downto 0) := x"9";

  -- TX_STATUS register reset values
  constant TX2S_RSTVAL : std_logic_vector(3 downto 0) := x"8";
  constant TX1S_RSTVAL : std_logic_vector(3 downto 0) := x"8";
  constant TX3S_RSTVAL : std_logic_vector(3 downto 0) := x"8";
  constant TX4S_RSTVAL : std_logic_vector(3 downto 0) := x"8";
  constant TX5S_RSTVAL : std_logic_vector(3 downto 0) := x"8";
  constant TX7S_RSTVAL : std_logic_vector(3 downto 0) := x"8";
  constant TX6S_RSTVAL : std_logic_vector(3 downto 0) := x"8";
  constant TX8S_RSTVAL : std_logic_vector(3 downto 0) := x"8";

  ------------------------------------------------------------------------------
  -- TX_COMMAND register
  --
  -- Command register for TXT buffers. Command is activated by writing logic 1 t
  -- o TXC(E|R|A) bit. TXT buffer that receives the command is selected by setti
  -- ng bit TXB[1-8] to logic 1. Command and index can be set by single access, 
  -- or index can be set in advance. TXC(E|R|A) bits are automatically erased up
  -- on the command completion. Reffer to description of TXT buffer for meaning 
  -- of commands. If TXCE and TXCR are applied simultaneously, only TXCE command
  --  is applied. If multiple commands are applied at once, only those which hav
  -- e effect in immediate state of TXT buffer are applied to the buffer.
  ------------------------------------------------------------------------------
  constant TXCE_IND               : natural := 0;
  constant TXCR_IND               : natural := 1;
  constant TXCA_IND               : natural := 2;
  constant TXB1_IND               : natural := 8;
  constant TXB2_IND               : natural := 9;
  constant TXB3_IND              : natural := 10;
  constant TXB4_IND              : natural := 11;
  constant TXB5_IND              : natural := 12;
  constant TXB6_IND              : natural := 13;
  constant TXB7_IND              : natural := 14;
  constant TXB8_IND              : natural := 15;

  -- TX_COMMAND register reset values
  constant TXCE_RSTVAL        : std_logic := '0';
  constant TXCR_RSTVAL        : std_logic := '0';
  constant TXCA_RSTVAL        : std_logic := '0';
  constant TXB1_RSTVAL        : std_logic := '0';
  constant TXB2_RSTVAL        : std_logic := '0';
  constant TXB3_RSTVAL        : std_logic := '0';
  constant TXB4_RSTVAL        : std_logic := '0';
  constant TXB5_RSTVAL        : std_logic := '0';
  constant TXB6_RSTVAL        : std_logic := '0';
  constant TXB7_RSTVAL        : std_logic := '0';
  constant TXB8_RSTVAL        : std_logic := '0';

  ------------------------------------------------------------------------------
  -- TXTB_INFO register
  --
  -- Register with information about supported features of TXT buffers.
  ------------------------------------------------------------------------------
  constant TXT_BUFFER_COUNT_L    : natural := 16;
  constant TXT_BUFFER_COUNT_H    : natural := 19;

  -- TXTB_INFO register reset values

  ------------------------------------------------------------------------------
  -- TX_PRIORITY register
  --
  -- Priority of TXT buffers. Highest priority TXT buffer in "Ready" state is se
  -- lected for transmission.
  ------------------------------------------------------------------------------
  constant TXT1P_L                : natural := 0;
  constant TXT1P_H                : natural := 2;
  constant TXT2P_L                : natural := 4;
  constant TXT2P_H                : natural := 6;
  constant TXT3P_L                : natural := 8;
  constant TXT3P_H               : natural := 10;
  constant TXT4P_L               : natural := 12;
  constant TXT4P_H               : natural := 14;
  constant TXT5P_L               : natural := 16;
  constant TXT5P_H               : natural := 18;
  constant TXT6P_L               : natural := 20;
  constant TXT6P_H               : natural := 22;
  constant TXT7P_L               : natural := 24;
  constant TXT7P_H               : natural := 26;
  constant TXT8P_L               : natural := 28;
  constant TXT8P_H               : natural := 30;

  -- TX_PRIORITY register reset values
  constant TXT1P_RSTVAL : std_logic_vector(2 downto 0) := "001";
  constant TXT2P_RSTVAL : std_logic_vector(2 downto 0) := "000";
  constant TXT3P_RSTVAL : std_logic_vector(2 downto 0) := "000";
  constant TXT4P_RSTVAL : std_logic_vector(2 downto 0) := "000";
  constant TXT5P_RSTVAL : std_logic_vector(2 downto 0) := "000";
  constant TXT6P_RSTVAL : std_logic_vector(2 downto 0) := "000";
  constant TXT7P_RSTVAL : std_logic_vector(2 downto 0) := "000";
  constant TXT8P_RSTVAL : std_logic_vector(2 downto 0) := "000";

  ------------------------------------------------------------------------------
  -- ERR_CAPT register
  --
  -- Error code capture register. Determines position within CAN frame where las
  -- t error was detected.
  ------------------------------------------------------------------------------
  constant ERR_POS_L              : natural := 0;
  constant ERR_POS_H              : natural := 4;
  constant ERR_TYPE_L             : natural := 5;
  constant ERR_TYPE_H             : natural := 7;

  -- "ERR_POS" field enumerated values
  constant ERC_POS_SOF : std_logic_vector(4 downto 0) := "00000";
  constant ERC_POS_ARB : std_logic_vector(4 downto 0) := "00001";
  constant ERC_POS_CTRL : std_logic_vector(4 downto 0) := "00010";
  constant ERC_POS_DATA : std_logic_vector(4 downto 0) := "00011";
  constant ERC_POS_CRC : std_logic_vector(4 downto 0) := "00100";
  constant ERC_POS_ACK : std_logic_vector(4 downto 0) := "00101";
  constant ERC_POS_EOF : std_logic_vector(4 downto 0) := "00110";
  constant ERC_POS_ERR : std_logic_vector(4 downto 0) := "00111";
  constant ERC_POS_OVRL : std_logic_vector(4 downto 0) := "01000";
  constant ERC_POS_OTHER : std_logic_vector(4 downto 0) := "11111";

  -- "ERR_TYPE" field enumerated values
  constant ERC_BIT_ERR : std_logic_vector(2 downto 0) := "000";
  constant ERC_CRC_ERR : std_logic_vector(2 downto 0) := "001";
  constant ERC_FRM_ERR : std_logic_vector(2 downto 0) := "010";
  constant ERC_ACK_ERR : std_logic_vector(2 downto 0) := "011";
  constant ERC_STUF_ERR : std_logic_vector(2 downto 0) := "100";
  constant ERC_PRT_ERR : std_logic_vector(2 downto 0) := "101";

  -- ERR_CAPT register reset values
  constant ERR_POS_RSTVAL : std_logic_vector(4 downto 0) := "11111";
  constant ERR_TYPE_RSTVAL : std_logic_vector(2 downto 0) := "000";

  ------------------------------------------------------------------------------
  -- RETR_CTR register
  --
  -- Current value of Retransmit counter.
  ------------------------------------------------------------------------------
  constant RETR_CTR_VAL_L         : natural := 8;
  constant RETR_CTR_VAL_H        : natural := 11;

  -- RETR_CTR register reset values
  constant RETR_CTR_VAL_RSTVAL : std_logic_vector(3 downto 0) := x"0";

  ------------------------------------------------------------------------------
  -- ALC register
  --
  -- Arbitration lost capture register. Determines position of last arbitration 
  -- loss within CAN frame.
  ------------------------------------------------------------------------------
  constant ALC_BIT_L             : natural := 16;
  constant ALC_BIT_H             : natural := 20;
  constant ALC_ID_FIELD_L        : natural := 21;
  constant ALC_ID_FIELD_H        : natural := 23;

  -- "ALC_ID_FIELD" field enumerated values
  constant ALC_RSVD : std_logic_vector(2 downto 0) := "000";
  constant ALC_BASE_ID : std_logic_vector(2 downto 0) := "001";
  constant ALC_SRR_RTR : std_logic_vector(2 downto 0) := "010";
  constant ALC_IDE : std_logic_vector(2 downto 0) := "011";
  constant ALC_EXTENSION : std_logic_vector(2 downto 0) := "100";
  constant ALC_RTR : std_logic_vector(2 downto 0) := "101";

  -- ALC register reset values
  constant ALC_BIT_RSTVAL : std_logic_vector(4 downto 0) := "00000";
  constant ALC_ID_FIELD_RSTVAL : std_logic_vector(2 downto 0) := "000";

  ------------------------------------------------------------------------------
  -- TS_INFO register
  --
  -- Timestamp integration information
  ------------------------------------------------------------------------------
  constant TS_BITS_L             : natural := 24;
  constant TS_BITS_H             : natural := 29;

  -- TS_INFO register reset values

  ------------------------------------------------------------------------------
  -- TRV_DELAY register
  --
  -- Transmitter delay register. When transmitting CAN FD Frame, Transmitter del
  -- ay is measured. After the measurement (after FDF bit), it can be read out f
  -- rom this register. The value in this register is valid since first transmis
  -- sion of CAN FD frame. After each next measurement the value is updated.
  ------------------------------------------------------------------------------
  constant TRV_DELAY_VALUE_L      : natural := 0;
  constant TRV_DELAY_VALUE_H      : natural := 6;

  -- TRV_DELAY register reset values
  constant TRV_DELAY_VALUE_RSTVAL : std_logic_vector(6 downto 0) := "0000000";

  ------------------------------------------------------------------------------
  -- SSP_CFG register
  --
  -- Secondary sampling point configuration register. Used by transmitter in dat
  -- a bit rate for calculation of Secondary sampling point.
  ------------------------------------------------------------------------------
  constant SSP_OFFSET_L          : natural := 16;
  constant SSP_OFFSET_H          : natural := 23;
  constant SSP_SRC_L             : natural := 24;
  constant SSP_SRC_H             : natural := 25;

  -- "SSP_SRC" field enumerated values
  constant SSP_SRC_MEAS_N_OFFSET : std_logic_vector(1 downto 0) := "00";
  constant SSP_SRC_NO_SSP : std_logic_vector(1 downto 0) := "01";
  constant SSP_SRC_OFFSET : std_logic_vector(1 downto 0) := "10";

  -- SSP_CFG register reset values
  constant SSP_OFFSET_RSTVAL : std_logic_vector(7 downto 0) := x"0A";
  constant SSP_SRC_RSTVAL : std_logic_vector(1 downto 0) := "00";

  ------------------------------------------------------------------------------
  -- RX_FR_CTR register
  --
  ------------------------------------------------------------------------------
  constant RX_FR_CTR_VAL_L        : natural := 0;
  constant RX_FR_CTR_VAL_H       : natural := 31;

  -- RX_FR_CTR register reset values
  constant RX_FR_CTR_VAL_RSTVAL : std_logic_vector(31 downto 0) := x"00000000";

  ------------------------------------------------------------------------------
  -- TX_FR_CTR register
  --
  ------------------------------------------------------------------------------
  constant TX_FR_CTR_VAL_L        : natural := 0;
  constant TX_FR_CTR_VAL_H       : natural := 31;

  -- TX_FR_CTR register reset values
  constant TX_FR_CTR_VAL_RSTVAL : std_logic_vector(31 downto 0) := x"00000000";

  ------------------------------------------------------------------------------
  -- DEBUG_REGISTER register
  --
  -- Register for reading state of the controller. This register is only for deb
  -- ugging purposes!
  ------------------------------------------------------------------------------
  constant STUFF_COUNT_L          : natural := 0;
  constant STUFF_COUNT_H          : natural := 2;
  constant DESTUFF_COUNT_L        : natural := 3;
  constant DESTUFF_COUNT_H        : natural := 5;
  constant PC_ARB_IND             : natural := 6;
  constant PC_CON_IND             : natural := 7;
  constant PC_DAT_IND             : natural := 8;
  constant PC_STC_IND             : natural := 9;
  constant PC_CRC_IND            : natural := 10;
  constant PC_CRCD_IND           : natural := 11;
  constant PC_ACK_IND            : natural := 12;
  constant PC_ACKD_IND           : natural := 13;
  constant PC_EOF_IND            : natural := 14;
  constant PC_INT_IND            : natural := 15;
  constant PC_SUSP_IND           : natural := 16;
  constant PC_OVR_IND            : natural := 17;
  constant PC_SOF_IND            : natural := 18;

  -- DEBUG_REGISTER register reset values
  constant STUFF_COUNT_RSTVAL : std_logic_vector(2 downto 0) := "000";
  constant DESTUFF_COUNT_RSTVAL : std_logic_vector(2 downto 0) := "000";
  constant PC_ARB_RSTVAL      : std_logic := '0';
  constant PC_ACKD_RSTVAL     : std_logic := '0';
  constant PC_ACK_RSTVAL      : std_logic := '0';
  constant PC_CRCD_RSTVAL     : std_logic := '0';
  constant PC_STC_RSTVAL      : std_logic := '0';
  constant PC_CON_RSTVAL      : std_logic := '0';
  constant PC_DAT_RSTVAL      : std_logic := '0';
  constant PC_CRC_RSTVAL      : std_logic := '0';
  constant PC_EOF_RSTVAL      : std_logic := '0';
  constant PC_SUSP_RSTVAL     : std_logic := '0';
  constant PC_SOF_RSTVAL      : std_logic := '0';
  constant PC_OVR_RSTVAL      : std_logic := '0';
  constant PC_INT_RSTVAL      : std_logic := '0';

  ------------------------------------------------------------------------------
  -- YOLO_REG register
  --
  -- Register for fun :)
  ------------------------------------------------------------------------------
  constant YOLO_VAL_L             : natural := 0;
  constant YOLO_VAL_H            : natural := 31;

  -- YOLO_REG register reset values
  constant YOLO_VAL_RSTVAL : std_logic_vector(31 downto 0) := x"DEADBEEF";

  ------------------------------------------------------------------------------
  -- TIMESTAMP_LOW register
  --
  -- Register with current value of CTU CAN FD time base. No shadowing is implem
  -- ented on TIMESTAMP_LOW/HIGH registers and user has to take care of proper r
  -- ead from both registers, since overflow of TIMESTAMP_LOW might occur betwee
  -- n read of TIMESTAMP_LOW and TIMESTAMP_HIGH.
  ------------------------------------------------------------------------------
  constant TIMESTAMP_LOW_L        : natural := 0;
  constant TIMESTAMP_LOW_H       : natural := 31;

  -- TIMESTAMP_LOW register reset values

  ------------------------------------------------------------------------------
  -- TIMESTAMP_HIGH register
  --
  -- Register with current value of CTU CAN FD time base. No shadowing is implem
  -- ented on TIMESTAMP_LOW/HIGH registers and user has to take care of proper r
  -- ead from both registers, since overflow of TIMESTAMP_LOW might occur betwee
  -- n read of TIMESTAMP_LOW and TIMESTAMP_HIGH.
  ------------------------------------------------------------------------------
  constant TIMESTAMP_HIGH_L       : natural := 0;
  constant TIMESTAMP_HIGH_H      : natural := 31;

  -- TIMESTAMP_HIGH register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_1 register
  --
  -- This adress word corresponds to FRAME_FORM word
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_1_L         : natural := 0;
  constant TXTB1_DATA_1_H        : natural := 31;

  -- TXTB1_DATA_1 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_2 register
  --
  -- This adress word corresponds to IDENTIFIER word.
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_2_L         : natural := 0;
  constant TXTB1_DATA_2_H        : natural := 31;

  -- TXTB1_DATA_2 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_3 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_3_L         : natural := 0;
  constant TXTB1_DATA_3_H        : natural := 31;

  -- TXTB1_DATA_3 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_4 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_4_L         : natural := 0;
  constant TXTB1_DATA_4_H        : natural := 31;

  -- TXTB1_DATA_4 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_5 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_5_L         : natural := 0;
  constant TXTB1_DATA_5_H        : natural := 31;

  -- TXTB1_DATA_5 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_6 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_6_L         : natural := 0;
  constant TXTB1_DATA_6_H        : natural := 31;

  -- TXTB1_DATA_6 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_7 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_7_L         : natural := 0;
  constant TXTB1_DATA_7_H        : natural := 31;

  -- TXTB1_DATA_7 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_8 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_8_L         : natural := 0;
  constant TXTB1_DATA_8_H        : natural := 31;

  -- TXTB1_DATA_8 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_9 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_9_L         : natural := 0;
  constant TXTB1_DATA_9_H        : natural := 31;

  -- TXTB1_DATA_9 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_10 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_10_L        : natural := 0;
  constant TXTB1_DATA_10_H       : natural := 31;

  -- TXTB1_DATA_10 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_11 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_11_L        : natural := 0;
  constant TXTB1_DATA_11_H       : natural := 31;

  -- TXTB1_DATA_11 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_12 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_12_L        : natural := 0;
  constant TXTB1_DATA_12_H       : natural := 31;

  -- TXTB1_DATA_12 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_13 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_13_L        : natural := 0;
  constant TXTB1_DATA_13_H       : natural := 31;

  -- TXTB1_DATA_13 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_14 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_14_L        : natural := 0;
  constant TXTB1_DATA_14_H       : natural := 31;

  -- TXTB1_DATA_14 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_15 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_15_L        : natural := 0;
  constant TXTB1_DATA_15_H       : natural := 31;

  -- TXTB1_DATA_15 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_16 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_16_L        : natural := 0;
  constant TXTB1_DATA_16_H       : natural := 31;

  -- TXTB1_DATA_16 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_17 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_17_L        : natural := 0;
  constant TXTB1_DATA_17_H       : natural := 31;

  -- TXTB1_DATA_17 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_18 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_18_L        : natural := 0;
  constant TXTB1_DATA_18_H       : natural := 31;

  -- TXTB1_DATA_18 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_19 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_19_L        : natural := 0;
  constant TXTB1_DATA_19_H       : natural := 31;

  -- TXTB1_DATA_19 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_20 register
  --
  -- This adress word corresponds to DATA_61_64 word.
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_20_L        : natural := 0;
  constant TXTB1_DATA_20_H       : natural := 31;

  -- TXTB1_DATA_20 register reset values

  ------------------------------------------------------------------------------
  -- TXTB1_DATA_21 register
  --
  ------------------------------------------------------------------------------
  constant TXTB1_DATA_21_L        : natural := 0;
  constant TXTB1_DATA_21_H       : natural := 31;

  -- TXTB1_DATA_21 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_1 register
  --
  -- This adress word corresponds to FRAME_FORM word
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_1_L         : natural := 0;
  constant TXTB2_DATA_1_H        : natural := 31;

  -- TXTB2_DATA_1 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_2 register
  --
  -- This adress word corresponds to IDENTIFIER word.
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_2_L         : natural := 0;
  constant TXTB2_DATA_2_H        : natural := 31;

  -- TXTB2_DATA_2 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_3 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_3_L         : natural := 0;
  constant TXTB2_DATA_3_H        : natural := 31;

  -- TXTB2_DATA_3 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_4 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_4_L         : natural := 0;
  constant TXTB2_DATA_4_H        : natural := 31;

  -- TXTB2_DATA_4 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_5 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_5_L         : natural := 0;
  constant TXTB2_DATA_5_H        : natural := 31;

  -- TXTB2_DATA_5 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_6 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_6_L         : natural := 0;
  constant TXTB2_DATA_6_H        : natural := 31;

  -- TXTB2_DATA_6 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_7 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_7_L         : natural := 0;
  constant TXTB2_DATA_7_H        : natural := 31;

  -- TXTB2_DATA_7 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_8 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_8_L         : natural := 0;
  constant TXTB2_DATA_8_H        : natural := 31;

  -- TXTB2_DATA_8 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_9 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_9_L         : natural := 0;
  constant TXTB2_DATA_9_H        : natural := 31;

  -- TXTB2_DATA_9 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_10 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_10_L        : natural := 0;
  constant TXTB2_DATA_10_H       : natural := 31;

  -- TXTB2_DATA_10 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_11 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_11_L        : natural := 0;
  constant TXTB2_DATA_11_H       : natural := 31;

  -- TXTB2_DATA_11 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_12 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_12_L        : natural := 0;
  constant TXTB2_DATA_12_H       : natural := 31;

  -- TXTB2_DATA_12 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_13 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_13_L        : natural := 0;
  constant TXTB2_DATA_13_H       : natural := 31;

  -- TXTB2_DATA_13 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_14 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_14_L        : natural := 0;
  constant TXTB2_DATA_14_H       : natural := 31;

  -- TXTB2_DATA_14 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_15 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_15_L        : natural := 0;
  constant TXTB2_DATA_15_H       : natural := 31;

  -- TXTB2_DATA_15 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_16 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_16_L        : natural := 0;
  constant TXTB2_DATA_16_H       : natural := 31;

  -- TXTB2_DATA_16 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_17 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_17_L        : natural := 0;
  constant TXTB2_DATA_17_H       : natural := 31;

  -- TXTB2_DATA_17 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_18 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_18_L        : natural := 0;
  constant TXTB2_DATA_18_H       : natural := 31;

  -- TXTB2_DATA_18 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_19 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_19_L        : natural := 0;
  constant TXTB2_DATA_19_H       : natural := 31;

  -- TXTB2_DATA_19 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_20 register
  --
  -- This adress word corresponds to DATA_61_64 word.
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_20_L        : natural := 0;
  constant TXTB2_DATA_20_H       : natural := 31;

  -- TXTB2_DATA_20 register reset values

  ------------------------------------------------------------------------------
  -- TXTB2_DATA_21 register
  --
  ------------------------------------------------------------------------------
  constant TXTB2_DATA_21_L        : natural := 0;
  constant TXTB2_DATA_21_H       : natural := 31;

  -- TXTB2_DATA_21 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_1 register
  --
  -- This adress word corresponds to FRAME_FORM word
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_1_L         : natural := 0;
  constant TXTB3_DATA_1_H        : natural := 31;

  -- TXTB3_DATA_1 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_2 register
  --
  -- This adress word corresponds to IDENTIFIER word.
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_2_L         : natural := 0;
  constant TXTB3_DATA_2_H        : natural := 31;

  -- TXTB3_DATA_2 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_3 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_3_L         : natural := 0;
  constant TXTB3_DATA_3_H        : natural := 31;

  -- TXTB3_DATA_3 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_4 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_4_L         : natural := 0;
  constant TXTB3_DATA_4_H        : natural := 31;

  -- TXTB3_DATA_4 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_5 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_5_L         : natural := 0;
  constant TXTB3_DATA_5_H        : natural := 31;

  -- TXTB3_DATA_5 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_6 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_6_L         : natural := 0;
  constant TXTB3_DATA_6_H        : natural := 31;

  -- TXTB3_DATA_6 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_7 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_7_L         : natural := 0;
  constant TXTB3_DATA_7_H        : natural := 31;

  -- TXTB3_DATA_7 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_8 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_8_L         : natural := 0;
  constant TXTB3_DATA_8_H        : natural := 31;

  -- TXTB3_DATA_8 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_9 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_9_L         : natural := 0;
  constant TXTB3_DATA_9_H        : natural := 31;

  -- TXTB3_DATA_9 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_10 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_10_L        : natural := 0;
  constant TXTB3_DATA_10_H       : natural := 31;

  -- TXTB3_DATA_10 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_11 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_11_L        : natural := 0;
  constant TXTB3_DATA_11_H       : natural := 31;

  -- TXTB3_DATA_11 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_12 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_12_L        : natural := 0;
  constant TXTB3_DATA_12_H       : natural := 31;

  -- TXTB3_DATA_12 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_13 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_13_L        : natural := 0;
  constant TXTB3_DATA_13_H       : natural := 31;

  -- TXTB3_DATA_13 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_14 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_14_L        : natural := 0;
  constant TXTB3_DATA_14_H       : natural := 31;

  -- TXTB3_DATA_14 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_15 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_15_L        : natural := 0;
  constant TXTB3_DATA_15_H       : natural := 31;

  -- TXTB3_DATA_15 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_16 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_16_L        : natural := 0;
  constant TXTB3_DATA_16_H       : natural := 31;

  -- TXTB3_DATA_16 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_17 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_17_L        : natural := 0;
  constant TXTB3_DATA_17_H       : natural := 31;

  -- TXTB3_DATA_17 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_18 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_18_L        : natural := 0;
  constant TXTB3_DATA_18_H       : natural := 31;

  -- TXTB3_DATA_18 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_19 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_19_L        : natural := 0;
  constant TXTB3_DATA_19_H       : natural := 31;

  -- TXTB3_DATA_19 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_20 register
  --
  -- This adress word corresponds to DATA_61_64 word.
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_20_L        : natural := 0;
  constant TXTB3_DATA_20_H       : natural := 31;

  -- TXTB3_DATA_20 register reset values

  ------------------------------------------------------------------------------
  -- TXTB3_DATA_21 register
  --
  ------------------------------------------------------------------------------
  constant TXTB3_DATA_21_L        : natural := 0;
  constant TXTB3_DATA_21_H       : natural := 31;

  -- TXTB3_DATA_21 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_1 register
  --
  -- This adress word corresponds to FRAME_FORM word
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_1_L         : natural := 0;
  constant TXTB4_DATA_1_H        : natural := 31;

  -- TXTB4_DATA_1 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_2 register
  --
  -- This adress word corresponds to IDENTIFIER word.
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_2_L         : natural := 0;
  constant TXTB4_DATA_2_H        : natural := 31;

  -- TXTB4_DATA_2 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_3 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_3_L         : natural := 0;
  constant TXTB4_DATA_3_H        : natural := 31;

  -- TXTB4_DATA_3 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_4 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_4_L         : natural := 0;
  constant TXTB4_DATA_4_H        : natural := 31;

  -- TXTB4_DATA_4 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_5 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_5_L         : natural := 0;
  constant TXTB4_DATA_5_H        : natural := 31;

  -- TXTB4_DATA_5 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_6 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_6_L         : natural := 0;
  constant TXTB4_DATA_6_H        : natural := 31;

  -- TXTB4_DATA_6 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_7 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_7_L         : natural := 0;
  constant TXTB4_DATA_7_H        : natural := 31;

  -- TXTB4_DATA_7 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_8 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_8_L         : natural := 0;
  constant TXTB4_DATA_8_H        : natural := 31;

  -- TXTB4_DATA_8 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_9 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_9_L         : natural := 0;
  constant TXTB4_DATA_9_H        : natural := 31;

  -- TXTB4_DATA_9 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_10 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_10_L        : natural := 0;
  constant TXTB4_DATA_10_H       : natural := 31;

  -- TXTB4_DATA_10 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_11 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_11_L        : natural := 0;
  constant TXTB4_DATA_11_H       : natural := 31;

  -- TXTB4_DATA_11 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_12 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_12_L        : natural := 0;
  constant TXTB4_DATA_12_H       : natural := 31;

  -- TXTB4_DATA_12 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_13 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_13_L        : natural := 0;
  constant TXTB4_DATA_13_H       : natural := 31;

  -- TXTB4_DATA_13 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_14 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_14_L        : natural := 0;
  constant TXTB4_DATA_14_H       : natural := 31;

  -- TXTB4_DATA_14 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_15 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_15_L        : natural := 0;
  constant TXTB4_DATA_15_H       : natural := 31;

  -- TXTB4_DATA_15 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_16 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_16_L        : natural := 0;
  constant TXTB4_DATA_16_H       : natural := 31;

  -- TXTB4_DATA_16 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_17 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_17_L        : natural := 0;
  constant TXTB4_DATA_17_H       : natural := 31;

  -- TXTB4_DATA_17 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_18 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_18_L        : natural := 0;
  constant TXTB4_DATA_18_H       : natural := 31;

  -- TXTB4_DATA_18 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_19 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_19_L        : natural := 0;
  constant TXTB4_DATA_19_H       : natural := 31;

  -- TXTB4_DATA_19 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_20 register
  --
  -- This adress word corresponds to DATA_61_64 word.
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_20_L        : natural := 0;
  constant TXTB4_DATA_20_H       : natural := 31;

  -- TXTB4_DATA_20 register reset values

  ------------------------------------------------------------------------------
  -- TXTB4_DATA_21 register
  --
  ------------------------------------------------------------------------------
  constant TXTB4_DATA_21_L        : natural := 0;
  constant TXTB4_DATA_21_H       : natural := 31;

  -- TXTB4_DATA_21 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_1 register
  --
  -- This adress word corresponds to FRAME_FORM word
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_1_L         : natural := 0;
  constant TXTB5_DATA_1_H        : natural := 31;

  -- TXTB5_DATA_1 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_2 register
  --
  -- This adress word corresponds to IDENTIFIER word.
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_2_L         : natural := 0;
  constant TXTB5_DATA_2_H        : natural := 31;

  -- TXTB5_DATA_2 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_3 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_3_L         : natural := 0;
  constant TXTB5_DATA_3_H        : natural := 31;

  -- TXTB5_DATA_3 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_4 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_4_L         : natural := 0;
  constant TXTB5_DATA_4_H        : natural := 31;

  -- TXTB5_DATA_4 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_5 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_5_L         : natural := 0;
  constant TXTB5_DATA_5_H        : natural := 31;

  -- TXTB5_DATA_5 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_6 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_6_L         : natural := 0;
  constant TXTB5_DATA_6_H        : natural := 31;

  -- TXTB5_DATA_6 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_7 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_7_L         : natural := 0;
  constant TXTB5_DATA_7_H        : natural := 31;

  -- TXTB5_DATA_7 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_8 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_8_L         : natural := 0;
  constant TXTB5_DATA_8_H        : natural := 31;

  -- TXTB5_DATA_8 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_9 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_9_L         : natural := 0;
  constant TXTB5_DATA_9_H        : natural := 31;

  -- TXTB5_DATA_9 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_10 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_10_L        : natural := 0;
  constant TXTB5_DATA_10_H       : natural := 31;

  -- TXTB5_DATA_10 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_11 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_11_L        : natural := 0;
  constant TXTB5_DATA_11_H       : natural := 31;

  -- TXTB5_DATA_11 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_12 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_12_L        : natural := 0;
  constant TXTB5_DATA_12_H       : natural := 31;

  -- TXTB5_DATA_12 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_13 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_13_L        : natural := 0;
  constant TXTB5_DATA_13_H       : natural := 31;

  -- TXTB5_DATA_13 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_14 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_14_L        : natural := 0;
  constant TXTB5_DATA_14_H       : natural := 31;

  -- TXTB5_DATA_14 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_15 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_15_L        : natural := 0;
  constant TXTB5_DATA_15_H       : natural := 31;

  -- TXTB5_DATA_15 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_16 register
  --
  -- This adress word corresponds to DATA_61_64 word.
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_16_L        : natural := 0;
  constant TXTB5_DATA_16_H       : natural := 31;

  -- TXTB5_DATA_16 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_17 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_17_L        : natural := 0;
  constant TXTB5_DATA_17_H       : natural := 31;

  -- TXTB5_DATA_17 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_18 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_18_L        : natural := 0;
  constant TXTB5_DATA_18_H       : natural := 31;

  -- TXTB5_DATA_18 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_19 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_19_L        : natural := 0;
  constant TXTB5_DATA_19_H       : natural := 31;

  -- TXTB5_DATA_19 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_20 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_20_L        : natural := 0;
  constant TXTB5_DATA_20_H       : natural := 31;

  -- TXTB5_DATA_20 register reset values

  ------------------------------------------------------------------------------
  -- TXTB5_DATA_21 register
  --
  ------------------------------------------------------------------------------
  constant TXTB5_DATA_21_L        : natural := 0;
  constant TXTB5_DATA_21_H       : natural := 31;

  -- TXTB5_DATA_21 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_1 register
  --
  -- This adress word corresponds to FRAME_FORM word
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_1_L         : natural := 0;
  constant TXTB6_DATA_1_H        : natural := 31;

  -- TXTB6_DATA_1 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_2 register
  --
  -- This adress word corresponds to IDENTIFIER word.
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_2_L         : natural := 0;
  constant TXTB6_DATA_2_H        : natural := 31;

  -- TXTB6_DATA_2 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_3 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_3_L         : natural := 0;
  constant TXTB6_DATA_3_H        : natural := 31;

  -- TXTB6_DATA_3 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_4 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_4_L         : natural := 0;
  constant TXTB6_DATA_4_H        : natural := 31;

  -- TXTB6_DATA_4 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_5 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_5_L         : natural := 0;
  constant TXTB6_DATA_5_H        : natural := 31;

  -- TXTB6_DATA_5 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_6 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_6_L         : natural := 0;
  constant TXTB6_DATA_6_H        : natural := 31;

  -- TXTB6_DATA_6 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_7 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_7_L         : natural := 0;
  constant TXTB6_DATA_7_H        : natural := 31;

  -- TXTB6_DATA_7 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_8 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_8_L         : natural := 0;
  constant TXTB6_DATA_8_H        : natural := 31;

  -- TXTB6_DATA_8 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_9 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_9_L         : natural := 0;
  constant TXTB6_DATA_9_H        : natural := 31;

  -- TXTB6_DATA_9 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_10 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_10_L        : natural := 0;
  constant TXTB6_DATA_10_H       : natural := 31;

  -- TXTB6_DATA_10 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_11 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_11_L        : natural := 0;
  constant TXTB6_DATA_11_H       : natural := 31;

  -- TXTB6_DATA_11 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_12 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_12_L        : natural := 0;
  constant TXTB6_DATA_12_H       : natural := 31;

  -- TXTB6_DATA_12 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_13 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_13_L        : natural := 0;
  constant TXTB6_DATA_13_H       : natural := 31;

  -- TXTB6_DATA_13 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_14 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_14_L        : natural := 0;
  constant TXTB6_DATA_14_H       : natural := 31;

  -- TXTB6_DATA_14 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_15 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_15_L        : natural := 0;
  constant TXTB6_DATA_15_H       : natural := 31;

  -- TXTB6_DATA_15 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_16 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_16_L        : natural := 0;
  constant TXTB6_DATA_16_H       : natural := 31;

  -- TXTB6_DATA_16 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_17 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_17_L        : natural := 0;
  constant TXTB6_DATA_17_H       : natural := 31;

  -- TXTB6_DATA_17 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_18 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_18_L        : natural := 0;
  constant TXTB6_DATA_18_H       : natural := 31;

  -- TXTB6_DATA_18 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_19 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_19_L        : natural := 0;
  constant TXTB6_DATA_19_H       : natural := 31;

  -- TXTB6_DATA_19 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_20 register
  --
  -- This adress word corresponds to DATA_61_64 word.
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_20_L        : natural := 0;
  constant TXTB6_DATA_20_H       : natural := 31;

  -- TXTB6_DATA_20 register reset values

  ------------------------------------------------------------------------------
  -- TXTB6_DATA_21 register
  --
  ------------------------------------------------------------------------------
  constant TXTB6_DATA_21_L        : natural := 0;
  constant TXTB6_DATA_21_H       : natural := 31;

  -- TXTB6_DATA_21 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_1 register
  --
  -- This adress word corresponds to FRAME_FORM word
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_1_L         : natural := 0;
  constant TXTB7_DATA_1_H        : natural := 31;

  -- TXTB7_DATA_1 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_2 register
  --
  -- This adress word corresponds to IDENTIFIER word.
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_2_L         : natural := 0;
  constant TXTB7_DATA_2_H        : natural := 31;

  -- TXTB7_DATA_2 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_3 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_3_L         : natural := 0;
  constant TXTB7_DATA_3_H        : natural := 31;

  -- TXTB7_DATA_3 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_4 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_4_L         : natural := 0;
  constant TXTB7_DATA_4_H        : natural := 31;

  -- TXTB7_DATA_4 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_5 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_5_L         : natural := 0;
  constant TXTB7_DATA_5_H        : natural := 31;

  -- TXTB7_DATA_5 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_6 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_6_L         : natural := 0;
  constant TXTB7_DATA_6_H        : natural := 31;

  -- TXTB7_DATA_6 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_7 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_7_L         : natural := 0;
  constant TXTB7_DATA_7_H        : natural := 31;

  -- TXTB7_DATA_7 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_8 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_8_L         : natural := 0;
  constant TXTB7_DATA_8_H        : natural := 31;

  -- TXTB7_DATA_8 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_9 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_9_L         : natural := 0;
  constant TXTB7_DATA_9_H        : natural := 31;

  -- TXTB7_DATA_9 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_10 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_10_L        : natural := 0;
  constant TXTB7_DATA_10_H       : natural := 31;

  -- TXTB7_DATA_10 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_11 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_11_L        : natural := 0;
  constant TXTB7_DATA_11_H       : natural := 31;

  -- TXTB7_DATA_11 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_12 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_12_L        : natural := 0;
  constant TXTB7_DATA_12_H       : natural := 31;

  -- TXTB7_DATA_12 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_13 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_13_L        : natural := 0;
  constant TXTB7_DATA_13_H       : natural := 31;

  -- TXTB7_DATA_13 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_14 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_14_L        : natural := 0;
  constant TXTB7_DATA_14_H       : natural := 31;

  -- TXTB7_DATA_14 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_15 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_15_L        : natural := 0;
  constant TXTB7_DATA_15_H       : natural := 31;

  -- TXTB7_DATA_15 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_16 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_16_L        : natural := 0;
  constant TXTB7_DATA_16_H       : natural := 31;

  -- TXTB7_DATA_16 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_17 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_17_L        : natural := 0;
  constant TXTB7_DATA_17_H       : natural := 31;

  -- TXTB7_DATA_17 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_18 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_18_L        : natural := 0;
  constant TXTB7_DATA_18_H       : natural := 31;

  -- TXTB7_DATA_18 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_19 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_19_L        : natural := 0;
  constant TXTB7_DATA_19_H       : natural := 31;

  -- TXTB7_DATA_19 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_20 register
  --
  -- This adress word corresponds to DATA_61_64 word.
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_20_L        : natural := 0;
  constant TXTB7_DATA_20_H       : natural := 31;

  -- TXTB7_DATA_20 register reset values

  ------------------------------------------------------------------------------
  -- TXTB7_DATA_21 register
  --
  ------------------------------------------------------------------------------
  constant TXTB7_DATA_21_L        : natural := 0;
  constant TXTB7_DATA_21_H       : natural := 31;

  -- TXTB7_DATA_21 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_1 register
  --
  -- This adress word corresponds to FRAME_FORM word
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_1_L         : natural := 0;
  constant TXTB8_DATA_1_H        : natural := 31;

  -- TXTB8_DATA_1 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_2 register
  --
  -- This adress word corresponds to IDENTIFIER word.
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_2_L         : natural := 0;
  constant TXTB8_DATA_2_H        : natural := 31;

  -- TXTB8_DATA_2 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_3 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_3_L         : natural := 0;
  constant TXTB8_DATA_3_H        : natural := 31;

  -- TXTB8_DATA_3 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_4 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_4_L         : natural := 0;
  constant TXTB8_DATA_4_H        : natural := 31;

  -- TXTB8_DATA_4 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_5 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_5_L         : natural := 0;
  constant TXTB8_DATA_5_H        : natural := 31;

  -- TXTB8_DATA_5 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_6 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_6_L         : natural := 0;
  constant TXTB8_DATA_6_H        : natural := 31;

  -- TXTB8_DATA_6 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_7 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_7_L         : natural := 0;
  constant TXTB8_DATA_7_H        : natural := 31;

  -- TXTB8_DATA_7 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_8 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_8_L         : natural := 0;
  constant TXTB8_DATA_8_H        : natural := 31;

  -- TXTB8_DATA_8 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_9 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_9_L         : natural := 0;
  constant TXTB8_DATA_9_H        : natural := 31;

  -- TXTB8_DATA_9 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_10 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_10_L        : natural := 0;
  constant TXTB8_DATA_10_H       : natural := 31;

  -- TXTB8_DATA_10 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_11 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_11_L        : natural := 0;
  constant TXTB8_DATA_11_H       : natural := 31;

  -- TXTB8_DATA_11 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_12 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_12_L        : natural := 0;
  constant TXTB8_DATA_12_H       : natural := 31;

  -- TXTB8_DATA_12 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_13 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_13_L        : natural := 0;
  constant TXTB8_DATA_13_H       : natural := 31;

  -- TXTB8_DATA_13 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_14 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_14_L        : natural := 0;
  constant TXTB8_DATA_14_H       : natural := 31;

  -- TXTB8_DATA_14 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_15 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_15_L        : natural := 0;
  constant TXTB8_DATA_15_H       : natural := 31;

  -- TXTB8_DATA_15 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_16 register
  --
  -- This adress word corresponds to DATA_61_64 word.
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_16_L        : natural := 0;
  constant TXTB8_DATA_16_H       : natural := 31;

  -- TXTB8_DATA_16 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_17 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_17_L        : natural := 0;
  constant TXTB8_DATA_17_H       : natural := 31;

  -- TXTB8_DATA_17 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_18 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_18_L        : natural := 0;
  constant TXTB8_DATA_18_H       : natural := 31;

  -- TXTB8_DATA_18 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_19 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_19_L        : natural := 0;
  constant TXTB8_DATA_19_H       : natural := 31;

  -- TXTB8_DATA_19 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_20 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_20_L        : natural := 0;
  constant TXTB8_DATA_20_H       : natural := 31;

  -- TXTB8_DATA_20 register reset values

  ------------------------------------------------------------------------------
  -- TXTB8_DATA_21 register
  --
  ------------------------------------------------------------------------------
  constant TXTB8_DATA_21_L        : natural := 0;
  constant TXTB8_DATA_21_H       : natural := 31;

  -- TXTB8_DATA_21 register reset values

  ------------------------------------------------------------------------------
  -- TST_CONTROL register
  --
  -- Testability control register. Contains configuration of test functions.
  ------------------------------------------------------------------------------
  constant TMAENA_IND             : natural := 0;
  constant TWRSTB_IND             : natural := 1;

  -- TST_CONTROL register reset values

  ------------------------------------------------------------------------------
  -- TST_DEST register
  --
  ------------------------------------------------------------------------------
  constant TST_ADDR_L             : natural := 0;
  constant TST_ADDR_H            : natural := 15;
  constant TST_MTGT_L            : natural := 16;
  constant TST_MTGT_H            : natural := 19;

  -- "TST_MTGT" field enumerated values
  constant TMTGT_NONE : std_logic_vector(3 downto 0) := x"0";
  constant TMTGT_RXBUF : std_logic_vector(3 downto 0) := x"1";
  constant TMTGT_TXTBUF1 : std_logic_vector(3 downto 0) := x"2";
  constant TMTGT_TXTBUF2 : std_logic_vector(3 downto 0) := x"3";
  constant TMTGT_TXTBUF3 : std_logic_vector(3 downto 0) := x"4";
  constant TMTGT_TXTBUF4 : std_logic_vector(3 downto 0) := x"5";
  constant TMTGT_TXTBUF5 : std_logic_vector(3 downto 0) := x"6";
  constant TMTGT_TXTBUF6 : std_logic_vector(3 downto 0) := x"7";
  constant TMTGT_TXTBUF7 : std_logic_vector(3 downto 0) := x"8";
  constant TMTGT_TXTBUF8 : std_logic_vector(3 downto 0) := x"9";

  -- TST_DEST register reset values

  ------------------------------------------------------------------------------
  -- TST_WDATA register
  --
  ------------------------------------------------------------------------------
  constant TST_WDATA_L            : natural := 0;
  constant TST_WDATA_H           : natural := 31;

  -- TST_WDATA register reset values

  ------------------------------------------------------------------------------
  -- TST_RDATA register
  --
  ------------------------------------------------------------------------------
  constant TST_RDATA_L            : natural := 0;
  constant TST_RDATA_H           : natural := 31;

  -- TST_RDATA register reset values

end package;
