// Based on dialogs from iemguis in Pd Vanilla (by Tim Schoen & Porres)

sys_gui("\n"
"namespace eval ::dialog_knob:: {\n"
"}\n"
// arrays to store per-dialog values
"array set ::dialog_knob::var_size {} ;\n"
"array set ::dialog_knob::var_square {} ;\n"
"\n"
"array set ::dialog_knob::var_showarc {} ;\n"
"array set ::dialog_knob::var_arcstart {} ;\n"
"\n"
"array set ::dialog_knob::var_loadbang {} ;\n"
"array set ::dialog_knob::var_savestate {} ;\n"
"array set ::dialog_knob::var_load {} ;\n"
"\n"
"array set ::dialog_knob::var_discrete {} ;\n"
"array set ::dialog_knob::var_showticks {} ;\n"
"array set ::dialog_knob::var_steps {} ;\n"
"\n"
"array set ::dialog_knob::var_angle_width {} ;\n"
"array set ::dialog_knob::var_angle_offset {} ;\n"
"\n"
"array set ::dialog_knob::var_lower {} ;\n"
"array set ::dialog_knob::var_upper {} ;\n"
"\n"
"array set ::dialog_knob::var_expmode {} ;\n"
"array set ::dialog_knob::var_exp {} ;\n"
"\n"
"array set ::dialog_knob::var_readonly {} ;\n"
"array set ::dialog_knob::var_jump {} ;\n"
"array set ::dialog_knob::var_circular {} ;\n"
"\n"
"array set ::dialog_knob::var_nmode {} ;\n"
"array set ::dialog_knob::var_n_size {} ;\n"
"array set ::dialog_knob::var_xpos {} ;\n"
"array set ::dialog_knob::var_ypos {} ;\n"
"\n"
"array set ::dialog_knob::var_rcv {} ;\n"
"array set ::dialog_knob::var_snd {} ;\n"
"array set ::dialog_knob::var_prm {} ;\n"
"array set ::dialog_knob::var_var {} ;\n"
"\n"
"array set ::dialog_knob::var_color_bg {} ;\n"
"array set ::dialog_knob::var_color_fg {} ;\n"
"array set ::dialog_knob::var_color_arc {} ;\n"
"array set ::dialog_knob::var_colorradio {} ;\n" // radio for what color type we're setting
"\n"

// ------------------------------------------------------------------------------------------------
// Get parameters from Pd when asking for properties!

"proc knob_dialog {id \\\n"
"         size square \\\n"
"         show_arc arcstart \\\n"
"         loadbang savestate load \\\n"
"         discrete showticks steps \\\n"
"         angle_range angle_offset \\\n"
"         lower upper expmode exp \\\n"
"         readonly jump circular \\\n"
"         n_mode n_size xpos ypos \\\n"
"         rcv snd prm var \\\n"
"         bcol acol fcol} {\n"
// The vid indicates the instance ID of this dialog
"    set vid [string trimleft $id .]\n"
// initialize the array with received values for this dialog instance
"    set ::dialog_knob::var_size($vid) $size \n"
"    set ::dialog_knob::var_square($vid) $square \n"
"    set ::dialog_knob::var_showarc($vid) $show_arc \n"
"    set ::dialog_knob::var_arcstart($vid) $arcstart \n"
"    set ::dialog_knob::var_loadbang($vid) $loadbang \n"
"    set ::dialog_knob::var_savestate($vid) $savestate \n"
"    set ::dialog_knob::var_load($vid) $load \n"
"    set ::dialog_knob::var_discrete($vid) $discrete \n"
"    set ::dialog_knob::var_showticks($vid) $showticks \n"
"    set ::dialog_knob::var_steps($vid) $steps \n"
"    set ::dialog_knob::var_angle_width($vid) $angle_range \n"
"    set ::dialog_knob::var_angle_offset($vid) $angle_offset \n"
"    set ::dialog_knob::var_lower($vid) $lower \n"
"    set ::dialog_knob::var_upper($vid) $upper \n"
"    set ::dialog_knob::var_expmode($vid) $expmode \n"
"    set ::dialog_knob::var_exp($vid) $exp \n"
"    set ::dialog_knob::var_readonly($vid) $readonly \n"
"    set ::dialog_knob::var_jump($vid) $jump \n"
"    set ::dialog_knob::var_circular($vid) $circular\n"
"    set ::dialog_knob::var_nmode($vid) [string map {{\\ } \" \"} $n_mode]\n"
"    set ::dialog_knob::var_n_size($vid) $n_size\n"
"    set ::dialog_knob::var_xpos($vid) $xpos\n"
"    set ::dialog_knob::var_ypos($vid) $ypos\n"
"\n" // attached symbols
"    set rcv [::pdtk_text::unescape $rcv]\n"
"    set snd [::pdtk_text::unescape $snd]\n"
"    set prm [::pdtk_text::unescape $prm]\n"
"    set var [::pdtk_text::unescape $var]\n"
"    if {$rcv==\"empty\"} {\n"
"       set rcv \"\"\n"
"    }\n"
"    if {$snd==\"empty\"} {\n"
"       set snd \"\"\n"
"    }\n"
"    if {$prm==\"empty\"} {\n"
"       set prm \"\"\n"
"    }\n"
"    if {$var==\"empty\"} {\n"
"       set var \"\"\n"
"    }\n"
"\n"
"    set ::dialog_knob::var_rcv($vid) [string map {{\\ } \" \"} $rcv]\n"
"    set ::dialog_knob::var_snd($vid) [string map {{\\ } \" \"} $snd]\n"
"    set ::dialog_knob::var_prm($vid) [string map {{\\ } \" \"} $prm]\n"
"    set ::dialog_knob::var_var($vid) [string map {{\\ } \" \"} $var]\n"
"\n" // colors
"    set ::dialog_knob::var_color_bg($vid) $bcol\n"
"    set ::dialog_knob::var_color_fg($vid) $fcol\n"
"    set ::dialog_knob::var_color_arc($vid) $acol\n"
"    set ::dialog_knob::var_colorradio($vid) 0\n" // init to 'bg'
"\n"

// ------------------------------------------------------------------------------------------------
        
// HELPER PROCEDURES/FUNCTIONS:
"proc ::dialog_knob::clip {val min {max {}}} {\n"
"    if {$min ne {} && $val < $min} {return $min}\n"
"    if {$max ne {} && $val > $max} {return $max}\n"
"    return $val\n"
"}\n"
"\n"
        
"proc ::dialog_knob::applymacos {id} {\n"
"    if {$::windowingsystem eq \"aqua\"} {\n"
"        ::dialog_knob::apply $id\n"
"    }\n"
"}\n"
"\n"

"proc ::dialog_knob::centerText {text} {\n" // center text by padding
"    set pad [expr {(7 - [string length $text]) / 2}]\n"
"    return [format \"%*s%s%*s\" $pad \"\" $text $pad \"\"]\n"
"}\n"
        
"proc ::dialog_knob::menucheck {option id} {\n"
"    set centeredText [::dialog_knob::centerText $option]\n"
"    $id.num.show.mb configure -text $centeredText\n"
"    ::dialog_knob::applymacos $id\n"
"}\n"
"\n"
        
"proc ::dialog_knob::savestate_check {id} {\n"
"    set vid [string trimleft $id .]\n"
"    if { $::dialog_knob::var_savestate($vid) == 1 } {\n"
"       $id.load.load.ent configure -state disabled\n"
"    } else {\n"
"       $id.load.load.ent configure -state normal\n"
"    }\n"
"}\n"
"\n"
        
"proc ::dialog_knob::discrete_check {id} {\n"
"    set vid [string trimleft $id .]\n"
"    if { $::dialog_knob::var_discrete($vid) == 0 && $::dialog_knob::var_showticks($vid) == 0 } {\n"
"       $id.discrete.steps.ent configure -state disabled\n"
"    } else {\n"
"       $id.discrete.steps.ent configure -state normal\n"
"    }\n"
"}\n"
"\n"
        
"proc ::dialog_knob::ticks_check {id} {\n"
"    set vid [string trimleft $id .]\n"
"    if { $::dialog_knob::var_discrete($vid) == 0 && $::dialog_knob::var_showticks($vid) == 0 } {\n"
"       $id.discrete.steps.ent configure -state disabled\n"
"    } else {\n"
"       $id.discrete.steps.ent configure -state normal\n"
"    }\n"
"    ::dialog_knob::applymacos $id\n"
"}\n"
"\n"

"proc ::dialog_knob::readonly_check {id} {\n"
"    set vid [string trimleft $id .]\n"
"    if { $::dialog_knob::var_readonly($vid) == 1 } {\n"
"       $id.mouse.jump.ent configure -state disabled\n"
"       $id.mouse.move.ent configure -state disabled\n"
"    } else {\n"
"       $id.mouse.jump.ent configure -state normal\n"
"       $id.mouse.move.ent configure -state normal\n"
"    }\n"
"}\n"
"\n"
        
// ----------------------------------------------------------------------------------------------------

// DRAW PROPERTIES' WINDOW:
        
// Initialize creation/drawing of properties window
"    toplevel $id -class DialogWindow\n"
"    wm title $id {[knob] Properties}\n"
"    wm group $id .\n"
"    wm resizable $id 0 0\n" // ???
"    wm transient $id $::focused_window\n"
"    $id configure -menu $::dialog_menubar\n"
"    $id configure -padx 0 -pady 0\n"
"    ::pd_bindings::dialog_bindings $id \"knob\"\n"
"\n"

// Draw frames: Start 'dummy'
//        "    labelframe $id.dummy\n"
//        "    pack $id.dummy -side top -fill x\n"
//        "    $id.dummy config -borderwidth 1 -pady 4 -padx 60\n"
// 'basic' (Size and Square)
"    frame $id.basic -padx 20 -pady 8\n"
        // Size
"    frame $id.basic.dim \n"
"    label $id.basic.dim.w_lab -text \"Size:\"\n"
"    entry $id.basic.dim.w_ent -textvariable ::dialog_knob::var_size($vid) -width 4\n"
"    pack $id.basic.dim.w_lab $id.basic.dim.w_ent -side left\n"
        // Squared Outline (Checkbox)
"    frame $id.basic.square\n"
"    label $id.basic.square.lab -text [_ \"Squared Mode: \"]\n"
"    checkbutton $id.basic.square.ent -variable ::dialog_knob::var_square($vid) -width 5\\\n"
"       -command \"::dialog_knob::applymacos $id\"\n"
"    pack $id.basic.square.ent $id.basic.square.lab -side right -anchor e\n"
        // Align items to grid
"    pack $id.basic -side top -fill x\n"
        // column 0
"    grid $id.basic.dim -row 0 -column 0 -sticky e -padx {60 0}\n"
        // column 1
"    grid $id.basic.square -row 0 -column 1 -sticky e -padx {60 0}\n"
"\n"
// Frame for Arc settings
"    labelframe $id.arcsettings\n"
"    pack $id.arcsettings -side top -fill x\n"
"    $id.arcsettings config -borderwidth 1 -pady 4\n"
        // Arc Checkbox
"    frame $id.arcsettings.arc\n"
"    label $id.arcsettings.arc.lab -text [_ \"Show Arc: \"]\n"
"    checkbutton $id.arcsettings.arc.ent -variable ::dialog_knob::var_showarc($vid) -width 5\\\n"
"       -command \"::dialog_knob::applymacos $id\"\n"
"    pack $id.arcsettings.arc.ent $id.arcsettings.arc.lab -side right -anchor e\n"
        // Entry for Arc start value
"    frame $id.arcsettings.arcstart \n"
"    label $id.arcsettings.arcstart.lab -text [_ \"Arc Start Value: \"]\n"
"    entry $id.arcsettings.arcstart.ent -textvariable ::dialog_knob::var_arcstart($vid) -width 6\n"
"    pack $id.arcsettings.arcstart.ent $id.arcsettings.arcstart.lab -side right -anchor e\n"
        // Position of items
"    pack $id.arcsettings.arc $id.arcsettings.arcstart -side left -anchor center\n"
"    $id.arcsettings config -padx 60\n"
"\n"
        
// Frame for Load settings
"    labelframe $id.load\n"
"    pack $id.load -side top -fill x\n"
"    $id.load config -borderwidth 1 -pady 5\n"
        // Checkbox for Loadbang
"    frame $id.load.loadbang\n"
"    label $id.load.loadbang.lab -text [_ \"Loadbang: \"]\n"
"    checkbutton $id.load.loadbang.ent -variable ::dialog_knob::var_loadbang($vid) -width 5\n"
"    pack $id.load.loadbang.ent $id.load.loadbang.lab -side right -anchor e\n"
        // Checkbox for Savestate
"    frame $id.load.savestate\n"
"    label $id.load.savestate.lab -text [_ \"Savestate: \"]\n"
"    checkbutton $id.load.savestate.ent -variable ::dialog_knob::var_savestate($vid) -width 5\\\n"
"        -command [concat ::dialog_knob::savestate_check $id]\n"
"    pack $id.load.savestate.ent $id.load.savestate.lab -side right -anchor e\n"
        // Entry for load value
"    frame $id.load.load \n"
"    label $id.load.load.lab -text [_ \"Load Value\"]\n"
"    entry $id.load.load.ent -textvariable ::dialog_knob::var_load($vid) -width 7 -state normal\n"
"    pack $id.load.load.ent $id.load.load.lab -side right -anchor e\n"
        // When savestate is selected, disbale load box
"    if { $::dialog_knob::var_savestate($vid) == 1 } {\n"
"       $id.load.load.ent configure -state disabled\n"
"    }\n"
        // Position of items
"    pack $id.load.loadbang $id.load.savestate $id.load.load -side left -anchor center\n"        
"    $id.load config -padx 20\n"
"\n"
// Frame for discrete section
"    labelframe $id.discrete\n"
"    pack $id.discrete -side top -fill x\n"
"    $id.discrete config -borderwidth 1 -pady 8\n"
        // Checkbox for discrete mode
"    frame $id.discrete.mode\n"
"    label $id.discrete.mode.lab -text [_ \"Discrete mode: \"]\n"
"    checkbutton $id.discrete.mode.ent -variable ::dialog_knob::var_discrete($vid) -width 5\\\n"
"        -command [concat ::dialog_knob::discrete_check $id]\n"
"    pack $id.discrete.mode.ent $id.discrete.mode.lab -side right -anchor e\n"
        // Checkbox for show ticks
"    frame $id.discrete.ticks\n"
"    label $id.discrete.ticks.lab -text [_ \"Show ticks: \"]\n"
"    checkbutton $id.discrete.ticks.ent -variable ::dialog_knob::var_showticks($vid) -width 5\\\n"
"        -command [concat ::dialog_knob::ticks_check $id]\n"
"    pack $id.discrete.ticks.ent $id.discrete.ticks.lab -side right -anchor e\n"
        // Entry for number of steps
"    frame $id.discrete.steps\n"
"    label $id.discrete.steps.lab -text [_ \"Steps: \"]\n"
"    entry $id.discrete.steps.ent -textvariable ::dialog_knob::var_steps($vid) -width 3\n"
"    pack $id.discrete.steps.ent $id.discrete.steps.lab -side right -anchor e\n"
        // When discrete and ticks aren't checked, disable steps box
"    if { $::dialog_knob::var_discrete($vid) == 0 && $::dialog_knob::var_showticks($vid) == 0 } {\n"
"       $id.discrete.steps.ent configure -state disabled\n"
"    }\n"
        // Position of items
"    pack $id.discrete.mode $id.discrete.ticks $id.discrete.steps -side left -anchor center\n"
"    $id.discrete config -padx 30\n"
"\n"
// Frame for Angle entry
"    labelframe $id.angle\n"
"    pack $id.angle -side top -fill x\n"
"    $id.angle config -borderwidth 1 -pady 8\n"
        // Range entry
"    frame $id.angle.range\n"
"    label $id.angle.range.lab -text [_ \"Angular Range: \"]\n"
"    entry $id.angle.range.ent -textvariable ::dialog_knob::var_angle_width($vid) -width 5\n"
"    label $id.angle.range.dummy -text \"\" -width 1\n"
"    pack $id.angle.range.dummy $id.angle.range.ent $id.angle.range.lab -side right -anchor e\n"
        // Offset entry
"    frame $id.angle.offset\n"
"    label $id.angle.offset.lab -text [_ \"Angular Offset: \"]\n"
"    entry $id.angle.offset.ent -textvariable ::dialog_knob::var_angle_offset($vid) -width 5\n"
"    pack $id.angle.offset.ent $id.angle.offset.lab -side right -anchor w\n"
//
"    pack $id.angle.range $id.angle.offset -side left -anchor center\n"
"    $id.angle config -padx 60\n"
"\n"
// Frame for output range section
"    labelframe $id.rng\n"
"    pack $id.rng -side top -fill x\n"
"    $id.rng config -borderwidth 1 -pady 8 -text \"Range settings:\"\n"
        // Range minimum entry
"    frame $id.rng.range \n"
"    frame $id.rng.range.min\n"
"    label $id.rng.range.min.lab -text \"Lower:\"\n"
"    entry $id.rng.range.min.ent -textvariable ::dialog_knob::var_lower($vid) -width 7\n"
"    label $id.rng.range.dummy -text \"\" -width 1\n"
        // Range maximum entry
"    label $id.rng.range.max_lab -text \"Upper:\"\n"
"    entry $id.rng.range.max_ent -textvariable ::dialog_knob::var_upper($vid) -width 7\n"
"    pack $id.rng.range.min\n"
"    pack $id.rng.range.min.lab $id.rng.range.min.ent -side left \n"
"    $id.rng config -padx 26\n"
"    pack configure $id.rng.range.min -side left\n"
"    pack $id.rng.range.dummy $id.rng.range.max_lab $id.rng.range.max_ent -side left\n"
        // Logmode radiobuttons
"    frame $id.rng.logmode\n"
"    radiobutton $id.rng.logmode.radio0 -value 0 \\\n"
"        -text [_ \"linear\" ] \\\n"
"        -variable ::dialog_knob::var_expmode($vid) \\\n"
"        -command \"$id.rng.logmode.expmode_entry configure -state disabled\"\n"
"    radiobutton $id.rng.logmode.radio1 -value 1 \\\n"
"        -text [_ \"log\" ] \\\n"
"        -variable ::dialog_knob::var_expmode($vid) \\\n"
"        -command \"$id.rng.logmode.expmode_entry configure -state disabled\"\n"
"    radiobutton $id.rng.logmode.radio2 -value 2 \\\n"
"        -text [_ \"exp:\" ] \\\n"
"        -variable ::dialog_knob::var_expmode($vid) \\\n"
"        -command \"$id.rng.logmode.expmode_entry configure -state normal\"\n"
"    entry $id.rng.logmode.expmode_entry -width 3 -textvariable ::dialog_knob::var_exp($vid) \n"
        // When exp is selected, enable text box
"    if { $::dialog_knob::var_expmode($vid) != 2 } {\n"
"       $id.rng.logmode.expmode_entry configure -state disabled\n"
"    }\n"
//
"    pack $id.rng.logmode.expmode_entry $id.rng.logmode.radio2 $id.rng.logmode.radio1 $id.rng.logmode.radio0 -side right \n"
"    pack $id.rng.range $id.rng.logmode -side top\n"
"\n"
// Frame for Mouse/Click behaviour (Read Only / Jump on click / Circular motion)
"    labelframe $id.mouse\n"
"    pack $id.mouse -side top -fill x\n"
"    $id.mouse config -borderwidth 1 -pady 8 -text \"Mouse/Click behaviour:\"\n"
        // Checkbox for Read Only
"    frame $id.mouse.readonly\n"
"    label $id.mouse.readonly.lab -text [_ \"Read Only: \"]\n"
"    checkbutton $id.mouse.readonly.ent -variable ::dialog_knob::var_readonly($vid) -width 5\\\n"
"        -command [concat ::dialog_knob::readonly_check $id]\n"
"    pack $id.mouse.readonly.ent $id.mouse.readonly.lab -side right -anchor e\n"
        // Checkbox for Jump on Click
"    frame $id.mouse.jump\n"
"    label $id.mouse.jump.lab -text [_ \"Jump on Click: \"]\n"
"    checkbutton $id.mouse.jump.ent -variable ::dialog_knob::var_jump($vid) -width 5\n"
"    pack $id.mouse.jump.ent $id.mouse.jump.lab -side right -anchor e\n"
        // Checkbox for Circular
"    frame $id.mouse.move\n"
"    label $id.mouse.move.lab -text [_ \"Circular Drag: \"]\n"
"    checkbutton $id.mouse.move.ent -variable ::dialog_knob::var_circular($vid) -width 5\n"
"    pack $id.mouse.move.ent $id.mouse.move.lab -side right -anchor e\n"
// When read only is selected, disbale jump/circular
"    if { $::dialog_knob::var_readonly($vid) == 1 } {\n"
"       $id.mouse.jump.ent configure -state disabled\n"
"       $id.mouse.move.ent configure -state disabled\n"
"    }\n"
        // Position of items
"    pack $id.mouse.readonly $id.mouse.jump $id.mouse.move -side left -anchor center\n"
"    $id.mouse config -padx 30\n"
"\n"
// Frame for Number settings
"    labelframe $id.num\n"
"    pack $id.num -side top -fill x\n"
"    $id.num config -borderwidth 1 -pady 8 -text \"Number settings:\"\n"
    // Dropdown menu for show number mode:
"    frame $id.num.show\n"
"    label $id.num.show.lab -text [_ \"Mode: \"]\n"
"   menubutton $id.num.show.mb -text [::dialog_knob::centerText $::dialog_knob::var_nmode($vid)] \\\n"
"       -menu $id.num.show.mb.menu -width 7\n"
"   menu $id.num.show.mb.menu -tearoff 0\n"
"   $id.num.show.mb configure -menu $id.num.show.mb.menu\n"
    // Add radiobuttons using foreach
"   set nmodes { Never Always Active Typing }\n"
"   foreach mode_selection $nmodes {\n"
"       $id.num.show.mb.menu add radiobutton -label $mode_selection \\\n"
"           -variable ::dialog_knob::var_nmode($vid) -value $mode_selection \\\n"
"           -command \"::dialog_knob::menucheck $mode_selection $id\"\n"
"   }\n"
"    pack $id.num.show.lab $id.num.show.mb -side left\n"
        // Number Size:
"    frame $id.num.size\n"
"    label $id.num.size.lab -text [_ \"Size: \"]\n"
"    entry $id.num.size.ent -textvariable ::dialog_knob::var_n_size($vid) -width 3\n"
"    pack $id.num.size.ent $id.num.size.lab -side right -anchor w\n"
        // Number xpos:
"    frame $id.num.xpos\n"
"    label $id.num.xpos.lab -text [_ \"Xpos: \"]\n"
"    entry $id.num.xpos.ent -textvariable ::dialog_knob::var_xpos($vid) -width 4\n"
"    pack $id.num.xpos.ent $id.num.xpos.lab -side right -anchor e\n"
        // Number ypos:
"    frame $id.num.ypos\n"
"    label $id.num.ypos.lab -text [_ \"Ypos: \"]\n"
"    entry $id.num.ypos.ent -textvariable ::dialog_knob::var_ypos($vid) -width 4\n"
"    pack $id.num.ypos.ent $id.num.ypos.lab -side right -anchor w\n"
"    pack $id.num.show $id.num.size -side left -anchor center\n"
"    pack $id.num.xpos $id.num.ypos -side left -anchor center\n"
        
"    $id.num config -padx 35\n"
"\n"
// Frame for attached symbols
"    labelframe $id.syms -borderwidth 1 -padx 5 -pady 8 -text [_ \"Attached symbols: \"]\n"
"    pack $id.syms -side top -fill x\n"
        // Receive
"    frame $id.syms.receive \n"
"    label $id.syms.receive.w_lab -text \"Receive:\"\n"
"    entry $id.syms.receive.w_ent -textvariable ::dialog_knob::var_rcv($vid) -width 15\n"
"    if { $rcv ne \"norcvno\" } {\n"
"        pack $id.syms.receive.w_lab $id.syms.receive.w_ent -side left\\\n"
"            -fill x -expand 1\n"
"    }\n"
        // Send
"    frame $id.syms.send \n"
"    label $id.syms.send.w_lab -text \"Send:\"\n"
"    entry $id.syms.send.w_ent -textvariable ::dialog_knob::var_snd($vid) -width 15\n"
"    if { $snd ne \"nosndno\" } {\n"
"        pack $id.syms.send.w_lab $id.syms.send.w_ent -side left\\\n"
"            -fill x -expand 1\n"
"    }\n"
        // Param
"    frame $id.syms.param \n"
"    label $id.syms.param.w_lab -text \"Param:\"\n"
"    entry $id.syms.param.w_ent -textvariable ::dialog_knob::var_prm($vid) -width 15\n"
"    if { $prm ne \"noprmno\" } {\n"
"        pack $id.syms.param.w_lab $id.syms.param.w_ent -side left\\\n"
"            -fill x -expand 1\n"
"    }\n"
        // Var
"    frame $id.syms.var \n"
"    label $id.syms.var.w_lab -text \"Variable:\"\n"
"    entry $id.syms.var.w_ent -textvariable ::dialog_knob::var_var($vid) -width 15\n"
"    if { $var ne \"novarno\" } {\n"
"        pack $id.syms.var.w_lab $id.syms.var.w_ent -side left\\\n"
"            -fill x -expand 1\n"
"    }\n"
        // Align items to grid
"    pack $id.syms -side top -fill x\n"
        // column 0
"    grid $id.syms.receive -row 0 -column 0 -sticky e -padx {10 0}\n"
"    grid $id.syms.send -row 1 -column 0 -sticky e -padx {10 0}\n"
        // column 1
"    grid $id.syms.param -row 0 -column 1 -sticky e -padx {5 0}\n"
"    grid $id.syms.var -row 1 -column 1 -sticky e -padx {5 0}\n"
"\n"
// Frame for colors section
"    labelframe $id.colors -borderwidth 1 -text [_ \"Colors:\"] -padx 5 -pady 8\n"
"    pack $id.colors -fill x\n"
        // Color Radiobuttons and "Compose" button
"    frame $id.colors.radio\n"
"    pack $id.colors.radio -side top\n"
"    radiobutton $id.colors.radio.bg -value 0 -variable ::dialog_knob::var_colorradio($vid)\\\n"
"        -text [_ \"Background\"]\n"
"    radiobutton $id.colors.radio.arc -value 1 -variable ::dialog_knob::var_colorradio($vid)\\\n"
"        -text [_ \"Arc Background\"]\n"
"    radiobutton $id.colors.radio.fg -value 2 -variable ::dialog_knob::var_colorradio($vid)\\\n"
"        -text [_ \"Front\"]\n"
"    label $id.colors.radio.dummy -text \"\" -width 1\n"
"    button $id.colors.radio.but -text [_ \"Compose\"] -command \"::dialog_knob::compose_color $id\"\n"
"    pack $id.colors.radio.bg $id.colors.radio.arc $id.colors.radio.fg $id.colors.radio.dummy $id.colors.radio.but -side left\n"
"\n"
        // Preset colors, color scheme by Mary Ann Benedetto http://piR2.org
"    frame $id.colors.presets -pady 8\n"
"    pack $id.colors.presets -fill x\n"
"    foreach r {r1 r2 r3} hexcols {\n"
"       { \"#FFFFFF\" \"#DFDFDF\" \"#BBBBBB\" \"#FFC7C6\" \"#FFE3C6\" \"#FEFFC6\" \"#C6FFC7\" \"#C6FEFF\" \"#C7C6FF\" \"#E3C6FF\" }\n"
"       { \"#9F9F9F\" \"#7C7C7C\" \"#606060\" \"#FF0400\" \"#FF8300\" \"#FAFF00\" \"#00FF04\" \"#00FAFF\" \"#0400FF\" \"#9C00FF\" }\n"
"       { \"#404040\" \"#202020\" \"#000000\" \"#551312\" \"#553512\" \"#535512\" \"#0F4710\" \"#0E4345\" \"#131255\" \"#2F004D\" } }\\\n"
"    {\n"
"       frame $id.colors.presets.$r\n"
"       pack $id.colors.presets.$r -side top\n"
"       foreach i { 0 1 2 3 4 5 6 7 8 9} hexcol $hexcols \\\n"
"           {\n"
"               label $id.colors.presets.$r.c$i -background $hexcol -activebackground $hexcol -relief ridge -padx 7 -pady 0 -width 1\n"
"               bind $id.colors.presets.$r.c$i <Button> \"::dialog_knob::preset_col $id $hexcol\"\n"
"           }\n"
"       pack $id.colors.presets.$r.c0 $id.colors.presets.$r.c1 $id.colors.presets.$r.c2 $id.colors.presets.$r.c3 \\\n"
"           $id.colors.presets.$r.c4 $id.colors.presets.$r.c5 $id.colors.presets.$r.c6 $id.colors.presets.$r.c7 \\\n"
"           $id.colors.presets.$r.c8 $id.colors.presets.$r.c9 -side left\n"
"    }\n"
"\n"
// Cancel, Apply and OK buttons
"    frame $id.cao -pady 4\n"
"    pack $id.cao -side top\n"
"    button $id.cao.cancel -text [_ \"Cancel\"] \\\n"
"        -command \"::dialog_knob::cancel $id\"\n"
"    pack $id.cao.cancel -side left -expand 1 -fill x -padx 15 -ipadx 10\n"
"    if {$::windowingsystem ne \"aqua\"} {\n" // INCLUDE APPLY BUTTON ONLY IF NOT IN MACOS!
"        button $id.cao.apply -text [_ \"Apply\"] \\\n"
"            -command \"::dialog_knob::apply $id\"\n"
"        pack $id.cao.apply -side left -expand 1 -fill x -padx 15 -ipadx 10\n"
"    }\n"
"    button $id.cao.ok -text [_ \"OK\"] \\\n"
"        -command \"::dialog_knob::ok $id\" -default active\n"
"    pack $id.cao.ok -side left -expand 1 -fill x -padx 15 -ipadx 10\n"

// ----------------------------------------------------------------------------------------------------

// BUTTON FUNCTIONS
        
// Preset Colors
"proc ::dialog_knob::preset_col {id presetcol} {\n"
"    set vid [string trimleft $id .]\n"
"\n"
"    switch -- $::dialog_knob::var_colorradio($vid) {\n" // get type from radio and set
"        0 { set ::dialog_knob::var_color_bg($vid) $presetcol }\n"
"        1 { set ::dialog_knob::var_color_arc($vid) $presetcol }\n"
"        2 { set ::dialog_knob::var_color_fg($vid) $presetcol }\n"
"    }\n"
"    if {$::windowingsystem eq \"aqua\"} {\n" // Apply color change if in MACOS
"       ::dialog_knob::bind_enter_to_apply $id \n"
"    }\n"
"}\n"
"\n"
        
// COMPOSE Color:
"proc ::dialog_knob::compose_color {id} {\n"
"    set vid [string trimleft $id .]\n"
"\n"
// Check which color field is currently active
"    switch -- $::dialog_knob::var_colorradio($vid) {\n"
"        0 {\n"
"            set title [_ \"Background color\" ]\n"
"            set color $::dialog_knob::var_color_bg($vid)\n"
"        }\n"
"        1 {\n"
"            set title [_ \"Foreground color\" ]\n"
"            set color $::dialog_knob::var_color_fg($vid)\n"
"        }\n"
"        2 {\n"
"            set title [_ \"Arc color\" ]\n"
"            set color $::dialog_knob::var_color_arc($vid)\n"
"        }\n"
"    }\n"
"    set color [tk_chooseColor -title $title -initialcolor $color]\n"
"\n"
"    if { $color ne \"\" } {\n"
"        ::dialog_knob::preset_col $id $color\n"
"    }\n"
"}\n"
"\n"
                
//  CANCEL button
"proc ::dialog_knob::cancel {id} {\n"
"    pdsend \"$id cancel\"\n"
"}\n"
"\n"
                
// OK button
"proc ::dialog_knob::ok {id} {\n"
"    ::dialog_knob::apply $id\n"
"    ::dialog_knob::cancel $id\n"
"}\n"
        
// APPLY BUTTON: Send current values to Pd
"proc ::dialog_knob::apply {id} {\n"
"    set vid [string trimleft $id .]\n"
"\n"
//  Initialize receive, send, param and var as 'empty'
"    set rcv_name empty\n"
"    set snd_name empty\n"
"    set prm_name empty\n"
"    set var_name empty\n"
"\n"
//  Set receive, send, param and var if not empty
"    if {$::dialog_knob::var_rcv($vid) ne \"\"} {set rcv_name $::dialog_knob::var_rcv($vid)}\n"
"    if {$::dialog_knob::var_snd($vid) ne \"\"} {set snd_name $::dialog_knob::var_snd($vid)}\n"
"    if {$::dialog_knob::var_prm($vid) ne \"\"} {set prm_name $::dialog_knob::var_prm($vid)}\n"
"    if {$::dialog_knob::var_var($vid) ne \"\"} {set var_name $::dialog_knob::var_var($vid)}\n"
"\n"
//  Clip number of steps
"    set ::dialog_knob::var_steps($vid) [::dialog_knob::clip $::dialog_knob::var_steps($vid) 0 360]\n"
"\n"
//  Send to the object
"    pdsend [concat $id dialog \\\n"
"                $::dialog_knob::var_size($vid) \\\n"
"                $::dialog_knob::var_square($vid) \\\n"
"                $::dialog_knob::var_showarc($vid) \\\n"
"                $::dialog_knob::var_arcstart($vid) \\\n"
"                $::dialog_knob::var_loadbang($vid) \\\n"
"                $::dialog_knob::var_savestate($vid) \\\n"
"                $::dialog_knob::var_load($vid) \\\n"
"                $::dialog_knob::var_discrete($vid) \\\n"
"                $::dialog_knob::var_showticks($vid) \\\n"
"                $::dialog_knob::var_steps($vid) \\\n"
"                $::dialog_knob::var_angle_width($vid) \\\n"
"                $::dialog_knob::var_angle_offset($vid) \\\n"
"                $::dialog_knob::var_lower($vid) \\\n"
"                $::dialog_knob::var_upper($vid) \\\n"
"                $::dialog_knob::var_expmode($vid) \\\n"
"                $::dialog_knob::var_exp($vid) \\\n"
"                $::dialog_knob::var_readonly($vid) \\\n"
"                $::dialog_knob::var_jump($vid) \\\n"
"                $::dialog_knob::var_circular($vid) \\\n"
"                $::dialog_knob::var_nmode($vid) \\\n"
"                $::dialog_knob::var_n_size($vid) \\\n"
"                $::dialog_knob::var_xpos($vid) \\\n"
"                $::dialog_knob::var_ypos($vid) \\\n"
"                [string map {\"$\" {\\$}} [unspace_text $rcv_name]] \\\n"
"                [string map {\"$\" {\\$}} [unspace_text $snd_name]] \\\n"
"                [string map {\"$\" {\\$}} [unspace_text $prm_name]] \\\n" // clean?
"                [string map {\"$\" {\\$}} [unspace_text $var_name]] \\\n" // clean?
"                [string tolower $::dialog_knob::var_color_bg($vid)] \\\n"
"                [string tolower $::dialog_knob::var_color_arc($vid)] \\\n"
"                [string tolower $::dialog_knob::var_color_fg($vid)] \\\n"
"            ]\n"
"}\n"
        
// Bind and unbind enter key to Apply button on macOS for entry widgets
"    if {$::windowingsystem eq \"aqua\"} {\n"
// call apply on Return in entry boxes that are in focus & rebind Return to ok button
"        bind $id.load.load.ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.arcsettings.arcstart.ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.num.size.ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.num.xpos.ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.num.ypos.ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.discrete.steps.ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.angle.range.ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.angle.offset.ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.basic.dim.w_ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.rng.logmode.expmode_entry <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.rng.range.min.ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.rng.range.max_ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.syms.send.w_ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.syms.param.w_ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.syms.var.w_ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
"        bind $id.syms.receive.w_ent <KeyPress-Return> \"::dialog_knob::bind_enter_to_apply $id\"\n"
// unbind Return from ok button when an entry takes focus
"        $id.load.load.ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.arcsettings.arcstart.ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.num.size.ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.num.xpos.ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.num.ypos.ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.discrete.steps.ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.angle.range.ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.angle.offset.ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.basic.dim.w_ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.rng.logmode.expmode_entry config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.rng.range.min.ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.rng.range.max_ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.syms.send.w_ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.syms.param.w_ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.syms.var.w_ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
"        $id.syms.receive.w_ent config -validate focusin -vcmd \"::dialog_knob::unbind_return $id\"\n"
// remove cancel button from focus list since it's not activated on Return
"        $id.cao.cancel config -takefocus 0\n"
// show active focus on the ok button as it *is* activated on Return
"        $id.cao.ok config -default normal\n"
"        bind $id.cao.ok <FocusIn> \"$id.cao.ok config -default active\"\n"
"        bind $id.cao.ok <FocusOut> \"$id.cao.ok config -default normal\"\n"
// since we show the active focus, disable the highlight outline\n"
"        $id.cao.ok config -highlightthickness 0\n"
"        $id.cao.cancel config -highlightthickness 0\n"
"    }\n"
"    position_over_window $id $::focused_window\n"
"}\n"
"\n"
// bind proc
"proc ::dialog_knob::bind_enter_to_apply {id} {\n"
"    ::dialog_knob::apply $id\n"
"    bind $id <KeyPress-Return> \"::dialog_knob::ok $id\"\n"
"    focus $id.cao.ok\n"
"    return 0\n"
"}\n"
"\n"
// unbind proc
"proc ::dialog_knob::unbind_return {id} {\n"
"    bind $id <KeyPress-Return> break\n"
"    return 1\n"
"}\n");
