/*
 * Simple Virtual Machine - A versatile and robust architecture to
 * easily write applications.
 * Copyright (C) 2021  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once
#include <src/global/global.h>
namespace SVM
{
namespace Global
{
namespace Temps
{
	struct Chronometre
	{
		explicit Chronometre(const std::string& nom, const size_t divisions = 32)
		:_nom(nom), _divisions(divisions) {}
		Chronometre(const Chronometre& c) = delete;
		~Chronometre()
		{
			if(_evenements.empty())
			{
				std::cerr << "Chronometre " << _nom << " (" << this << ") inutilise" << std::endl;
				return;
			}
			std::vector<size_t> evenements(_evenements.begin(),_evenements.end());
			std::sort(evenements.begin(),evenements.end());
			size_t min = evenements.front();
			size_t max = evenements.back();
			size_t total = std::accumulate(evenements.begin(),evenements.end(),0);
			std::cerr << "Chronometre " << _nom << " (" << this << "):" << std::endl
				<< "Minimum : " << min << "ns" << std::endl
				<< "Maximum : " << max << "ns" << std::endl
				<< "Total   : " << total << "ns" << std::endl
				<< "Nombre  : " << evenements.size() << std::endl
				<< "Moyenne : " << (total/evenements.size()) << "ns" << std::endl
				<< "Percentiles :" << std::endl;
			for(const auto p: { 50, 80, 90, 95, 99 })
			{
				std::cerr << "\t" << p << "%: " << evenements[(p*evenements.size())/100] << "ns" << std::endl;
			}
			std::cerr << "Histogramme:" << std::endl;
			size_t intervale = (max-min)/_divisions;
			auto it=evenements.begin();
			for(size_t element=0 ; element<_divisions ; ++element)
			{
				size_t nombre=0;
				for( ; ((*it)<(min+(element+1)*intervale)) and (it!=evenements.end()); ++it)
				{
					++nombre;
				}
				std::cerr << "\t" << (min+element*intervale) << "ns ~ " << (min+(element+1)*intervale) << "ns: " << nombre << " (" << ((nombre*100)/evenements.size()) << "%)" << std::endl;
			}
			std::cerr << "Fin" << std::endl;
		}
		void debut()
		{
			_debut = std::chrono::steady_clock::now(); 
		}
		void fin()
		{
			auto fin = std::chrono::steady_clock::now();
			auto duree = std::chrono::duration_cast<std::chrono::nanoseconds>(fin-_debut);
			_evenements.push_back(duree.count());
		}
		private:
			const std::string _nom;
			const size_t _divisions;
			std::list<size_t> _evenements;
			std::chrono::time_point<std::chrono::steady_clock> _debut;
	};
	#define DEFINITION_CHRONOMETRE(nom) static SVM::Global::Temps::Chronometre& chronometre_##nom() { static SVM::Global::Temps::Chronometre chronometre(#nom); return chronometre; }
}
}
}
