#!/bin/sh -x

# 
# Simple Virtual Machine - A versatile and robust architecture to
# easily write applications.
# Copyright (C) 2021  Julien BRUGUIER
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# 

nettoyage()
{
	rm -rf svmpluginlocal
}

trap nettoyage EXIT 

../svm_plugin -fi $(dirname $0)/extension_locale.svm_plugin | bash
if [ $? -ne 0 ] ;
then
	exit 2
fi

### On redirige vers la machine non installee ###
sed -i "s/#include.*svm\.h\"/#include \"$( (cd $(dirname $0); pwd |sed 's/\//\\\//g') )\/..\/src\/machine\/interface\/svm.h\"/" ./svmpluginlocal/src/plugin.h
sed -i "s/#include.*svm_compatibility\.h\"/#include \"..\/..\/src\/machine\/interface\/svm_compatibility.h\"/" ./svmpluginlocal/src/plugin.h
sed -i "s/^SVM=.*/SVM=..\/..\/src\/machine\/interface\/.libs/" ./svmpluginlocal/Makefile.inc
#################################################

./svmpluginlocal/plugin_install -l check
if [ $? -ne 0 ] ;
then
	exit 3
fi
../svm $(dirname $0)/extension_locale.svm
if [ $? -eq 3 ] ;
then
	exit 0
else
	exit 1
fi
