---------------------------------------
openSUSE Build Service deb signing keys
=======================================

Author - Copyright (C) 2022, 2023 Mark Grant

--------
Contents
========

1 ... Project Description

2 ... AutoTools (configure and make) Installation

3 ... Installation of Distro-Native Packages

4 ... Utility Scripts



-------------------------
1 ... Project Description
=========================

a) The problem
--------------
This applies to systems using APT.

OBS repositories have a signing key which has a fixed lifetime. The OBS package
installation instructions provide a one-off instruction which downloads the key
to a keyring visible to the APT system. When that key expires APT objects.

b) The solution
---------------
This project provides a mechanism to download the keys onto a keyring and then
install the keyring. This AutoTools project is packaged downstream into a deb
file and is hosted in the OBS repo.

c) Maintainer actions to update the key
---------------------------------------
1 ... Using the osc tool, extend the expiry date of a key on OBS.

	osc signkey --extend home:m-grant-prg

This will take a few minutes to show up on OBS with the new date.

2 ... On OBS, trigger a re-build in each repository, this initiates the copy of the
updated key to the repo signing file (Release.key). This can be done via the web-UI or by:-

	osc rebuild home:m-grant-prg agmaint

3 ... Generate a new keyring.

	./gen-keyring.sh

4 ... Check the result.

	gpg --list-keys --no-default-keyring \
		--keyring ./src/conf/etc/home_m-grant-prg.gpg

Create a release and package downstream.

References
----------
https://forums.opensuse.org/showthread.php/518046-How-to-update-expired-OBS-home-project-signing-key

N.B.
----
At a source modification / development level, this project expects to reside in
a git environment. This manifests itself in 2 places:-
1) ... .gitignore files are included in the source.
2) ... The make target, 'srctarball', relies on the command 'git am' so it will
	fail if git is not installed or it is not in a git repository.


-------------------------------------------------
2 ... AutoTools (configure and make) Installation
=================================================

a) ... Download either the source or distribution tarball (the .tar.gz file)
	from:-
	https://github.com/m-grant-prg/backup-at-scripts/releases

b) ... Extract the tarball preserving the directory structure.

c) ... cd to the directory created.

d) ... If you downloaded the source tarball type 'autoreconf -if'

e) ... Type './configure'

f) ... As root or sudo, type 'make install clean'

(Quote marks are for textual clarity only).

To uninstall the package:

1 ... cd to the directory created in the above install process.

2 ... As root or sudo, type 'make uninstall clean'


--------------------------------------------
3 ... Installation of Distro-Native Packages
============================================
Installation packages native to different distributions are available, please
refer to the relevant installation section on the wiki at:-

https://github.com/m-grant-prg/mgrant-obs-deb-keyring/wiki


---------------------
4 ... Utility Scripts
=====================
In the project root directory there is 1 helper script; bootstrap.sh.

bootstrap.sh
------------
This misleadingly named script bootstraps the project build and provides other
useful features. The main options below are probably b, c, C, D and T.

In AutoTools it is usually advisable to perform parallel builds. This means you
build somewhere other than the project root. This is because building creates
files and they would confuse the project root downwards. I always create a build
directory straight off the project root, cd to there and do all build and git
work from there, (.gitignore is already set to ignore such a directory).

Assuming you adopt the preceding paragraph then a typical invocation of the
script would be:-

../bootstrap.sh --config --build ..

The last '..' points the way to project root.

For the full list of arguments to bootstrap.sh, please refer to the options
section of the acmbuild wiki, the options are identical:-

https://github.com/m-grant-prg/acmbuild/wiki

