This project is distributed in the hope that it will be useful,
but without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose.

**Official repositories**:

- [https://codeberg.org/os-18/oxfuse](https://codeberg.org/os-18/oxfuse)
- [https://gitlab.com/os-18/oxfuse](https://gitlab.com/os-18/oxfuse)


*Keywords*:  
dlang, d, fuse, libfuse, libfuse3, binding, wrapper, filesystem.

---

## About

OXFuse (Object-oriented eXtension for FUSE) is a D language binding
for [libfuse3](https://github.com/libfuse/libfuse), allowing developers
to create user-space filesystems for Linux with an object-oriented interface.

### Features

- To create your own file system, inherit from
  the `oxfuse.FileSystem` class and override any methods
  representing file operations.

- This library allows you to use forty operations from libfuse
  (all except `write_buf()`/`read_buf()`).

- The behavior of all non-overloaded functions is determined by FUSE
  and the OS kernel.

- The library does not provide bindings for functions that parse command-line
  arguments. Parsing is proposed to be done using the D language tools.

- Errors with accompanying messages and `errno` are represented
  by `FuseException` and the `fe()` function.

- The [original library](https://github.com/libfuse/libfuse) broke backward
  compatibility for the `fuse_config` and `fuse_file_info` structures.
  Our library takes into account the current system version of libfuse3.
  All structures in the final build have the correct versions.

- At present, only the high-level part has been ported; the low-level part
  is not available.

---

## Documentation

[https://os-18.codeberg.page/oxfuse/](https://os-18.codeberg.page/oxfuse/)

The "examples/" directory contains several different implementations
of file systems.

Useful information is also available here:
[https://github.com/libfuse/libfuse/wiki](https://github.com/libfuse/libfuse/wiki).

---

## Ready-made packages

See:  
[Download Page of OS-18](https://codeberg.org/os-18/os-18-docs/src/branch/master/OS-18_Packages.md)

The page contains information about installing several packages, including
OXFuse.

---

## Build from source

### Preparing

You must have [make](https://www.gnu.org/software/make/)
and at least one of these compilers:

- [Digital Mars D Compiler](https://dlang.org/download.html#dmd)
- [LLVM D Compiler](https://wiki.dlang.org/LDC)
- [GNU D Compiler](https://www.gdcproject.org)

Also the library needs **libfuse3**.

### Compilation and installation

To build static and dynamic libraries using the **ldc2** compiler (default):

```bash
make
```

Installation (root privileges may be required):

```bash
make install
```

The Makefile contains variables:

* `DESTDIR` specifies the root directory for installing (empty, by default);
* `PREFIX` points to the base directory like `usr/local` or `usr`.

The installation directory is defined as `$(DESTDIR)/$(PREFIX)` in the Makefile.

You can install the library files in any directory; example for `$HOME/.local`:

```bash
make install DESTDIR=$HOME PREFIX=.local
```

Uninstall:

```bash
make uninstall
```

If the project was installed in a non-default location,
use the corresponding paths:

```bash
make uninstall DESTDIR=$HOME PREFIX=.local
```

### Other compilers

Compiler by default is **ldc2**.
You can choose another compiler (for example, **gdc**):

```bash
make DC=gdc
```

Installing:

```bash
make install DC=gdc
```

Uninstalling:

```bash
make uninstall DC=gdc
```

---

## Feedback

For questions, suggestions, comments, or bugs reports:

**tech.vindex@gmail.com**

Also use the repository service tools.

---
