if (WIN32 OR CMAKE_SYSTEM_NAME MATCHES "MSYS")
    set(XMRIG_OS_WIN ON)
elseif (APPLE)
    set(XMRIG_OS_APPLE ON)

    if (IOS OR CMAKE_SYSTEM_NAME STREQUAL iOS)
        set(XMRIG_OS_IOS ON)
    else()
        set(XMRIG_OS_MACOS ON)
    endif()
else()
    set(XMRIG_OS_UNIX ON)

    if (ANDROID OR CMAKE_SYSTEM_NAME MATCHES "Android")
        set(XMRIG_OS_ANDROID ON)
    elseif(CMAKE_SYSTEM_NAME MATCHES "Linux")
        set(XMRIG_OS_LINUX ON)
    elseif(CMAKE_SYSTEM_NAME STREQUAL FreeBSD OR CMAKE_SYSTEM_NAME STREQUAL DragonFly)
        set(XMRIG_OS_FREEBSD ON)
    endif()
endif()

if (XMRIG_OS_WIN)
    add_definitions(-DWIN32 -DXMRIG_OS_WIN)
elseif(XMRIG_OS_APPLE)
    add_definitions(-DXMRIG_OS_APPLE)

    if (XMRIG_OS_IOS)
        add_definitions(-DXMRIG_OS_IOS)
    else()
        add_definitions(-DXMRIG_OS_MACOS)
    endif()

    if (XMRIG_ARM)
        set(WITH_SECURE_JIT ON)
    endif()
elseif(XMRIG_OS_UNIX)
    add_definitions(-DXMRIG_OS_UNIX)

    if (XMRIG_OS_ANDROID)
        add_definitions(-DXMRIG_OS_ANDROID)
    elseif (XMRIG_OS_LINUX)
        add_definitions(-DXMRIG_OS_LINUX)
    elseif (XMRIG_OS_FREEBSD)
        add_definitions(-DXMRIG_OS_FREEBSD)
    endif()
endif()

if (WITH_SECURE_JIT)
    add_definitions(-DXMRIG_SECURE_JIT)
endif()
