require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_BTRFS_CTREE_H_)) {
    eval 'sub _BTRFS_CTREE_H_ () {1;}' unless defined(&_BTRFS_CTREE_H_);
    require 'linux/btrfs.ph';
    require 'linux/types.ph';
    require 'stddef.ph';
    eval 'sub BTRFS_MAGIC () {0x4d5f53665248425f;}' unless defined(&BTRFS_MAGIC);
    eval 'sub BTRFS_MAX_LEVEL () {8;}' unless defined(&BTRFS_MAX_LEVEL);
    eval 'sub BTRFS_NAME_LEN () {255;}' unless defined(&BTRFS_NAME_LEN);
    eval 'sub BTRFS_LINK_MAX () {65535;}' unless defined(&BTRFS_LINK_MAX);
    eval 'sub BTRFS_ROOT_TREE_OBJECTID () {1;}' unless defined(&BTRFS_ROOT_TREE_OBJECTID);
    eval 'sub BTRFS_EXTENT_TREE_OBJECTID () {2;}' unless defined(&BTRFS_EXTENT_TREE_OBJECTID);
    eval 'sub BTRFS_CHUNK_TREE_OBJECTID () {3;}' unless defined(&BTRFS_CHUNK_TREE_OBJECTID);
    eval 'sub BTRFS_DEV_TREE_OBJECTID () {4;}' unless defined(&BTRFS_DEV_TREE_OBJECTID);
    eval 'sub BTRFS_FS_TREE_OBJECTID () {5;}' unless defined(&BTRFS_FS_TREE_OBJECTID);
    eval 'sub BTRFS_ROOT_TREE_DIR_OBJECTID () {6;}' unless defined(&BTRFS_ROOT_TREE_DIR_OBJECTID);
    eval 'sub BTRFS_CSUM_TREE_OBJECTID () {7;}' unless defined(&BTRFS_CSUM_TREE_OBJECTID);
    eval 'sub BTRFS_QUOTA_TREE_OBJECTID () {8;}' unless defined(&BTRFS_QUOTA_TREE_OBJECTID);
    eval 'sub BTRFS_UUID_TREE_OBJECTID () {9;}' unless defined(&BTRFS_UUID_TREE_OBJECTID);
    eval 'sub BTRFS_FREE_SPACE_TREE_OBJECTID () {10;}' unless defined(&BTRFS_FREE_SPACE_TREE_OBJECTID);
    eval 'sub BTRFS_BLOCK_GROUP_TREE_OBJECTID () {11;}' unless defined(&BTRFS_BLOCK_GROUP_TREE_OBJECTID);
    eval 'sub BTRFS_RAID_STRIPE_TREE_OBJECTID () {12;}' unless defined(&BTRFS_RAID_STRIPE_TREE_OBJECTID);
    eval 'sub BTRFS_DEV_STATS_OBJECTID () {0;}' unless defined(&BTRFS_DEV_STATS_OBJECTID);
    eval 'sub BTRFS_BALANCE_OBJECTID () {-4;}' unless defined(&BTRFS_BALANCE_OBJECTID);
    eval 'sub BTRFS_ORPHAN_OBJECTID () {-5;}' unless defined(&BTRFS_ORPHAN_OBJECTID);
    eval 'sub BTRFS_TREE_LOG_OBJECTID () {-6;}' unless defined(&BTRFS_TREE_LOG_OBJECTID);
    eval 'sub BTRFS_TREE_LOG_FIXUP_OBJECTID () {-7;}' unless defined(&BTRFS_TREE_LOG_FIXUP_OBJECTID);
    eval 'sub BTRFS_TREE_RELOC_OBJECTID () {-8;}' unless defined(&BTRFS_TREE_RELOC_OBJECTID);
    eval 'sub BTRFS_DATA_RELOC_TREE_OBJECTID () {-9;}' unless defined(&BTRFS_DATA_RELOC_TREE_OBJECTID);
    eval 'sub BTRFS_EXTENT_CSUM_OBJECTID () {-10;}' unless defined(&BTRFS_EXTENT_CSUM_OBJECTID);
    eval 'sub BTRFS_FREE_SPACE_OBJECTID () {-11;}' unless defined(&BTRFS_FREE_SPACE_OBJECTID);
    eval 'sub BTRFS_FREE_INO_OBJECTID () {-12;}' unless defined(&BTRFS_FREE_INO_OBJECTID);
    eval 'sub BTRFS_MULTIPLE_OBJECTIDS () {-255;}' unless defined(&BTRFS_MULTIPLE_OBJECTIDS);
    eval 'sub BTRFS_FIRST_FREE_OBJECTID () {256;}' unless defined(&BTRFS_FIRST_FREE_OBJECTID);
    eval 'sub BTRFS_LAST_FREE_OBJECTID () {-256;}' unless defined(&BTRFS_LAST_FREE_OBJECTID);
    eval 'sub BTRFS_FIRST_CHUNK_TREE_OBJECTID () {256;}' unless defined(&BTRFS_FIRST_CHUNK_TREE_OBJECTID);
    eval 'sub BTRFS_DEV_ITEMS_OBJECTID () {1;}' unless defined(&BTRFS_DEV_ITEMS_OBJECTID);
    eval 'sub BTRFS_BTREE_INODE_OBJECTID () {1;}' unless defined(&BTRFS_BTREE_INODE_OBJECTID);
    eval 'sub BTRFS_EMPTY_SUBVOL_DIR_OBJECTID () {2;}' unless defined(&BTRFS_EMPTY_SUBVOL_DIR_OBJECTID);
    eval 'sub BTRFS_DEV_REPLACE_DEVID () {0;}' unless defined(&BTRFS_DEV_REPLACE_DEVID);
    eval 'sub BTRFS_INODE_ITEM_KEY () {1;}' unless defined(&BTRFS_INODE_ITEM_KEY);
    eval 'sub BTRFS_INODE_REF_KEY () {12;}' unless defined(&BTRFS_INODE_REF_KEY);
    eval 'sub BTRFS_INODE_EXTREF_KEY () {13;}' unless defined(&BTRFS_INODE_EXTREF_KEY);
    eval 'sub BTRFS_XATTR_ITEM_KEY () {24;}' unless defined(&BTRFS_XATTR_ITEM_KEY);
    eval 'sub BTRFS_VERITY_DESC_ITEM_KEY () {36;}' unless defined(&BTRFS_VERITY_DESC_ITEM_KEY);
    eval 'sub BTRFS_VERITY_MERKLE_ITEM_KEY () {37;}' unless defined(&BTRFS_VERITY_MERKLE_ITEM_KEY);
    eval 'sub BTRFS_ORPHAN_ITEM_KEY () {48;}' unless defined(&BTRFS_ORPHAN_ITEM_KEY);
    eval 'sub BTRFS_DIR_LOG_ITEM_KEY () {60;}' unless defined(&BTRFS_DIR_LOG_ITEM_KEY);
    eval 'sub BTRFS_DIR_LOG_INDEX_KEY () {72;}' unless defined(&BTRFS_DIR_LOG_INDEX_KEY);
    eval 'sub BTRFS_DIR_ITEM_KEY () {84;}' unless defined(&BTRFS_DIR_ITEM_KEY);
    eval 'sub BTRFS_DIR_INDEX_KEY () {96;}' unless defined(&BTRFS_DIR_INDEX_KEY);
    eval 'sub BTRFS_EXTENT_DATA_KEY () {108;}' unless defined(&BTRFS_EXTENT_DATA_KEY);
    eval 'sub BTRFS_EXTENT_CSUM_KEY () {128;}' unless defined(&BTRFS_EXTENT_CSUM_KEY);
    eval 'sub BTRFS_ROOT_ITEM_KEY () {132;}' unless defined(&BTRFS_ROOT_ITEM_KEY);
    eval 'sub BTRFS_ROOT_BACKREF_KEY () {144;}' unless defined(&BTRFS_ROOT_BACKREF_KEY);
    eval 'sub BTRFS_ROOT_REF_KEY () {156;}' unless defined(&BTRFS_ROOT_REF_KEY);
    eval 'sub BTRFS_EXTENT_ITEM_KEY () {168;}' unless defined(&BTRFS_EXTENT_ITEM_KEY);
    eval 'sub BTRFS_METADATA_ITEM_KEY () {169;}' unless defined(&BTRFS_METADATA_ITEM_KEY);
    eval 'sub BTRFS_EXTENT_OWNER_REF_KEY () {172;}' unless defined(&BTRFS_EXTENT_OWNER_REF_KEY);
    eval 'sub BTRFS_TREE_BLOCK_REF_KEY () {176;}' unless defined(&BTRFS_TREE_BLOCK_REF_KEY);
    eval 'sub BTRFS_EXTENT_DATA_REF_KEY () {178;}' unless defined(&BTRFS_EXTENT_DATA_REF_KEY);
    eval 'sub BTRFS_SHARED_BLOCK_REF_KEY () {182;}' unless defined(&BTRFS_SHARED_BLOCK_REF_KEY);
    eval 'sub BTRFS_SHARED_DATA_REF_KEY () {184;}' unless defined(&BTRFS_SHARED_DATA_REF_KEY);
    eval 'sub BTRFS_BLOCK_GROUP_ITEM_KEY () {192;}' unless defined(&BTRFS_BLOCK_GROUP_ITEM_KEY);
    eval 'sub BTRFS_FREE_SPACE_INFO_KEY () {198;}' unless defined(&BTRFS_FREE_SPACE_INFO_KEY);
    eval 'sub BTRFS_FREE_SPACE_EXTENT_KEY () {199;}' unless defined(&BTRFS_FREE_SPACE_EXTENT_KEY);
    eval 'sub BTRFS_FREE_SPACE_BITMAP_KEY () {200;}' unless defined(&BTRFS_FREE_SPACE_BITMAP_KEY);
    eval 'sub BTRFS_DEV_EXTENT_KEY () {204;}' unless defined(&BTRFS_DEV_EXTENT_KEY);
    eval 'sub BTRFS_DEV_ITEM_KEY () {216;}' unless defined(&BTRFS_DEV_ITEM_KEY);
    eval 'sub BTRFS_CHUNK_ITEM_KEY () {228;}' unless defined(&BTRFS_CHUNK_ITEM_KEY);
    eval 'sub BTRFS_RAID_STRIPE_KEY () {230;}' unless defined(&BTRFS_RAID_STRIPE_KEY);
    eval 'sub BTRFS_QGROUP_STATUS_KEY () {240;}' unless defined(&BTRFS_QGROUP_STATUS_KEY);
    eval 'sub BTRFS_QGROUP_INFO_KEY () {242;}' unless defined(&BTRFS_QGROUP_INFO_KEY);
    eval 'sub BTRFS_QGROUP_LIMIT_KEY () {244;}' unless defined(&BTRFS_QGROUP_LIMIT_KEY);
    eval 'sub BTRFS_QGROUP_RELATION_KEY () {246;}' unless defined(&BTRFS_QGROUP_RELATION_KEY);
    eval 'sub BTRFS_BALANCE_ITEM_KEY () {248;}' unless defined(&BTRFS_BALANCE_ITEM_KEY);
    eval 'sub BTRFS_TEMPORARY_ITEM_KEY () {248;}' unless defined(&BTRFS_TEMPORARY_ITEM_KEY);
    eval 'sub BTRFS_DEV_STATS_KEY () {249;}' unless defined(&BTRFS_DEV_STATS_KEY);
    eval 'sub BTRFS_PERSISTENT_ITEM_KEY () {249;}' unless defined(&BTRFS_PERSISTENT_ITEM_KEY);
    eval 'sub BTRFS_DEV_REPLACE_KEY () {250;}' unless defined(&BTRFS_DEV_REPLACE_KEY);
    if((defined(&BTRFS_UUID_SIZE) ? &BTRFS_UUID_SIZE : undef) != 16) {
	die("UUID items require BTRFS_UUID_SIZE == 16!");
    }
    eval 'sub BTRFS_UUID_KEY_SUBVOL () {251;}' unless defined(&BTRFS_UUID_KEY_SUBVOL);
    eval 'sub BTRFS_UUID_KEY_RECEIVED_SUBVOL () {252;}' unless defined(&BTRFS_UUID_KEY_RECEIVED_SUBVOL);
    eval 'sub BTRFS_STRING_ITEM_KEY () {253;}' unless defined(&BTRFS_STRING_ITEM_KEY);
    eval 'sub BTRFS_MAX_METADATA_BLOCKSIZE () {65536;}' unless defined(&BTRFS_MAX_METADATA_BLOCKSIZE);
    eval 'sub BTRFS_CSUM_SIZE () {32;}' unless defined(&BTRFS_CSUM_SIZE);
    eval("sub BTRFS_CSUM_TYPE_CRC32 () { 0; }") unless defined(&BTRFS_CSUM_TYPE_CRC32);
    eval("sub BTRFS_CSUM_TYPE_XXHASH () { 1; }") unless defined(&BTRFS_CSUM_TYPE_XXHASH);
    eval("sub BTRFS_CSUM_TYPE_SHA256 () { 2; }") unless defined(&BTRFS_CSUM_TYPE_SHA256);
    eval("sub BTRFS_CSUM_TYPE_BLAKE2 () { 3; }") unless defined(&BTRFS_CSUM_TYPE_BLAKE2);
    eval 'sub BTRFS_FT_UNKNOWN () {0;}' unless defined(&BTRFS_FT_UNKNOWN);
    eval 'sub BTRFS_FT_REG_FILE () {1;}' unless defined(&BTRFS_FT_REG_FILE);
    eval 'sub BTRFS_FT_DIR () {2;}' unless defined(&BTRFS_FT_DIR);
    eval 'sub BTRFS_FT_CHRDEV () {3;}' unless defined(&BTRFS_FT_CHRDEV);
    eval 'sub BTRFS_FT_BLKDEV () {4;}' unless defined(&BTRFS_FT_BLKDEV);
    eval 'sub BTRFS_FT_FIFO () {5;}' unless defined(&BTRFS_FT_FIFO);
    eval 'sub BTRFS_FT_SOCK () {6;}' unless defined(&BTRFS_FT_SOCK);
    eval 'sub BTRFS_FT_SYMLINK () {7;}' unless defined(&BTRFS_FT_SYMLINK);
    eval 'sub BTRFS_FT_XATTR () {8;}' unless defined(&BTRFS_FT_XATTR);
    eval 'sub BTRFS_FT_MAX () {9;}' unless defined(&BTRFS_FT_MAX);
    eval 'sub BTRFS_FT_ENCRYPTED () {0x80;}' unless defined(&BTRFS_FT_ENCRYPTED);
    eval 'sub btrfs_dir_flags_to_ftype {
        my($flags) = @_;
	    eval q({ $flags & ~ &BTRFS_FT_ENCRYPTED; });
    }' unless defined(&btrfs_dir_flags_to_ftype);
    eval 'sub BTRFS_INODE_NODATASUM () {(1 << 0);}' unless defined(&BTRFS_INODE_NODATASUM);
    eval 'sub BTRFS_INODE_NODATACOW () {(1 << 1);}' unless defined(&BTRFS_INODE_NODATACOW);
    eval 'sub BTRFS_INODE_READONLY () {(1 << 2);}' unless defined(&BTRFS_INODE_READONLY);
    eval 'sub BTRFS_INODE_NOCOMPRESS () {(1 << 3);}' unless defined(&BTRFS_INODE_NOCOMPRESS);
    eval 'sub BTRFS_INODE_PREALLOC () {(1 << 4);}' unless defined(&BTRFS_INODE_PREALLOC);
    eval 'sub BTRFS_INODE_SYNC () {(1 << 5);}' unless defined(&BTRFS_INODE_SYNC);
    eval 'sub BTRFS_INODE_IMMUTABLE () {(1 << 6);}' unless defined(&BTRFS_INODE_IMMUTABLE);
    eval 'sub BTRFS_INODE_APPEND () {(1 << 7);}' unless defined(&BTRFS_INODE_APPEND);
    eval 'sub BTRFS_INODE_NODUMP () {(1 << 8);}' unless defined(&BTRFS_INODE_NODUMP);
    eval 'sub BTRFS_INODE_NOATIME () {(1 << 9);}' unless defined(&BTRFS_INODE_NOATIME);
    eval 'sub BTRFS_INODE_DIRSYNC () {(1 << 10);}' unless defined(&BTRFS_INODE_DIRSYNC);
    eval 'sub BTRFS_INODE_COMPRESS () {(1 << 11);}' unless defined(&BTRFS_INODE_COMPRESS);
    eval 'sub BTRFS_INODE_ROOT_ITEM_INIT () {(1 << 31);}' unless defined(&BTRFS_INODE_ROOT_ITEM_INIT);
    eval 'sub BTRFS_INODE_FLAG_MASK () {( &BTRFS_INODE_NODATASUM |  &BTRFS_INODE_NODATACOW |  &BTRFS_INODE_READONLY |  &BTRFS_INODE_NOCOMPRESS |  &BTRFS_INODE_PREALLOC |  &BTRFS_INODE_SYNC |  &BTRFS_INODE_IMMUTABLE |  &BTRFS_INODE_APPEND |  &BTRFS_INODE_NODUMP |  &BTRFS_INODE_NOATIME |  &BTRFS_INODE_DIRSYNC |  &BTRFS_INODE_COMPRESS |  &BTRFS_INODE_ROOT_ITEM_INIT);}' unless defined(&BTRFS_INODE_FLAG_MASK);
    eval 'sub BTRFS_INODE_RO_VERITY () {(1 << 0);}' unless defined(&BTRFS_INODE_RO_VERITY);
    eval 'sub BTRFS_INODE_RO_FLAG_MASK () {( &BTRFS_INODE_RO_VERITY);}' unless defined(&BTRFS_INODE_RO_FLAG_MASK);
    eval 'sub BTRFS_SYSTEM_CHUNK_ARRAY_SIZE () {2048;}' unless defined(&BTRFS_SYSTEM_CHUNK_ARRAY_SIZE);
    eval 'sub BTRFS_NUM_BACKUP_ROOTS () {4;}' unless defined(&BTRFS_NUM_BACKUP_ROOTS);
    eval 'sub BTRFS_FREE_SPACE_EXTENT () {1;}' unless defined(&BTRFS_FREE_SPACE_EXTENT);
    eval 'sub BTRFS_FREE_SPACE_BITMAP () {2;}' unless defined(&BTRFS_FREE_SPACE_BITMAP);
    eval 'sub BTRFS_HEADER_FLAG_WRITTEN () {(1 << 0);}' unless defined(&BTRFS_HEADER_FLAG_WRITTEN);
    eval 'sub BTRFS_HEADER_FLAG_RELOC () {(1 << 1);}' unless defined(&BTRFS_HEADER_FLAG_RELOC);
    eval 'sub BTRFS_SUPER_FLAG_ERROR () {(1 << 2);}' unless defined(&BTRFS_SUPER_FLAG_ERROR);
    eval 'sub BTRFS_SUPER_FLAG_SEEDING () {(1 << 32);}' unless defined(&BTRFS_SUPER_FLAG_SEEDING);
    eval 'sub BTRFS_SUPER_FLAG_METADUMP () {(1 << 33);}' unless defined(&BTRFS_SUPER_FLAG_METADUMP);
    eval 'sub BTRFS_SUPER_FLAG_METADUMP_V2 () {(1 << 34);}' unless defined(&BTRFS_SUPER_FLAG_METADUMP_V2);
    eval 'sub BTRFS_SUPER_FLAG_CHANGING_FSID () {(1 << 35);}' unless defined(&BTRFS_SUPER_FLAG_CHANGING_FSID);
    eval 'sub BTRFS_SUPER_FLAG_CHANGING_FSID_V2 () {(1 << 36);}' unless defined(&BTRFS_SUPER_FLAG_CHANGING_FSID_V2);
    eval 'sub BTRFS_SUPER_FLAG_CHANGING_BG_TREE () {(1 << 38);}' unless defined(&BTRFS_SUPER_FLAG_CHANGING_BG_TREE);
    eval 'sub BTRFS_SUPER_FLAG_CHANGING_DATA_CSUM () {(1 << 39);}' unless defined(&BTRFS_SUPER_FLAG_CHANGING_DATA_CSUM);
    eval 'sub BTRFS_SUPER_FLAG_CHANGING_META_CSUM () {(1 << 40);}' unless defined(&BTRFS_SUPER_FLAG_CHANGING_META_CSUM);
    eval 'sub BTRFS_EXTENT_FLAG_DATA () {(1 << 0);}' unless defined(&BTRFS_EXTENT_FLAG_DATA);
    eval 'sub BTRFS_EXTENT_FLAG_TREE_BLOCK () {(1 << 1);}' unless defined(&BTRFS_EXTENT_FLAG_TREE_BLOCK);
    eval 'sub BTRFS_BLOCK_FLAG_FULL_BACKREF () {(1 << 8);}' unless defined(&BTRFS_BLOCK_FLAG_FULL_BACKREF);
    eval 'sub BTRFS_BACKREF_REV_MAX () {256;}' unless defined(&BTRFS_BACKREF_REV_MAX);
    eval 'sub BTRFS_BACKREF_REV_SHIFT () {56;}' unless defined(&BTRFS_BACKREF_REV_SHIFT);
    eval 'sub BTRFS_BACKREF_REV_MASK () {((( &u64) &BTRFS_BACKREF_REV_MAX - 1) <<  &BTRFS_BACKREF_REV_SHIFT);}' unless defined(&BTRFS_BACKREF_REV_MASK);
    eval 'sub BTRFS_OLD_BACKREF_REV () {0;}' unless defined(&BTRFS_OLD_BACKREF_REV);
    eval 'sub BTRFS_MIXED_BACKREF_REV () {1;}' unless defined(&BTRFS_MIXED_BACKREF_REV);
    eval 'sub BTRFS_EXTENT_FLAG_SUPER () {(1 << 48);}' unless defined(&BTRFS_EXTENT_FLAG_SUPER);
    eval 'sub BTRFS_ROOT_SUBVOL_RDONLY () {(1 << 0);}' unless defined(&BTRFS_ROOT_SUBVOL_RDONLY);
    eval 'sub BTRFS_ROOT_SUBVOL_DEAD () {(1 << 48);}' unless defined(&BTRFS_ROOT_SUBVOL_DEAD);
    eval("sub BTRFS_FILE_EXTENT_INLINE () { 0; }") unless defined(&BTRFS_FILE_EXTENT_INLINE);
    eval("sub BTRFS_FILE_EXTENT_REG () { 1; }") unless defined(&BTRFS_FILE_EXTENT_REG);
    eval("sub BTRFS_FILE_EXTENT_PREALLOC () { 2; }") unless defined(&BTRFS_FILE_EXTENT_PREALLOC);
    eval("sub BTRFS_NR_FILE_EXTENT_TYPES () { 3; }") unless defined(&BTRFS_NR_FILE_EXTENT_TYPES);
    eval 'sub BTRFS_DEV_REPLACE_ITEM_CONT_READING_FROM_SRCDEV_MODE_ALWAYS () {0;}' unless defined(&BTRFS_DEV_REPLACE_ITEM_CONT_READING_FROM_SRCDEV_MODE_ALWAYS);
    eval 'sub BTRFS_DEV_REPLACE_ITEM_CONT_READING_FROM_SRCDEV_MODE_AVOID () {1;}' unless defined(&BTRFS_DEV_REPLACE_ITEM_CONT_READING_FROM_SRCDEV_MODE_AVOID);
    eval 'sub BTRFS_BLOCK_GROUP_DATA () {(1 << 0);}' unless defined(&BTRFS_BLOCK_GROUP_DATA);
    eval 'sub BTRFS_BLOCK_GROUP_SYSTEM () {(1 << 1);}' unless defined(&BTRFS_BLOCK_GROUP_SYSTEM);
    eval 'sub BTRFS_BLOCK_GROUP_METADATA () {(1 << 2);}' unless defined(&BTRFS_BLOCK_GROUP_METADATA);
    eval 'sub BTRFS_BLOCK_GROUP_RAID0 () {(1 << 3);}' unless defined(&BTRFS_BLOCK_GROUP_RAID0);
    eval 'sub BTRFS_BLOCK_GROUP_RAID1 () {(1 << 4);}' unless defined(&BTRFS_BLOCK_GROUP_RAID1);
    eval 'sub BTRFS_BLOCK_GROUP_DUP () {(1 << 5);}' unless defined(&BTRFS_BLOCK_GROUP_DUP);
    eval 'sub BTRFS_BLOCK_GROUP_RAID10 () {(1 << 6);}' unless defined(&BTRFS_BLOCK_GROUP_RAID10);
    eval 'sub BTRFS_BLOCK_GROUP_RAID5 () {(1 << 7);}' unless defined(&BTRFS_BLOCK_GROUP_RAID5);
    eval 'sub BTRFS_BLOCK_GROUP_RAID6 () {(1 << 8);}' unless defined(&BTRFS_BLOCK_GROUP_RAID6);
    eval 'sub BTRFS_BLOCK_GROUP_RAID1C3 () {(1 << 9);}' unless defined(&BTRFS_BLOCK_GROUP_RAID1C3);
    eval 'sub BTRFS_BLOCK_GROUP_RAID1C4 () {(1 << 10);}' unless defined(&BTRFS_BLOCK_GROUP_RAID1C4);
    eval 'sub BTRFS_BLOCK_GROUP_RESERVED () {( &BTRFS_AVAIL_ALLOC_BIT_SINGLE |  &BTRFS_SPACE_INFO_GLOBAL_RSV);}' unless defined(&BTRFS_BLOCK_GROUP_RESERVED);
    eval 'sub BTRFS_BLOCK_GROUP_TYPE_MASK () {( &BTRFS_BLOCK_GROUP_DATA |  &BTRFS_BLOCK_GROUP_SYSTEM |  &BTRFS_BLOCK_GROUP_METADATA);}' unless defined(&BTRFS_BLOCK_GROUP_TYPE_MASK);
    eval 'sub BTRFS_BLOCK_GROUP_PROFILE_MASK () {( &BTRFS_BLOCK_GROUP_RAID0 |  &BTRFS_BLOCK_GROUP_RAID1 |  &BTRFS_BLOCK_GROUP_RAID1C3 |  &BTRFS_BLOCK_GROUP_RAID1C4 |  &BTRFS_BLOCK_GROUP_RAID5 |  &BTRFS_BLOCK_GROUP_RAID6 |  &BTRFS_BLOCK_GROUP_DUP |  &BTRFS_BLOCK_GROUP_RAID10);}' unless defined(&BTRFS_BLOCK_GROUP_PROFILE_MASK);
    eval 'sub BTRFS_BLOCK_GROUP_RAID56_MASK () {( &BTRFS_BLOCK_GROUP_RAID5 |  &BTRFS_BLOCK_GROUP_RAID6);}' unless defined(&BTRFS_BLOCK_GROUP_RAID56_MASK);
    eval 'sub BTRFS_BLOCK_GROUP_RAID1_MASK () {( &BTRFS_BLOCK_GROUP_RAID1 |  &BTRFS_BLOCK_GROUP_RAID1C3 |  &BTRFS_BLOCK_GROUP_RAID1C4);}' unless defined(&BTRFS_BLOCK_GROUP_RAID1_MASK);
    eval 'sub BTRFS_AVAIL_ALLOC_BIT_SINGLE () {(1 << 48);}' unless defined(&BTRFS_AVAIL_ALLOC_BIT_SINGLE);
    eval 'sub BTRFS_SPACE_INFO_GLOBAL_RSV () {(1 << 49);}' unless defined(&BTRFS_SPACE_INFO_GLOBAL_RSV);
    eval 'sub BTRFS_EXTENDED_PROFILE_MASK () {( &BTRFS_BLOCK_GROUP_PROFILE_MASK |  &BTRFS_AVAIL_ALLOC_BIT_SINGLE);}' unless defined(&BTRFS_EXTENDED_PROFILE_MASK);
    eval 'sub chunk_to_extended {
        my($flags) = @_;
	    eval q({  &if (($flags &  &BTRFS_BLOCK_GROUP_PROFILE_MASK) == 0) $flags |=  &BTRFS_AVAIL_ALLOC_BIT_SINGLE; $flags; });
    }' unless defined(&chunk_to_extended);
    eval 'sub extended_to_chunk {
        my($flags) = @_;
	    eval q({ $flags & ~ &BTRFS_AVAIL_ALLOC_BIT_SINGLE; });
    }' unless defined(&extended_to_chunk);
    eval 'sub BTRFS_FREE_SPACE_USING_BITMAPS () {(1 << 0);}' unless defined(&BTRFS_FREE_SPACE_USING_BITMAPS);
    eval 'sub BTRFS_QGROUP_LEVEL_SHIFT () {48;}' unless defined(&BTRFS_QGROUP_LEVEL_SHIFT);
    eval 'sub btrfs_qgroup_level {
        my($qgroupid) = @_;
	    eval q({ ( &__u16)($qgroupid >>  &BTRFS_QGROUP_LEVEL_SHIFT); });
    }' unless defined(&btrfs_qgroup_level);
    eval 'sub BTRFS_QGROUP_STATUS_FLAG_ON () {(1 << 0);}' unless defined(&BTRFS_QGROUP_STATUS_FLAG_ON);
    eval 'sub BTRFS_QGROUP_STATUS_FLAG_RESCAN () {(1 << 1);}' unless defined(&BTRFS_QGROUP_STATUS_FLAG_RESCAN);
    eval 'sub BTRFS_QGROUP_STATUS_FLAG_INCONSISTENT () {(1 << 2);}' unless defined(&BTRFS_QGROUP_STATUS_FLAG_INCONSISTENT);
    eval 'sub BTRFS_QGROUP_STATUS_FLAG_SIMPLE_MODE () {(1 << 3);}' unless defined(&BTRFS_QGROUP_STATUS_FLAG_SIMPLE_MODE);
    eval 'sub BTRFS_QGROUP_STATUS_FLAGS_MASK () {( &BTRFS_QGROUP_STATUS_FLAG_ON |  &BTRFS_QGROUP_STATUS_FLAG_RESCAN |  &BTRFS_QGROUP_STATUS_FLAG_INCONSISTENT |  &BTRFS_QGROUP_STATUS_FLAG_SIMPLE_MODE);}' unless defined(&BTRFS_QGROUP_STATUS_FLAGS_MASK);
    eval 'sub BTRFS_QGROUP_STATUS_VERSION () {1;}' unless defined(&BTRFS_QGROUP_STATUS_VERSION);
}
1;
