# Stubs for turtle (generated from Python 3.7)

import tkinter as TK
from typing import Any, Dict, List, Optional, Tuple, Union, overload

class Vec2D(tuple):
    def __new__(cls, x: float, y: float): ...
    def __add__(self, other: Any) -> Any: ...
    def __mul__(self, other: Any) -> Any: ...
    def __rmul__(self, other: Any) -> Any: ...
    def __sub__(self, other: Any) -> Any: ...
    def __neg__(self) -> "Vec2D": ...
    def __abs__(self) -> "Vec2D": ...
    def rotate(self, angle: Any) -> "Vec2D": ...
    def __getnewargs__(self) -> Tuple[float, float]: ...

Point2D = Union[Vec2D, Tuple[float, float]]

class ScrolledCanvas(TK.Frame):
    bg = ""
    hscroll = TK.Scrollbar()
    vscroll = TK.Scrollbar()
    def __init__(
        self,
        master: TK.Widget,
        width: int = ...,
        height: int = ...,
        canvwidth: int = ...,
        canvheight: int = ...,
    ) -> None: ...
    canvwidth = 0
    canvheight = 0
    def reset(
        self,
        canvwidth: Optional[int] = ...,
        canvheight: Optional[int] = ...,
        bg: Optional[str] = ...,
    ) -> None: ...
    def adjustScrolls(self) -> None: ...
    def onResize(self, event: TK.Event) -> None: ...
    def bbox(self, *args: Any) -> Tuple[int, int, int, int]: ...
    def cget(self, *args: Any, **kwargs: Any): ...
    def config(self, *args: Any, **kwargs: Any) -> None: ...
    def bind(self, *args: Any, **kwargs: Any) -> None: ...
    def unbind(self, *args: Any, **kwargs: Any) -> None: ...
    def focus_force(self) -> None: ...

class _Root(TK.Tk):
    def __init__(self) -> None: ...
    def setupcanvas(self, width: Any, height: Any, cwidth: Any, cheight: Any) -> None: ...
    def set_geometry(self, width: Any, height: Any, startx: Any, starty: Any) -> None: ...
    def ondestroy(self, destroy: Any) -> None: ...
    def win_width(self): ...
    def win_height(self): ...

class TurtleScreenBase:
    cv = TK.Canvas()
    canvwidth = 0
    canvheight = 0
    xscale = 0.0
    def __init__(self, cv: TK.Canvas) -> None: ...
    def mainloop(self) -> None: ...
    def textinput(self, title: str, prompt: str) -> Optional[str]: ...
    def numinput(
        self,
        title: str,
        prompt: str,
        default: Optional[float] = ...,
        minval: Optional[float] = ...,
        maxval: Optional[float] = ...,
    ) -> Optional[float]: ...

class Terminator(Exception): ...
class TurtleGraphicsError(Exception): ...

class Shape:
    def __init__(self, type_: str, data: Optional[Any] = None) -> None: ...
    def addcomponent(self, poly: Any, fill: Any, outline: Optional[Any] = None) -> None: ...

class Tbuffer:
    bufsize = 0
    buffer = ...  # type: Any
    ptr = 0
    cumulate = True
    def __init__(self, bufsize: int = ...) -> None: ...
    def reset(self, bufsize: Optional[Any] = None) -> None: ...
    def push(self, item: Any) -> None: ...
    def pop(self): ...
    def nr_of_items(self): ...

class TurtleScreen(TurtleScreenBase):
    def __init__(self, cv: TK.Canvas, mode: Any, colormode: Any, delay: Any) -> None: ...
    def clear(self) -> None: ...
    xscale = 0.0
    def mode(self, mode: Optional[str] = ...) -> Optional[str]: ...
    yscale = ...  # type: Any
    def setworldcoordinates(self, llx: Any, lly: Any, urx: Any, ury: Any) -> None: ...
    def register_shape(self, name: Any, shape: Optional[Any] = None) -> None: ...
    def colormode(self, cmode: Optional[float] = ...) -> Optional[float]: ...
    def reset(self) -> None: ...
    def turtles(self) -> List["Turtle"]: ...
    def bgcolor(
        self, *args: Union[Tuple[str], Tuple[float, float, float]]
    ) -> Union[Tuple[str], Tuple[float, float, float]]: ...
    def tracer(self, n: Optional[Any] = None, delay: Optional[Any] = None): ...
    def delay(self, delay: Optional[Any] = None): ...
    def update(self) -> None: ...
    def window_width(self): ...
    def window_height(self): ...
    def getcanvas(self): ...
    def getshapes(self): ...
    def onclick(self, fun: Any, btn: int = ..., add: Optional[Any] = None) -> None: ...
    def onkey(self, fun: Any, key: Any) -> None: ...
    def onkeypress(self, fun: Any, key: Optional[Any] = None) -> None: ...
    def listen(self, xdummy: Optional[Any] = None, ydummy: Optional[Any] = None) -> None: ...
    def ontimer(self, fun: Any, t: int = ...) -> None: ...
    def bgpic(self, picname: Optional[Any] = None): ...
    def screensize(
        self,
        canvwidth: Optional[Any] = None,
        canvheight: Optional[Any] = None,
        bg: Optional[Any] = None,
    ): ...
    onscreenclick = onclick
    resetscreen = reset
    clearscreen = clear
    addshape = register_shape
    onkeyrelease = onkey

class TNavigator:
    START_ORIENTATION = {}  # type: Dict[str, Vec2D]
    DEFAULT_MODE = ""
    DEFAULT_ANGLEOFFSET = 0
    DEFAULT_ANGLEORIENT = 0
    undobuffer = ...  # type: Any
    def __init__(self, mode: str = ...) -> None: ...
    def reset(self) -> None: ...
    def degrees(self, fullcircle: float = ...) -> None: ...
    def radians(self) -> None: ...
    def forward(self, distance: float) -> None: ...
    def back(self, distance: float) -> None: ...
    def right(self, angle: float) -> None: ...
    def left(self, angle: float) -> None: ...
    def pos(self) -> Vec2D: ...
    def xcor(self) -> float: ...
    def ycor(self) -> float: ...
    @overload
    def goto(self, x: float, y: float) -> None: ...
    @overload
    def goto(self, x: Point2D) -> None: ...
    def home(self) -> None: ...
    def setx(self, x: float) -> None: ...
    def sety(self, y: float) -> None: ...
    @overload
    def distance(self, x: float, y: float) -> float: ...
    @overload
    def distance(self, x: Union[Turtle, Point2D]) -> float: ...
    @overload
    def towards(self, x: float, y: float) -> float: ...
    @overload
    def towards(self, x: Union[Turtle, Point2D]) -> float: ...
    def heading(self) -> float: ...
    def setheading(self, to_angle: float) -> None: ...
    def circle(
        self, radius: float, extent: Optional[float] = None, steps: Optional[float] = None
    ) -> None: ...
    def speed(self, s: int = ...) -> None: ...
    fd = forward
    bk = back
    backward = back
    rt = right
    lt = left
    position = pos
    setpos = goto
    setposition = goto
    seth = setheading

class TPen:
    undobuffer = ...  # type: Any
    def __init__(self, resizemode: Any) -> None: ...
    def resizemode(self, rmode: Optional[Any] = None): ...
    def pensize(self, width: Optional[Any] = None): ...
    def penup(self): ...
    def pendown(self): ...
    def isdown(self): ...
    def speed(self, speed: Optional[Any] = None): ...
    def color(self, *args: Any): ...
    def pencolor(self, *args: Any): ...
    def fillcolor(self, *args: Any): ...
    def showturtle(self) -> None: ...
    def hideturtle(self) -> None: ...
    def isvisible(self): ...
    def pen(self, pen: Optional[Any] = None, **pendict: Any): ...
    width = pensize
    up = penup
    pu = penup
    pd = pendown
    down = pendown
    st = showturtle
    ht = hideturtle

class _TurtleImage:
    screen = ...  # type: Any
    def __init__(self, screen: Any, shapeIndex: Any) -> None: ...

class RawTurtle(TPen, TNavigator):
    screens = ...  # type: Any
    screen = ...  # type: Any
    drawingLineItem = ...  # type: Any
    turtle = ...  # type: Any
    currentLineItem = ...  # type: Any
    currentLine = ...  # type: Any
    items = ...  # type: Any
    stampItems = ...  # type: Any
    undobuffer = ...  # type: Any
    def __init__(
        self,
        canvas: Optional[Any] = None,
        shape: Any = None,
        undobuffersize: Any = None,
        visible: Any = None,
    ) -> None: ...
    def reset(self) -> None: ...
    def setundobuffer(self, size: Any) -> None: ...
    def undobufferentries(self): ...
    def clear(self) -> None: ...
    def clone(self): ...
    def shape(self, name: Optional[Any] = None): ...
    def shapesize(
        self,
        stretch_wid: Optional[Any] = None,
        stretch_len: Optional[Any] = None,
        outline: Optional[Any] = None,
    ): ...
    def shearfactor(self, shear: Optional[Any] = None): ...
    def settiltangle(self, angle: Any) -> None: ...
    def tiltangle(self, angle: Optional[Any] = None): ...
    def tilt(self, angle: Any) -> None: ...
    def shapetransform(
        self,
        t11: Optional[Any] = None,
        t12: Optional[Any] = None,
        t21: Optional[Any] = None,
        t22: Optional[Any] = None,
    ): ...
    def get_shapepoly(self): ...
    def stamp(self): ...
    def clearstamp(self, stampid: Any) -> None: ...
    def clearstamps(self, n: Optional[Any] = None) -> None: ...
    def filling(self): ...
    def begin_fill(self) -> None: ...
    def end_fill(self) -> None: ...
    def dot(self, size: Optional[Any] = None, *color: Any) -> None: ...
    def write(self, arg: Any, move: bool = ..., align: str = ..., font: Any = None) -> None: ...
    def begin_poly(self) -> None: ...
    def end_poly(self) -> None: ...
    def get_poly(self): ...
    def getscreen(self): ...
    def getturtle(self): ...
    getpen = ...  # type: Any
    def onclick(self, fun: Any, btn: int = ..., add: Optional[Any] = None) -> None: ...
    def onrelease(self, fun: Any, btn: int = ..., add: Optional[Any] = None) -> None: ...
    def ondrag(self, fun: Any, btn: int = ..., add: Optional[Any] = None) -> None: ...
    def undo(self): ...
    turtlesize = shapesize

RawPen = RawTurtle

class _Screen(TurtleScreen):
    def __init__(self) -> None: ...
    def setup(self, width: Any, height: Any, startx: Any, starty: Any): ...
    def title(self, titlestring: Any) -> None: ...
    def bye(self) -> None: ...
    def exitonclick(self): ...

def Screen() -> _Screen: ...

class Turtle(RawTurtle):
    def __init__(self, shape: Any, undobuffersize: Any, visible: Any) -> None: ...

Pen = Turtle

def write_docstringdict(filename: str = ...) -> None: ...

_screen = Screen()
_turtle = Turtle()

addshape = _screen.addshape
bgcolor = _screen.bgcolor
bgpic = _screen.bgpic
bye = _screen.bye
clearscreen = _screen.clearscreen
colormode = _screen.colormode
delay = _screen.delay
exitonclick = _screen.exitonclick
getcanvas = _screen.getcanvas
getshapes = _screen.getshapes
listen = _screen.listen
mainloop = _screen.mainloop
mode = _screen.mode
numinput = _screen.numinput
onkey = _screen.onkey
onkeypress = _screen.onkeypress
onkeyrelease = _screen.onkeyrelease
onscreenclick = _screen.onscreenclick
ontimer = _screen.ontimer
register_shape = _screen.register_shape
resetscreen = _screen.resetscreen
screensize = _screen.screensize
setup = _screen.setup
setworldcoordinates = _screen.setworldcoordinates
textinput = _screen.textinput
title = _screen.title
tracer = _screen.tracer
turtles = _screen.turtles
update = _screen.update
window_height = _screen.window_height
window_width = _screen.window_width

done = mainloop

back = _turtle.back
backward = _turtle.backward
begin_fill = _turtle.begin_fill
begin_poly = _turtle.begin_poly
bk = _turtle.bk
circle = _turtle.circle
clear = _turtle.clear
clearstamp = _turtle.clearstamp
clearstamps = _turtle.clearstamps
clone = _turtle.clone
color = _turtle.color
degrees = _turtle.degrees
distance = _turtle.distance
dot = _turtle.dot
down = _turtle.down
end_fill = _turtle.end_fill
end_poly = _turtle.end_poly
fd = _turtle.fd
fillcolor = _turtle.fillcolor
filling = _turtle.filling
forward = _turtle.forward
get_poly = _turtle.get_poly
get_shapepoly = _turtle.get_shapepoly
getpen = _turtle.getpen
getscreen = _turtle.getscreen
getturtle = _turtle.getturtle
goto = _turtle.goto
heading = _turtle.heading
hideturtle = _turtle.hideturtle
home = _turtle.home
ht = _turtle.ht
isdown = _turtle.isdown
isvisible = _turtle.isvisible
left = _turtle.left
lt = _turtle.lt
onclick = _turtle.onclick
ondrag = _turtle.ondrag
onrelease = _turtle.onrelease
pd = _turtle.pd
pen = _turtle.pen
pencolor = _turtle.pencolor
pendown = _turtle.pendown
pensize = _turtle.pensize
penup = _turtle.penup
pos = _turtle.pos
position = _turtle.position
pu = _turtle.pu
radians = _turtle.radians
reset = _turtle.reset
resizemode = _turtle.resizemode
right = _turtle.right
rt = _turtle.rt
seth = _turtle.seth
setheading = _turtle.setheading
setpos = _turtle.setpos
setposition = _turtle.setposition
settiltangle = _turtle.settiltangle
setundobuffer = _turtle.setundobuffer
setx = _turtle.setx
sety = _turtle.sety
shape = _turtle.shape
shapesize = _turtle.shapesize
shapetransform = _turtle.shapetransform
shearfactor = _turtle.shearfactor
showturtle = _turtle.showturtle
speed = _turtle.speed
st = _turtle.st
stamp = _turtle.stamp
tilt = _turtle.tilt
tiltangle = _turtle.tiltangle
towards = _turtle.towards
turtlesize = _turtle.turtlesize
undo = _turtle.undo
undobufferentries = _turtle.undobufferentries
up = _turtle.up
width = _turtle.width
write = _turtle.write
xcor = _turtle.xcor
ycor = _turtle.ycor
