.TH "ZIP_FILE_EXTRA_FIELD_DELETE" "3" "July 31, 2013" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_file_extra_field_delete\fP,
\fBzip_file_extra_field_delete_by_id\fP
\- delete extra field for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
int
zip_file_extra_field_delete zip_t *archive zip_uint64_t index zip_uint16_t extra_field_index zip_flags_t flags
int
zip_file_extra_field_delete_by_id zip_t *archive zip_uint64_t index zip_uint16_t extra_field_id zip_uint16_t extra_field_index zip_flags_t flags
.SH "DESCRIPTION"
The
zip_file_extra_field_delete
function deletes the extra field with index
\fIextra_field_index\fP
for the file at position
\fIindex\fP
in the zip archive.
.PP
If
\fIextra_field_index\fP
is
\fRZIP_EXTRA_FIELD_ALL\fP,
then all extra fields will be deleted.
.PP
The following
\fIflags\fP
are supported:
.TP ZIP_FL_CENTRALXX
\fRZIP_FL_CENTRAL\fP
Delete extra fields from the archive's central directory.
.TP ZIP_FL_CENTRALXX
\fRZIP_FL_LOCAL\fP
Delete extra fields from the local file headers.
.PP
The
zip_file_extra_field_delete_by_id
function deletes the extra field with ID (two-byte signature)
\fIextra_field_id\fP
and index
\fIextra_field_index\fP
(in other words, the
\fIextra_field_index\fP'th
extra field with ID
\fIextra_field_id\fP)
The other arguments are the same as for
zip_file_extra_field_delete
(\fRZIP_EXTRA_FIELD_ALL\fP
will delete all extra fields of the specified ID).
.PP
Please note that due to the library design, the index of an extra
field may be different between central directory and local file
headers.
For this reason, it is not allowed to specify both
\fRZIP_FL_CENTRAL\fP
and
\fRZIP_FL_LOCAL\fP
in
\fIflags\fP,
except when deleting all extra fields (i.e.,
\fIextra_field_index\fP
being
\fRZIP_EXTRA_FIELD_ALL\fP).
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error code in
\fIarchive\fP
is set to indicate the error.
.SH "ERRORS"
zip_file_extra_field_delete
and
zip_file_extra_field_delete_by_id
fail if:
.TP 17n
[\fRZIP_ER_NOENT\fP]
\fIindex\fP
is not a valid file index in
\fIarchive\fP.
.SH "SEE ALSO"
libzip(3),
zip_file_extra_field_get(3),
zip_file_extra_field_set(3),
zip_file_extra_fields_count(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
